/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockTerraPlate extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 3, 16);

	public BlockTerraPlate(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960()
				&& (stack.method_7909() == ModItems.manaSteel || stack.method_7909() == ModItems.manaPearl || stack.method_7909() == ModItems.manaDiamond)) {
			if (!world.field_9236) {
				class_1799 target = stack.method_7971(1);
				class_1542 item = new class_1542(world, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, target);
				item.method_6982(40);
				item.method_18799(class_243.field_1353);
				world.method_8649(item);
			}

			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public boolean method_9516(@Nonnull class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos, class_10 type) {
		return false;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileTerraPlate();
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TileTerraPlate plate = (TileTerraPlate) world.method_8321(pos);
		return plate.getComparatorLevel();
	}

}
