/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import com.google.common.collect.ImmutableList;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.List;

public class BlockSpreader extends BlockModWaterloggable implements class_2343, IWandable, IWandHUD, IWireframeAABBProvider {
	private static final class_265 RENDER_SHAPE = method_9541(1, 1, 1, 15, 15, 15);

	public enum Variant {
		MANA(160, 1000, 0x20FF20, 0x00FF00, 60, 4f, 1f),
		REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4f, 1f),
		ELVEN(240, 1000, 0xFF45C4, 0xFF00AE, 80, 4f, 1.25f),
		GAIA(640, 6400, 0x20FF20, 0x00FF00, 120, 20f, 2f);

		public final int burstMana;
		public final int manaCapacity;
		public final int color;
		public final int hudColor;
		public final int preLossTicks;
		public final float lossPerTick;
		public final float motionModifier;

		private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
			burstMana = bm;
			manaCapacity = mc;
			color = c;
			hudColor = hc;
			preLossTicks = plt;
			lossPerTick = lpt;
			motionModifier = mm;
		}
	}

	public final Variant variant;

	public BlockSpreader(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@Nonnull
	@Override
	public class_265 method_9571(class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos) {
		return RENDER_SHAPE;
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
		class_2350 orientation = placer == null ? class_2350.field_11039 : class_2350.method_10159(placer)[0].method_10153();
		TileSpreader spreader = (TileSpreader) world.method_8321(pos);

		switch (orientation) {
		case field_11033:
			spreader.rotationY = -90F;
			break;
		case field_11036:
			spreader.rotationY = 90F;
			break;
		case field_11043:
			spreader.rotationX = 270F;
			break;
		case field_11035:
			spreader.rotationX = 90F;
			break;
		case field_11039:
			break;
		case field_11034:
			spreader.rotationX = 180F;
			break;
		}
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		if (!(tile instanceof TileSpreader)) {
			return class_1269.field_5811;
		}

		TileSpreader spreader = (TileSpreader) tile;
		class_1799 lens = spreader.getItemHandler().method_5438(0);
		class_1799 heldItem = player.method_5998(hand);
		boolean isHeldItemLens = !heldItem.method_7960() && heldItem.method_7909() instanceof ILens;
		boolean wool = !heldItem.method_7960() && ColorHelper.isWool(class_2248.method_9503(heldItem.method_7909()));

		if (!heldItem.method_7960()) {
			if (heldItem.method_7909() == ModItems.twigWand) {
				return class_1269.field_5811;
			}
		}

		if (lens.method_7960() && isHeldItemLens) {
			if (!player.field_7503.field_7477) {
				player.method_6122(hand, class_1799.field_8037);
			}

			spreader.getItemHandler().method_5447(0, heldItem.method_7972());
		} else if (!lens.method_7960() && !wool) {
			player.field_7514.method_7398(player.field_6002, lens);
			spreader.getItemHandler().method_5447(0, class_1799.field_8037);
		}

		if (wool && spreader.paddingColor == null) {
			class_2248 block = class_2248.method_9503(heldItem.method_7909());
			spreader.paddingColor = ColorHelper.getWoolColor(block);
			heldItem.method_7934(1);
			if (heldItem.method_7960()) {
				player.method_6122(hand, class_1799.field_8037);
			}
		} else if (heldItem.method_7960() && spreader.paddingColor != null && lens.method_7960()) {
			class_1799 pad = new class_1799(ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
			player.field_7514.method_7398(player.field_6002, pad);
			spreader.paddingColor = null;
			spreader.method_5431();
		}

		return class_1269.field_5812;
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 tile = world.method_8321(pos);
			if (!(tile instanceof TileSpreader)) {
				return;
			}

			TileSpreader inv = (TileSpreader) tile;

			if (inv.paddingColor != null) {
				class_1799 padding = new class_1799(ColorHelper.WOOL_MAP.apply(inv.paddingColor));
				world.method_8649(new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), padding));
			}

			class_1264.method_5451(world, pos, inv.getItemHandler());

			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		((TileSpreader) world.method_8321(pos)).onWanded(player, stack);
		return true;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileSpreader();
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileSpreader) world.method_8321(pos)).renderHUD(ms, mc);
	}

	@Override
	public List<class_238> getWireframeAABB(class_1937 world, class_2338 pos) {
		return ImmutableList.of(new class_238(pos).method_1011(1.0 / 16.0));
	}
}
