/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

import javax.annotation.Nonnull;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockRuneAltar extends BlockModWaterloggable implements class_2343, IWandable {

	private static final class_265 TOP = class_2248.method_9541(0, 6, 0, 16, 12, 16);
	private static final class_265 BOTTOM = class_2248.method_9541(2, 0, 2, 14, 6, 14);
	private static final class_265 SHAPE = class_259.method_1072(TOP, BOTTOM, class_247.field_1366);

	public BlockRuneAltar(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		if (world.field_9236) {
			return class_1269.field_5812;
		}

		TileRuneAltar altar = (TileRuneAltar) world.method_8321(pos);
		class_1799 stack = player.method_5998(hand);

		if (player.method_5715()) {
			if (altar.manaToGet == 0) {
				InventoryHelper.withdrawFromInventory(altar, player);
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
				return class_1269.field_5812;
			}
		} else if (altar.isEmpty() && stack.method_7960()) {
			altar.trySetLastRecipe(player);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
			return class_1269.field_5812;
		} else if (!stack.method_7960()) {
			boolean result = altar.addItem(player, stack, hand);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
			return result ? class_1269.field_5812 : class_1269.field_5811;
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileRuneAltar();
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TileRuneAltar altar = (TileRuneAltar) world.method_8321(pos);
		return altar.signal;
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		((TileRuneAltar) world.method_8321(pos)).onWanded(player, stack);
		return true;
	}

}
