/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.core.ExtendedShapeContext;
import vazkii.botania.common.entity.EntityManaBurst;

import javax.annotation.Nonnull;

public class BlockPrism extends BlockModWaterloggable implements class_2343, IManaTrigger, IManaCollisionGhost, IWandHUD {
	private static final class_265 SHAPE = method_9541(4, 0, 4, 12, 16, 12);

	public BlockPrism(class_2251 builder) {
		super(builder);
		method_9590(method_9564()
				.method_11657(class_2741.field_12484, false)
				.method_11657(BotaniaStateProps.HAS_LENS, false));
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Nonnull
	@Override
	public class_265 method_9549(@Nonnull class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_3726 context) {
		if (ExtendedShapeContext.getEntity(context) instanceof EntityManaBurst) {
			// Expose the shape so bursts can actually collide with us
			// they will still go through the prism via IManaCollisionGhost
			return SHAPE;
		} else {
			return super.method_9549(state, world, pos, context);
		}
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484, BotaniaStateProps.HAS_LENS);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		if (!(tile instanceof TilePrism)) {
			return class_1269.field_5811;
		}

		TilePrism prism = (TilePrism) tile;
		class_1799 lens = prism.getItemHandler().method_5438(0);
		class_1799 heldItem = player.method_5998(hand);
		boolean isHeldItemLens = !heldItem.method_7960() && heldItem.method_7909() instanceof ILens;

		if (lens.method_7960() && isHeldItemLens) {
			if (!player.field_7503.field_7477) {
				player.method_6122(hand, class_1799.field_8037);
			}

			prism.getItemHandler().method_5447(0, heldItem.method_7972());
		} else if (!lens.method_7960()) {
			player.field_7514.method_7398(player.field_6002, lens);
			prism.getItemHandler().method_5447(0, class_1799.field_8037);
		}

		return class_1269.field_5812;
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0 || world.method_8482(pos.method_10084()) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (!world.field_9236) {
			if (power && !powered) {
				world.method_8501(pos, state.method_11657(class_2741.field_12484, true));
			} else if (!power && powered) {
				world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
			}
		}
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TilePrism();
	}

	@Override
	public void onBurstCollision(IManaBurst burst, class_1937 world, class_2338 pos) {
		class_2586 tile = world.method_8321(pos);
		if (tile instanceof TilePrism) {
			((TilePrism) tile).onBurstCollision(burst);
		}
	}

	@Override
	public boolean isGhost(class_2680 state, class_1937 world, class_2338 pos) {
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		class_2586 te = world.method_8321(pos);
		if (te instanceof TilePrism) {
			class_1799 lens = ((TilePrism) te).method_5438(0);
			if (!lens.method_7960()) {
				class_2561 lensName = lens.method_7964();
				int width = 16 + mc.field_1772.method_27525(lensName) / 2;
				int x = mc.method_22683().method_4486() / 2 - width;
				int y = mc.method_22683().method_4502() / 2;

				mc.field_1772.method_30881(ms, lensName, x + 20, y + 5, -1);
				mc.method_1480().method_4023(lens, x, y);
			}
		}
	}
}
