/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_47;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.ExtendedShapeContext;
import vazkii.botania.common.entity.EntityManaBurst;

import javax.annotation.Nonnull;

import java.util.Collections;
import java.util.List;

public class BlockPool extends BlockModWaterloggable implements class_2343, IWandHUD, IWandable {
	private static final class_265 REAL_SHAPE;
	private static final class_265 BURST_SHAPE;
	static {
		class_265 slab = method_9541(0, 0, 0, 16, 8, 16);
		class_265 cutout = method_9541(1, 1, 1, 15, 8, 15);
		class_265 cutoutBurst = method_9541(1, 6, 1, 15, 8, 15);
		BURST_SHAPE = class_259.method_1072(slab, cutoutBurst, class_247.field_16886);
		REAL_SHAPE = class_259.method_1072(slab, cutout, class_247.field_16886);
	}

	public enum Variant {
		DEFAULT,
		CREATIVE,
		DILUTED,
		FABULOUS
	}

	public final Variant variant;

	public BlockPool(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return REAL_SHAPE;
	}

	@Override
	public List<class_1799> method_9560(@Nonnull class_2680 state, class_47.class_48 builder) {
		if (builder.method_305(class_181.field_1228) instanceof TilePool
				&& ((TilePool) builder.method_305(class_181.field_1228)).fragile) {
			return Collections.emptyList();
		} else {
			return super.method_9560(state, builder);
		}
	}

	@Nonnull
	@Override
	public class_1269 method_9534(@Nonnull class_2680 state, class_1937 world, @Nonnull class_2338 pos, class_1657 player, @Nonnull class_1268 hand, @Nonnull class_3965 hit) {
		class_2586 te = world.method_8321(pos);
		class_1799 stack = player.method_5998(hand);
		if (stack.method_7909() instanceof class_1769 && te instanceof TilePool) {
			class_1767 color = ((class_1769) stack.method_7909()).method_7802();
			if (color != ((TilePool) te).getColor()) {
				((TilePool) te).setColor(color);
				stack.method_7934(1);
				return class_1269.field_5812;
			}
		}
		return super.method_9534(state, world, pos, player, hand, hit);
	}

	@Override
	public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		if (ExtendedShapeContext.getEntity(context) instanceof EntityManaBurst) {
			// Sometimes the pool's collision box is too thin for bursts shot straight up.
			return BURST_SHAPE;
		} else {
			return super.method_9549(state, world, pos, context);
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TilePool();
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
		if (entity instanceof class_1542) {
			TilePool tile = (TilePool) world.method_8321(pos);
			tile.collideEntityItem((class_1542) entity);
		}
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		if (variant == Variant.FABULOUS) {
			return class_2464.field_11456;
		} else {
			return class_2464.field_11458;
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TilePool pool = (TilePool) world.method_8321(pos);
		return TilePool.calculateComparatorLevel(pool.getCurrentMana(), pool.manaCap);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TilePool) world.method_8321(pos)).renderHUD(ms, mc);
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		((TilePool) world.method_8321(pos)).onWanded(player);
		return true;
	}
}
