/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.mana.TileManaDetector;
import vazkii.botania.common.core.ExtendedShapeContext;

import javax.annotation.Nonnull;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;

public class BlockManaDetector extends BlockMod implements IManaCollisionGhost, class_2343 {

	public BlockManaDetector(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
		return state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@Nonnull
	@Override
	public class_265 method_9549(@Nonnull class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos,
			class_3726 context) {
		if (ExtendedShapeContext.getEntity(context) instanceof IManaBurst) {
			return class_259.method_1073();
		} else {
			return super.method_9549(state, world, pos, context);
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileManaDetector();
	}

	@Override
	public boolean isGhost(class_2680 state, class_1937 world, class_2338 pos) {
		return true;
	}
}
