/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

public class BlockEnchanter extends BlockMod implements class_2343, IWandable, IWandHUD {

	public BlockEnchanter(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(BotaniaStateProps.ENCHANTER_DIRECTION, class_2350.class_2351.field_11048));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(BotaniaStateProps.ENCHANTER_DIRECTION);
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileEnchanter();
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileEnchanter enchanter = (TileEnchanter) world.method_8321(pos);
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && stack.method_7909() == ModItems.twigWand) {
			return class_1269.field_5811;
		}

		boolean stackEnchantable = !stack.method_7960()
				&& stack.method_7909() != class_1802.field_8529
				&& stack.method_7923()
				&& stack.method_7947() == 1;

		if (enchanter.itemToEnchant.method_7960()) {
			if (stackEnchantable) {
				enchanter.itemToEnchant = stack.method_7972();
				player.method_6122(hand, class_1799.field_8037);
				enchanter.sync();
			} else {
				return class_1269.field_5811;
			}
		} else if (enchanter.stage == TileEnchanter.State.IDLE) {
			player.field_7514.method_7398(player.field_6002, enchanter.itemToEnchant.method_7972());
			enchanter.itemToEnchant = class_1799.field_8037;
			enchanter.sync();
		}

		return class_1269.field_5812;
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 tile = world.method_8321(pos);

			if (tile instanceof TileEnchanter) {
				TileEnchanter enchanter = (TileEnchanter) tile;

				if (!enchanter.itemToEnchant.method_7960()) {
					world.method_8649(new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), enchanter.itemToEnchant));
				}
			}

			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		((TileEnchanter) world.method_8321(pos)).onWanded(player, stack);
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileEnchanter) world.method_8321(pos)).renderHUD(ms);
	}
}
