/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileBrewery;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

import javax.annotation.Nonnull;

public class BlockBrewery extends BlockModWaterloggable implements class_2343, IWandHUD {

	private static final class_265 SHAPE = method_9541(6, 0.8, 6, 10, 15.2, 10);

	public BlockBrewery(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileBrewery brew = (TileBrewery) world.method_8321(pos);

		if (player.method_5715()) {
			if (brew.recipe == null && !state.method_11654(class_2741.field_12484)) {
				InventoryHelper.withdrawFromInventory(brew, player);
				return class_1269.field_5812;
			}
		} else {
			class_1799 stack = player.method_5998(hand);
			if (!stack.method_7960()) {
				return brew.addItem(player, stack, hand) ? class_1269.field_5812 : class_1269.field_5811;
			}
		}
		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TileBrewery brew = (TileBrewery) world.method_8321(pos);
		return brew.signal;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileBrewery();
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileBrewery) world.method_8321(pos)).renderHUD(ms, mc);
	}

}
