/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.TileTinyPotato;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockTinyPotato extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(6, 0, 6, 10, 6, 10);

	public BlockTinyPotato(class_2251 builder) {
		super(builder);
		method_9590(method_9564()
				.method_11657(class_2741.field_12481, class_2350.field_11035));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12481);
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		if (tile instanceof TileTinyPotato) {
			((TileTinyPotato) tile).interact(player, hand, player.method_5998(hand), hit.method_17780());
			if (!world.field_9236) {
				class_238 box = SHAPE.method_1107();
				((class_3218) world).method_14199(class_2398.field_11201, pos.method_10263() + box.field_1323 + Math.random() * (box.field_1320 - box.field_1323), pos.method_10264() + box.field_1325, pos.method_10260() + box.field_1321 + Math.random() * (box.field_1324 - box.field_1321), 1, 0, 0, 0, 0);
			}
		}
		return class_1269.field_5812;
	}

	@Nonnull
	@Override
	public class_2680 method_9605(class_1750 ctx) {
		return super.method_9605(ctx).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 living, class_1799 stack) {
		if (stack.method_7938()) {
			((TileTinyPotato) world.method_8321(pos)).name = stack.method_7964();
		}
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileTinyPotato();
	}
}
