/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2420;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ColorHelper;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockModMushroom extends class_2420 implements IHornHarvestable, ICustomApothecaryColor {

	private static final class_265 SHAPE = method_9541(4.8, 0, 4.8, 12.8, 16, 12.8);
	public final class_1767 color;

	public BlockModMushroom(class_1767 color, class_2251 builder) {
		super(builder);
		this.color = color;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return field_11304;
	}

	// [VanillaCopy] super, without light level requirement
	@Override
	public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
		class_2338 blockpos = pos.method_10074();
		class_2680 blockstate = worldIn.method_8320(blockpos);
		if (!blockstate.method_26164(class_3481.field_25739)) {
			return this.method_9695(blockstate, worldIn, blockpos);
		} else {
			return true;
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {
		int hex = ColorHelper.getColorValue(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		if (rand.nextDouble() < ConfigHandler.CLIENT.flowerParticleFrequency.getValue() * 0.25F) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, pos.method_10263() + 0.3 + rand.nextFloat() * 0.5, pos.method_10264() + 0.5 + rand.nextFloat() * 0.5, pos.method_10260() + 0.3 + rand.nextFloat() * 0.5, 0, 0, 0);
		}
	}

	@Override
	public boolean canHornHarvest(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType) {
		return false;
	}

	@Override
	public boolean hasSpecialHornHarvest(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType) {
		return false;
	}

	@Override
	public void harvestByHorn(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType) {}

	@Override
	public int getParticleColor(class_1799 stack) {
		return ColorHelper.getColorValue(color);
	}
}
