/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import java.util.Random;

public class BlockManaFlame extends BlockMod implements class_2343 {

	private static final class_265 SHAPE = method_9541(4, 4, 4, 12, 12, 12);

	public BlockManaFlame(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11455;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		if (Botania.gardenOfGlassLoaded) {
			class_1799 stack = player.method_5998(hand);
			if (!stack.method_7960() && class_3489.field_15528.method_15141(stack.method_7909()) && !player.field_7514.method_7379(new class_1799(ModItems.lexicon))) {
				if (!world.field_9236) {
					stack.method_7934(1);
					player.field_7514.method_7398(player.field_6002, new class_1799(ModItems.lexicon));
				}
				return class_1269.field_5812;
			}

		}
		return class_1269.field_5811;
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {
		class_2586 te = world.method_8321(pos);
		if (te instanceof TileManaFlame) {
			int color = ((TileManaFlame) te).getColor();
			float v = 0.1F;

			float r = (float) (color >> 16 & 0xFF) / 0xFF;
			float g = (float) (color >> 8 & 0xFF) / 0xFF;
			float b = (float) (color & 0xFF) / 0xFF;

			double luminance = 0.2126 * r + 0.7152 * g + 0.0722 * b; // Standard relative luminance calculation

			if (luminance < v) {
				r += (float) Math.random() * 0.125F;
				g += (float) Math.random() * 0.125F;
				b += (float) Math.random() * 0.125F;
			}

			float w = 0.15F;
			float h = 0.05F;
			double x = pos.method_10263() + 0.5 + (Math.random() - 0.5) * w;
			double y = pos.method_10264() + 0.25 + (Math.random() - 0.5) * h;
			double z = pos.method_10260() + 0.5 + (Math.random() - 0.5) * w;

			float s = 0.2F + (float) Math.random() * 0.1F;
			float m = 0.03F + (float) Math.random() * 0.015F;

			WispParticleData data = WispParticleData.wisp(s, r, g, b, 1);
			world.method_8406(data, x, y, z, 0, m, 0);
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileManaFlame();
	}
}
