/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.item.IFloatingFlower.IslandType;
import vazkii.botania.api.item.IFloatingFlowerProvider;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.item.IFloatingFlowerVariant;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockFloatingFlower extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(1.6, 1.6, 1.6, 14.4, 14.4, 14.4);
	public final class_1767 color;

	public BlockFloatingFlower(class_1767 color, class_2251 props) {
		super(props);
		this.color = color;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return ConfigHandler.CLIENT.staticFloaters.getValue() ? class_2464.field_11458 : class_2464.field_11456;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {
		int hex = ColorHelper.getColorValue(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		if (rand.nextDouble() < ConfigHandler.CLIENT.flowerParticleFrequency.getValue()) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, pos.method_10263() + 0.3 + rand.nextFloat() * 0.5, pos.method_10264() + 0.5 + rand.nextFloat() * 0.5, pos.method_10260() + 0.3 + rand.nextFloat() * 0.5, 0, 0, 0);
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		class_2586 te = world.method_8321(pos);
		if (!stack.method_7960() && te instanceof IFloatingFlowerProvider && ((IFloatingFlowerProvider) te).getFloatingData() != null) {
			IFloatingFlower flower = ((IFloatingFlowerProvider) te).getFloatingData();
			IslandType type = null;
			if (stack.method_7909() == class_1802.field_8543) {
				type = IslandType.SNOW;
			} else if (stack.method_7909() instanceof IFloatingFlowerVariant) {
				IslandType newType = ((IFloatingFlowerVariant) stack.method_7909()).getIslandType(stack);
				if (newType != null) {
					type = newType;
				}
			}

			if (type != null && type != flower.getIslandType()) {
				if (!world.field_9236) {
					flower.setIslandType(type);
					VanillaPacketDispatcher.dispatchTEToNearbyPlayers(te);
				}

				if (!player.field_7503.field_7477) {
					stack.method_7934(1);
				}
				return class_1269.field_5812;
			}
		}
		return class_1269.field_5811;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileFloatingFlower();
	}
}
