/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.corporea;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;

import javax.annotation.Nonnull;

public class BlockCorporeaRetainer extends BlockMod implements class_2343, IWandable, IWandHUD {

	public BlockCorporeaRetainer(class_4970.class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0 || world.method_8482(pos.method_10084()) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			((TileCorporeaRetainer) world.method_8321(pos)).fulfilRequest();
			world.method_8501(pos, state.method_11657(class_2741.field_12484, true));
		} else if (!power && powered) {
			world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((TileCorporeaRetainer) world.method_8321(pos)).getComparatorValue();
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileCorporeaRetainer();
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		class_2586 te = world.method_8321(pos);
		if (te instanceof TileCorporeaRetainer) {
			((TileCorporeaRetainer) te).renderHUD(ms, mc);
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		class_2586 te = world.method_8321(pos);
		return te instanceof TileCorporeaRetainer && ((TileCorporeaRetainer) te).onUsedByWand();
	}
}
