/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.corporea;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2588;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

public class BlockCorporeaCrystalCube extends BlockModWaterloggable implements class_2343, IWandable {

	private static final class_265 SHAPE = method_9541(3.0, 0, 3.0, 13.0, 16, 13.0);

	public BlockCorporeaCrystalCube(class_4970.class_2251 builder) {
		super(builder);
	}

	@Override
	public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
		if (!world.field_9236) {
			TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube) world.method_8321(pos);
			cube.doRequest(player.method_5715());
		}
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960()) {
			if (stack.method_7909() == ModItems.twigWand && player.method_5715()) {
				return class_1269.field_5811;
			}
			TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube) world.method_8321(pos);
			if (cube.locked) {
				if (!world.field_9236) {
					player.method_7353(new class_2588("botaniamisc.crystalCubeLocked"), false);
				}
			} else {
				cube.setRequestTarget(stack);
			}
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		if (player == null || player.method_5715()) {
			TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube) world.method_8321(pos);
			cube.locked = !cube.locked;
			if (!world.field_9236) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(cube);
			}
			return true;
		}
		return false;
	}

	@Nonnull
	@Override
	public TileCorporeaBase method_10123(@Nonnull class_1922 world) {
		return new TileCorporeaCrystalCube();
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((TileCorporeaCrystalCube) world.method_8321(pos)).getComparatorValue();
	}
}
