/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.subtile.SubTileManastar;
import vazkii.botania.common.block.subtile.SubTilePureDaisy;
import vazkii.botania.common.block.subtile.functional.*;
import vazkii.botania.common.block.subtile.generating.*;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.lib.LibBlockNames;

import static vazkii.botania.common.block.ModBlocks.register;

import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class ModSubtiles {
	private static final class_4970.class_2251 FLOWER_PROPS = class_4970.class_2251.method_9630(class_2246.field_10449);
	private static final class_4970.class_2251 FLOATING_PROPS = ModBlocks.FLOATING_PROPS;

	public static final class_2248 pureDaisy = new BlockSpecialFlower(ModPotions.clear, 1, FLOWER_PROPS, SubTilePureDaisy::new);
	public static final class_2248 pureDaisyFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTilePureDaisy::new);

	public static final class_2248 manastar = new BlockSpecialFlower(class_1294.field_5912, 10, FLOWER_PROPS, SubTileManastar::new);
	public static final class_2248 manastarFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileManastar::new);

	public static final class_2248 hydroangeas = new BlockSpecialFlower(class_1294.field_5908, 10, FLOWER_PROPS, SubTileHydroangeas::new);
	public static final class_2248 hydroangeasFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileHydroangeas::new);

	public static final class_2248 endoflame = new BlockSpecialFlower(class_1294.field_5909, 10, FLOWER_PROPS, SubTileEndoflame::new);
	public static final class_2248 endoflameFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileEndoflame::new);

	public static final class_2248 thermalily = new BlockSpecialFlower(class_1294.field_5918, 120, FLOWER_PROPS, SubTileThermalily::new);
	public static final class_2248 thermalilyFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileThermalily::new);

	public static final class_2248 rosaArcana = new BlockSpecialFlower(class_1294.field_5926, 64, FLOWER_PROPS, SubTileArcaneRose::new);
	public static final class_2248 rosaArcanaFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileArcaneRose::new);

	public static final class_2248 munchdew = new BlockSpecialFlower(class_1294.field_5906, 300, FLOWER_PROPS, SubTileMunchdew::new);
	public static final class_2248 munchdewFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileMunchdew::new);

	public static final class_2248 entropinnyum = new BlockSpecialFlower(class_1294.field_5907, 72, FLOWER_PROPS, SubTileEntropinnyum::new);
	public static final class_2248 entropinnyumFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileEntropinnyum::new);

	public static final class_2248 kekimurus = new BlockSpecialFlower(class_1294.field_5922, 15, FLOWER_PROPS, SubTileKekimurus::new);
	public static final class_2248 kekimurusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileKekimurus::new);

	public static final class_2248 gourmaryllis = new BlockSpecialFlower(class_1294.field_5903, 180, FLOWER_PROPS, SubTileGourmaryllis::new);
	public static final class_2248 gourmaryllisFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileGourmaryllis::new);

	public static final class_2248 narslimmus = new BlockSpecialFlower(ModPotions.featherfeet, 240, FLOWER_PROPS, SubTileNarslimmus::new);
	public static final class_2248 narslimmusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileNarslimmus::new);

	public static final class_2248 spectrolus = new BlockSpecialFlower(class_1294.field_5919, 240, FLOWER_PROPS, SubTileSpectrolus::new);
	public static final class_2248 spectrolusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileSpectrolus::new);

	public static final class_2248 dandelifeon = new BlockSpecialFlower(class_1294.field_5916, 240, FLOWER_PROPS, SubTileDandelifeon::new);
	public static final class_2248 dandelifeonFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileDandelifeon::new);

	public static final class_2248 rafflowsia = new BlockSpecialFlower(class_1294.field_5914, 18, FLOWER_PROPS, SubTileRafflowsia::new);
	public static final class_2248 rafflowsiaFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileRafflowsia::new);

	public static final class_2248 shulkMeNot = new BlockSpecialFlower(class_1294.field_5902, 72, FLOWER_PROPS, SubTileShulkMeNot::new);
	public static final class_2248 shulkMeNotFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileShulkMeNot::new);

	public static final class_2248 bellethorn = new BlockSpecialFlower(class_1294.field_5920, 10, FLOWER_PROPS, SubTileBellethorn::new);
	public static final class_2248 bellethornChibi = new BlockSpecialFlower(class_1294.field_5920, 10, FLOWER_PROPS, SubTileBellethorn.Mini::new);
	public static final class_2248 bellethornFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileBellethorn::new);
	public static final class_2248 bellethornChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileBellethorn.Mini::new);

	public static final class_2248 bergamute = new BlockSpecialFlower(class_1294.field_5919, 10, FLOWER_PROPS, SubTileBergamute::new);
	public static final class_2248 bergamuteFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileBergamute::new);

	public static final class_2248 dreadthorn = new BlockSpecialFlower(class_1294.field_5920, 10, FLOWER_PROPS, SubTileDreadthorn::new);
	public static final class_2248 dreadthornFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileDreadthorn::new);

	public static final class_2248 heiseiDream = new BlockSpecialFlower(ModPotions.soulCross, 300, FLOWER_PROPS, SubTileHeiseiDream::new);
	public static final class_2248 heiseiDreamFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileHeiseiDream::new);

	public static final class_2248 tigerseye = new BlockSpecialFlower(class_1294.field_5910, 90, FLOWER_PROPS, SubTileTigerseye::new);
	public static final class_2248 tigerseyeFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileTigerseye::new);

	public static final class_2248 jadedAmaranthus = new BlockSpecialFlower(class_1294.field_5915, 1, FLOWER_PROPS, SubTileJadedAmaranthus::new);
	public static final class_2248 jadedAmaranthusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileJadedAmaranthus::new);

	public static final class_2248 orechid = new BlockSpecialFlower(class_1294.field_5917, 10, FLOWER_PROPS, SubTileOrechid::new);
	public static final class_2248 orechidFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileOrechid::new);

	public static final class_2248 fallenKanade = new BlockSpecialFlower(class_1294.field_5924, 90, FLOWER_PROPS, SubTileFallenKanade::new);
	public static final class_2248 fallenKanadeFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileFallenKanade::new);

	public static final class_2248 exoflame = new BlockSpecialFlower(class_1294.field_5904, 240, FLOWER_PROPS, SubTileExoflame::new);
	public static final class_2248 exoflameFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileExoflame::new);

	public static final class_2248 agricarnation = new BlockSpecialFlower(class_1294.field_5898, 48, FLOWER_PROPS, SubTileAgricarnation::new);
	public static final class_2248 agricarnationChibi = new BlockSpecialFlower(class_1294.field_5898, 48, FLOWER_PROPS, SubTileAgricarnation.Mini::new);
	public static final class_2248 agricarnationFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileAgricarnation::new);
	public static final class_2248 agricarnationChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileAgricarnation.Mini::new);

	public static final class_2248 hopperhock = new BlockSpecialFlower(class_1294.field_5904, 30, FLOWER_PROPS, SubTileHopperhock::new);
	public static final class_2248 hopperhockChibi = new BlockSpecialFlower(class_1294.field_5904, 30, FLOWER_PROPS, SubTileHopperhock.Mini::new);
	public static final class_2248 hopperhockFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileHopperhock::new);
	public static final class_2248 hopperhockChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileHopperhock.Mini::new);

	public static final class_2248 tangleberrie = new BlockSpecialFlower(ModPotions.bloodthrst, 120, FLOWER_PROPS, SubTileTangleberrie::new);
	public static final class_2248 tangleberrieFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileTangleberrie::new);

	public static final class_2248 jiyuulia = new BlockSpecialFlower(ModPotions.emptiness, 120, FLOWER_PROPS, SubTileJiyuulia::new);
	public static final class_2248 jiyuuliaFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileJiyuulia::new);

	public static final class_2248 rannuncarpus = new BlockSpecialFlower(class_1294.field_5913, 30, FLOWER_PROPS, SubTileRannuncarpus::new);
	public static final class_2248 rannuncarpusChibi = new BlockSpecialFlower(class_1294.field_5913, 30, FLOWER_PROPS, SubTileRannuncarpus.Mini::new);
	public static final class_2248 rannuncarpusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileRannuncarpus::new);
	public static final class_2248 rannuncarpusChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileRannuncarpus.Mini::new);

	public static final class_2248 hyacidus = new BlockSpecialFlower(class_1294.field_5899, 48, FLOWER_PROPS, SubTileHyacidus::new);
	public static final class_2248 hyacidusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileHyacidus::new);

	public static final class_2248 pollidisiac = new BlockSpecialFlower(class_1294.field_5917, 369, FLOWER_PROPS, SubTilePollidisiac::new);
	public static final class_2248 pollidisiacFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTilePollidisiac::new);

	public static final class_2248 clayconia = new BlockSpecialFlower(class_1294.field_5911, 30, FLOWER_PROPS, SubTileClayconia::new);
	public static final class_2248 clayconiaChibi = new BlockSpecialFlower(class_1294.field_5911, 30, FLOWER_PROPS, SubTileClayconia.Mini::new);
	public static final class_2248 clayconiaFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileClayconia::new);
	public static final class_2248 clayconiaChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileClayconia.Mini::new);

	public static final class_2248 loonium = new BlockSpecialFlower(ModPotions.allure, 900, FLOWER_PROPS, SubTileLoonuim::new);
	public static final class_2248 looniumFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileLoonuim::new);

	public static final class_2248 daffomill = new BlockSpecialFlower(class_1294.field_5902, 6, FLOWER_PROPS, SubTileDaffomill::new);
	public static final class_2248 daffomillFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileDaffomill::new);

	public static final class_2248 vinculotus = new BlockSpecialFlower(class_1294.field_5925, 900, FLOWER_PROPS, SubTileVinculotus::new);
	public static final class_2248 vinculotusFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileVinculotus::new);

	public static final class_2248 spectranthemum = new BlockSpecialFlower(class_1294.field_5905, 360, FLOWER_PROPS, SubTileSpectranthemum::new);
	public static final class_2248 spectranthemumFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileSpectranthemum::new);

	public static final class_2248 medumone = new BlockSpecialFlower(class_1294.field_5909, 3600, FLOWER_PROPS, SubTileMedumone::new);
	public static final class_2248 medumoneFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileMedumone::new);

	public static final class_2248 marimorphosis = new BlockSpecialFlower(class_1294.field_5901, 60, FLOWER_PROPS, SubTileMarimorphosis::new);
	public static final class_2248 marimorphosisChibi = new BlockSpecialFlower(class_1294.field_5901, 60, FLOWER_PROPS, SubTileMarimorphosis.Mini::new);
	public static final class_2248 marimorphosisFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileMarimorphosis::new);
	public static final class_2248 marimorphosisChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileMarimorphosis.Mini::new);

	public static final class_2248 bubbell = new BlockSpecialFlower(class_1294.field_5923, 240, FLOWER_PROPS, SubTileBubbell::new);
	public static final class_2248 bubbellChibi = new BlockSpecialFlower(class_1294.field_5923, 240, FLOWER_PROPS, SubTileBubbell.Mini::new);
	public static final class_2248 bubbellFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileBubbell::new);
	public static final class_2248 bubbellChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileBubbell.Mini::new);

	public static final class_2248 solegnolia = new BlockSpecialFlower(class_1294.field_5921, 1, FLOWER_PROPS, SubTileSolegnolia::new);
	public static final class_2248 solegnoliaChibi = new BlockSpecialFlower(class_1294.field_5921, 1, FLOWER_PROPS, SubTileSolegnolia.Mini::new);
	public static final class_2248 solegnoliaFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileSolegnolia::new);
	public static final class_2248 solegnoliaChibiFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileSolegnolia.Mini::new);

	public static final class_2248 orechidIgnem = new BlockSpecialFlower(class_1294.field_5918, 600, FLOWER_PROPS, SubTileOrechidIgnem::new);
	public static final class_2248 orechidIgnemFloating = new BlockFloatingSpecialFlower(FLOATING_PROPS, SubTileOrechidIgnem::new);

	public static final class_2591<SubTilePureDaisy> PURE_DAISY = class_2591.class_2592.method_20528(SubTilePureDaisy::new, pureDaisy, pureDaisyFloating).method_11034(null);
	public static final class_2591<SubTileManastar> MANASTAR = class_2591.class_2592.method_20528(SubTileManastar::new, manastar, manastarFloating).method_11034(null);
	public static final class_2591<SubTileHydroangeas> HYDROANGEAS = class_2591.class_2592.method_20528(SubTileHydroangeas::new, hydroangeas, hydroangeasFloating).method_11034(null);
	public static final class_2591<SubTileEndoflame> ENDOFLAME = class_2591.class_2592.method_20528(SubTileEndoflame::new, endoflame, endoflameFloating).method_11034(null);
	public static final class_2591<SubTileThermalily> THERMALILY = class_2591.class_2592.method_20528(SubTileThermalily::new, thermalily, thermalilyFloating).method_11034(null);
	public static final class_2591<SubTileArcaneRose> ROSA_ARCANA = class_2591.class_2592.method_20528(SubTileArcaneRose::new, rosaArcana, rosaArcanaFloating).method_11034(null);
	public static final class_2591<SubTileMunchdew> MUNCHDEW = class_2591.class_2592.method_20528(SubTileMunchdew::new, munchdew, munchdewFloating).method_11034(null);
	public static final class_2591<SubTileEntropinnyum> ENTROPINNYUM = class_2591.class_2592.method_20528(SubTileEntropinnyum::new, entropinnyum, entropinnyumFloating).method_11034(null);
	public static final class_2591<SubTileKekimurus> KEKIMURUS = class_2591.class_2592.method_20528(SubTileKekimurus::new, kekimurus, kekimurusFloating).method_11034(null);
	public static final class_2591<SubTileGourmaryllis> GOURMARYLLIS = class_2591.class_2592.method_20528(SubTileGourmaryllis::new, gourmaryllis, gourmaryllisFloating).method_11034(null);
	public static final class_2591<SubTileNarslimmus> NARSLIMMUS = class_2591.class_2592.method_20528(SubTileNarslimmus::new, narslimmus, narslimmusFloating).method_11034(null);
	public static final class_2591<SubTileSpectrolus> SPECTROLUS = class_2591.class_2592.method_20528(SubTileSpectrolus::new, spectrolus, spectrolusFloating).method_11034(null);
	public static final class_2591<SubTileDandelifeon> DANDELIFEON = class_2591.class_2592.method_20528(SubTileDandelifeon::new, dandelifeon, dandelifeonFloating).method_11034(null);
	public static final class_2591<SubTileRafflowsia> RAFFLOWSIA = class_2591.class_2592.method_20528(SubTileRafflowsia::new, rafflowsia, rafflowsiaFloating).method_11034(null);
	public static final class_2591<SubTileShulkMeNot> SHULK_ME_NOT = class_2591.class_2592.method_20528(SubTileShulkMeNot::new, shulkMeNot, shulkMeNotFloating).method_11034(null);
	public static final class_2591<SubTileBellethorn> BELLETHORNE = class_2591.class_2592.method_20528(SubTileBellethorn::new, bellethorn, bellethornFloating).method_11034(null);
	public static final class_2591<SubTileBellethorn.Mini> BELLETHORNE_CHIBI = class_2591.class_2592.method_20528(SubTileBellethorn.Mini::new, bellethornChibi, bellethornChibiFloating).method_11034(null);
	public static final class_2591<SubTileBergamute> BERGAMUTE = class_2591.class_2592.method_20528(SubTileBergamute::new, bergamute, bergamuteFloating).method_11034(null);
	public static final class_2591<SubTileDreadthorn> DREADTHORN = class_2591.class_2592.method_20528(SubTileDreadthorn::new, dreadthorn, dreadthornFloating).method_11034(null);
	public static final class_2591<SubTileHeiseiDream> HEISEI_DREAM = class_2591.class_2592.method_20528(SubTileHeiseiDream::new, heiseiDream, heiseiDreamFloating).method_11034(null);
	public static final class_2591<SubTileTigerseye> TIGERSEYE = class_2591.class_2592.method_20528(SubTileTigerseye::new, tigerseye, tigerseyeFloating).method_11034(null);
	public static final class_2591<SubTileJadedAmaranthus> JADED_AMARANTHUS = class_2591.class_2592.method_20528(SubTileJadedAmaranthus::new, jadedAmaranthus, jadedAmaranthusFloating).method_11034(null);
	public static final class_2591<SubTileOrechid> ORECHID = class_2591.class_2592.method_20528(SubTileOrechid::new, orechid, orechidFloating).method_11034(null);
	public static final class_2591<SubTileFallenKanade> FALLEN_KANADE = class_2591.class_2592.method_20528(SubTileFallenKanade::new, fallenKanade, fallenKanadeFloating).method_11034(null);
	public static final class_2591<SubTileExoflame> EXOFLAME = class_2591.class_2592.method_20528(SubTileExoflame::new, exoflame, exoflameFloating).method_11034(null);
	public static final class_2591<SubTileAgricarnation> AGRICARNATION = class_2591.class_2592.method_20528(SubTileAgricarnation::new, agricarnation, agricarnationFloating).method_11034(null);
	public static final class_2591<SubTileAgricarnation.Mini> AGRICARNATION_CHIBI = class_2591.class_2592.method_20528(SubTileAgricarnation.Mini::new, agricarnationChibi, agricarnationChibiFloating).method_11034(null);
	public static final class_2591<SubTileHopperhock> HOPPERHOCK = class_2591.class_2592.method_20528(SubTileHopperhock::new, hopperhock, hopperhockFloating).method_11034(null);
	public static final class_2591<SubTileHopperhock.Mini> HOPPERHOCK_CHIBI = class_2591.class_2592.method_20528(SubTileHopperhock.Mini::new, hopperhockChibi, hopperhockChibiFloating).method_11034(null);
	public static final class_2591<SubTileTangleberrie> TANGLEBERRIE = class_2591.class_2592.method_20528(SubTileTangleberrie::new, tangleberrie, tangleberrieFloating).method_11034(null);
	public static final class_2591<SubTileJiyuulia> JIYUULIA = class_2591.class_2592.method_20528(SubTileJiyuulia::new, jiyuulia, jiyuuliaFloating).method_11034(null);
	public static final class_2591<SubTileRannuncarpus> RANNUNCARPUS = class_2591.class_2592.method_20528(SubTileRannuncarpus::new, rannuncarpus, rannuncarpusFloating).method_11034(null);
	public static final class_2591<SubTileRannuncarpus.Mini> RANNUNCARPUS_CHIBI = class_2591.class_2592.method_20528(SubTileRannuncarpus.Mini::new, rannuncarpusChibi, rannuncarpusChibiFloating).method_11034(null);
	public static final class_2591<SubTileHyacidus> HYACIDUS = class_2591.class_2592.method_20528(SubTileHyacidus::new, hyacidus, hyacidusFloating).method_11034(null);
	public static final class_2591<SubTilePollidisiac> POLLIDISIAC = class_2591.class_2592.method_20528(SubTilePollidisiac::new, pollidisiac, pollidisiacFloating).method_11034(null);
	public static final class_2591<SubTileClayconia> CLAYCONIA = class_2591.class_2592.method_20528(SubTileClayconia::new, clayconia, clayconiaFloating).method_11034(null);
	public static final class_2591<SubTileClayconia.Mini> CLAYCONIA_CHIBI = class_2591.class_2592.method_20528(SubTileClayconia.Mini::new, clayconiaChibi, clayconiaChibiFloating).method_11034(null);
	public static final class_2591<SubTileLoonuim> LOONIUM = class_2591.class_2592.method_20528(SubTileLoonuim::new, loonium, looniumFloating).method_11034(null);
	public static final class_2591<SubTileDaffomill> DAFFOMILL = class_2591.class_2592.method_20528(SubTileDaffomill::new, daffomill, daffomillFloating).method_11034(null);
	public static final class_2591<SubTileVinculotus> VINCULOTUS = class_2591.class_2592.method_20528(SubTileVinculotus::new, vinculotus, vinculotusFloating).method_11034(null);
	public static final class_2591<SubTileSpectranthemum> SPECTRANTHEMUM = class_2591.class_2592.method_20528(SubTileSpectranthemum::new, spectranthemum, spectranthemumFloating).method_11034(null);
	public static final class_2591<SubTileMedumone> MEDUMONE = class_2591.class_2592.method_20528(SubTileMedumone::new, medumone, medumoneFloating).method_11034(null);
	public static final class_2591<SubTileMarimorphosis> MARIMORPHOSIS = class_2591.class_2592.method_20528(SubTileMarimorphosis::new, marimorphosis, marimorphosisFloating).method_11034(null);
	public static final class_2591<SubTileMarimorphosis.Mini> MARIMORPHOSIS_CHIBI = class_2591.class_2592.method_20528(SubTileMarimorphosis.Mini::new, marimorphosisChibi, marimorphosisChibiFloating).method_11034(null);
	public static final class_2591<SubTileBubbell> BUBBELL = class_2591.class_2592.method_20528(SubTileBubbell::new, bubbell, bubbellFloating).method_11034(null);
	public static final class_2591<SubTileBubbell.Mini> BUBBELL_CHIBI = class_2591.class_2592.method_20528(SubTileBubbell.Mini::new, bubbellChibi, bubbellChibiFloating).method_11034(null);
	public static final class_2591<SubTileSolegnolia> SOLEGNOLIA = class_2591.class_2592.method_20528(SubTileSolegnolia::new, solegnolia, solegnoliaFloating).method_11034(null);
	public static final class_2591<SubTileSolegnolia.Mini> SOLEGNOLIA_CHIBI = class_2591.class_2592.method_20528(SubTileSolegnolia.Mini::new, solegnoliaChibi, solegnoliaChibiFloating).method_11034(null);
	public static final class_2591<SubTileOrechidIgnem> ORECHID_IGNEM = class_2591.class_2592.method_20528(SubTileOrechidIgnem::new, orechidIgnem, orechidIgnemFloating).method_11034(null);

	private static class_2960 floating(class_2960 orig) {
		return new class_2960(orig.method_12836(), "floating_" + orig.method_12832());
	}

	private static class_2960 chibi(class_2960 orig) {
		return new class_2960(orig.method_12836(), orig.method_12832() + "_chibi");
	}

	private static class_2960 getId(class_2248 b) {
		return class_2378.field_11146.method_10221(b);
	}

	public static void registerBlocks() {
		class_2378<class_2248> r = class_2378.field_11146;
		register(r, LibBlockNames.SUBTILE_PUREDAISY, pureDaisy);
		register(r, floating(LibBlockNames.SUBTILE_PUREDAISY), pureDaisyFloating);

		register(r, LibBlockNames.SUBTILE_MANASTAR, manastar);
		register(r, floating(LibBlockNames.SUBTILE_MANASTAR), manastarFloating);

		register(r, LibBlockNames.SUBTILE_HYDROANGEAS, hydroangeas);
		register(r, floating(LibBlockNames.SUBTILE_HYDROANGEAS), hydroangeasFloating);

		register(r, LibBlockNames.SUBTILE_ENDOFLAME, endoflame);
		register(r, floating(LibBlockNames.SUBTILE_ENDOFLAME), endoflameFloating);

		register(r, LibBlockNames.SUBTILE_THERMALILY, thermalily);
		register(r, floating(LibBlockNames.SUBTILE_THERMALILY), thermalilyFloating);

		register(r, LibBlockNames.SUBTILE_ARCANE_ROSE, rosaArcana);
		register(r, floating(LibBlockNames.SUBTILE_ARCANE_ROSE), rosaArcanaFloating);

		register(r, LibBlockNames.SUBTILE_MUNCHDEW, munchdew);
		register(r, floating(LibBlockNames.SUBTILE_MUNCHDEW), munchdewFloating);

		register(r, LibBlockNames.SUBTILE_ENTROPINNYUM, entropinnyum);
		register(r, floating(LibBlockNames.SUBTILE_ENTROPINNYUM), entropinnyumFloating);

		register(r, LibBlockNames.SUBTILE_KEKIMURUS, kekimurus);
		register(r, floating(LibBlockNames.SUBTILE_KEKIMURUS), kekimurusFloating);

		register(r, LibBlockNames.SUBTILE_GOURMARYLLIS, gourmaryllis);
		register(r, floating(LibBlockNames.SUBTILE_GOURMARYLLIS), gourmaryllisFloating);

		register(r, LibBlockNames.SUBTILE_NARSLIMMUS, narslimmus);
		register(r, floating(LibBlockNames.SUBTILE_NARSLIMMUS), narslimmusFloating);

		register(r, LibBlockNames.SUBTILE_SPECTROLUS, spectrolus);
		register(r, floating(LibBlockNames.SUBTILE_SPECTROLUS), spectrolusFloating);

		register(r, LibBlockNames.SUBTILE_DANDELIFEON, dandelifeon);
		register(r, floating(LibBlockNames.SUBTILE_DANDELIFEON), dandelifeonFloating);

		register(r, LibBlockNames.SUBTILE_RAFFLOWSIA, rafflowsia);
		register(r, floating(LibBlockNames.SUBTILE_RAFFLOWSIA), rafflowsiaFloating);

		register(r, LibBlockNames.SUBTILE_SHULK_ME_NOT, shulkMeNot);
		register(r, floating(LibBlockNames.SUBTILE_SHULK_ME_NOT), shulkMeNotFloating);

		register(r, LibBlockNames.SUBTILE_BELLETHORN, bellethorn);
		register(r, chibi(LibBlockNames.SUBTILE_BELLETHORN), bellethornChibi);
		register(r, floating(LibBlockNames.SUBTILE_BELLETHORN), bellethornFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_BELLETHORN)), bellethornChibiFloating);

		register(r, LibBlockNames.SUBTILE_BERGAMUTE, bergamute);
		register(r, floating(LibBlockNames.SUBTILE_BERGAMUTE), bergamuteFloating);

		register(r, LibBlockNames.SUBTILE_DREADTHORN, dreadthorn);
		register(r, floating(LibBlockNames.SUBTILE_DREADTHORN), dreadthornFloating);

		register(r, LibBlockNames.SUBTILE_HEISEI_DREAM, heiseiDream);
		register(r, floating(LibBlockNames.SUBTILE_HEISEI_DREAM), heiseiDreamFloating);

		register(r, LibBlockNames.SUBTILE_TIGERSEYE, tigerseye);
		register(r, floating(LibBlockNames.SUBTILE_TIGERSEYE), tigerseyeFloating);

		register(r, LibBlockNames.SUBTILE_JADED_AMARANTHUS, jadedAmaranthus);
		register(r, floating(LibBlockNames.SUBTILE_JADED_AMARANTHUS), jadedAmaranthusFloating);

		register(r, LibBlockNames.SUBTILE_ORECHID, orechid);
		register(r, floating(LibBlockNames.SUBTILE_ORECHID), orechidFloating);

		register(r, LibBlockNames.SUBTILE_FALLEN_KANADE, fallenKanade);
		register(r, floating(LibBlockNames.SUBTILE_FALLEN_KANADE), fallenKanadeFloating);

		register(r, LibBlockNames.SUBTILE_EXOFLAME, exoflame);
		register(r, floating(LibBlockNames.SUBTILE_EXOFLAME), exoflameFloating);

		register(r, LibBlockNames.SUBTILE_AGRICARNATION, agricarnation);
		register(r, chibi(LibBlockNames.SUBTILE_AGRICARNATION), agricarnationChibi);
		register(r, floating(LibBlockNames.SUBTILE_AGRICARNATION), agricarnationFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_AGRICARNATION)), agricarnationChibiFloating);

		register(r, LibBlockNames.SUBTILE_HOPPERHOCK, hopperhock);
		register(r, chibi(LibBlockNames.SUBTILE_HOPPERHOCK), hopperhockChibi);
		register(r, floating(LibBlockNames.SUBTILE_HOPPERHOCK), hopperhockFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_HOPPERHOCK)), hopperhockChibiFloating);

		register(r, LibBlockNames.SUBTILE_TANGLEBERRIE, tangleberrie);
		register(r, floating(LibBlockNames.SUBTILE_TANGLEBERRIE), tangleberrieFloating);

		register(r, LibBlockNames.SUBTILE_JIYUULIA, jiyuulia);
		register(r, floating(LibBlockNames.SUBTILE_JIYUULIA), jiyuuliaFloating);

		register(r, LibBlockNames.SUBTILE_RANNUNCARPUS, rannuncarpus);
		register(r, chibi(LibBlockNames.SUBTILE_RANNUNCARPUS), rannuncarpusChibi);
		register(r, floating(LibBlockNames.SUBTILE_RANNUNCARPUS), rannuncarpusFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_RANNUNCARPUS)), rannuncarpusChibiFloating);

		register(r, LibBlockNames.SUBTILE_HYACIDUS, hyacidus);
		register(r, floating(LibBlockNames.SUBTILE_HYACIDUS), hyacidusFloating);

		register(r, LibBlockNames.SUBTILE_POLLIDISIAC, pollidisiac);
		register(r, floating(LibBlockNames.SUBTILE_POLLIDISIAC), pollidisiacFloating);

		register(r, LibBlockNames.SUBTILE_CLAYCONIA, clayconia);
		register(r, chibi(LibBlockNames.SUBTILE_CLAYCONIA), clayconiaChibi);
		register(r, floating(LibBlockNames.SUBTILE_CLAYCONIA), clayconiaFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_CLAYCONIA)), clayconiaChibiFloating);

		register(r, LibBlockNames.SUBTILE_LOONIUM, loonium);
		register(r, floating(LibBlockNames.SUBTILE_LOONIUM), looniumFloating);

		register(r, LibBlockNames.SUBTILE_DAFFOMILL, daffomill);
		register(r, floating(LibBlockNames.SUBTILE_DAFFOMILL), daffomillFloating);

		register(r, LibBlockNames.SUBTILE_VINCULOTUS, vinculotus);
		register(r, floating(LibBlockNames.SUBTILE_VINCULOTUS), vinculotusFloating);

		register(r, LibBlockNames.SUBTILE_SPECTRANTHEMUM, spectranthemum);
		register(r, floating(LibBlockNames.SUBTILE_SPECTRANTHEMUM), spectranthemumFloating);

		register(r, LibBlockNames.SUBTILE_MEDUMONE, medumone);
		register(r, floating(LibBlockNames.SUBTILE_MEDUMONE), medumoneFloating);

		register(r, LibBlockNames.SUBTILE_MARIMORPHOSIS, marimorphosis);
		register(r, chibi(LibBlockNames.SUBTILE_MARIMORPHOSIS), marimorphosisChibi);
		register(r, floating(LibBlockNames.SUBTILE_MARIMORPHOSIS), marimorphosisFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_MARIMORPHOSIS)), marimorphosisChibiFloating);

		register(r, LibBlockNames.SUBTILE_BUBBELL, bubbell);
		register(r, chibi(LibBlockNames.SUBTILE_BUBBELL), bubbellChibi);
		register(r, floating(LibBlockNames.SUBTILE_BUBBELL), bubbellFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_BUBBELL)), bubbellChibiFloating);

		register(r, LibBlockNames.SUBTILE_SOLEGNOLIA, solegnolia);
		register(r, chibi(LibBlockNames.SUBTILE_SOLEGNOLIA), solegnoliaChibi);
		register(r, floating(LibBlockNames.SUBTILE_SOLEGNOLIA), solegnoliaFloating);
		register(r, chibi(floating(LibBlockNames.SUBTILE_SOLEGNOLIA)), solegnoliaChibiFloating);

		register(r, LibBlockNames.SUBTILE_ORECHID_IGNEM, orechidIgnem);
		register(r, floating(LibBlockNames.SUBTILE_ORECHID_IGNEM), orechidIgnemFloating);
	}

	public static void registerItemBlocks() {
		class_2378<class_1792> r = class_2378.field_11142;
		class_1792.class_1793 props = ModItems.defaultBuilder();

		register(r, getId(pureDaisy), new ItemBlockSpecialFlower(pureDaisy, props));
		register(r, getId(pureDaisyFloating), new ItemBlockSpecialFlower(pureDaisyFloating, props));

		register(r, getId(manastar), new ItemBlockSpecialFlower(manastar, props));
		register(r, getId(manastarFloating), new ItemBlockSpecialFlower(manastarFloating, props));

		register(r, getId(hydroangeas), new ItemBlockSpecialFlower(hydroangeas, props));
		register(r, getId(hydroangeasFloating), new ItemBlockSpecialFlower(hydroangeasFloating, props));

		register(r, getId(endoflame), new ItemBlockSpecialFlower(endoflame, props));
		register(r, getId(endoflameFloating), new ItemBlockSpecialFlower(endoflameFloating, props));

		register(r, getId(thermalily), new ItemBlockSpecialFlower(thermalily, props));
		register(r, getId(thermalilyFloating), new ItemBlockSpecialFlower(thermalilyFloating, props));

		register(r, getId(rosaArcana), new ItemBlockSpecialFlower(rosaArcana, props));
		register(r, getId(rosaArcanaFloating), new ItemBlockSpecialFlower(rosaArcanaFloating, props));

		register(r, getId(munchdew), new ItemBlockSpecialFlower(munchdew, props));
		register(r, getId(munchdewFloating), new ItemBlockSpecialFlower(munchdewFloating, props));

		register(r, getId(entropinnyum), new ItemBlockSpecialFlower(entropinnyum, props));
		register(r, getId(entropinnyumFloating), new ItemBlockSpecialFlower(entropinnyumFloating, props));

		register(r, getId(kekimurus), new ItemBlockSpecialFlower(kekimurus, props));
		register(r, getId(kekimurusFloating), new ItemBlockSpecialFlower(kekimurusFloating, props));

		register(r, getId(gourmaryllis), new ItemBlockSpecialFlower(gourmaryllis, props));
		register(r, getId(gourmaryllisFloating), new ItemBlockSpecialFlower(gourmaryllisFloating, props));

		register(r, getId(narslimmus), new ItemBlockSpecialFlower(narslimmus, props));
		register(r, getId(narslimmusFloating), new ItemBlockSpecialFlower(narslimmusFloating, props));

		register(r, getId(spectrolus), new ItemBlockSpecialFlower(spectrolus, props));
		register(r, getId(spectrolusFloating), new ItemBlockSpecialFlower(spectrolusFloating, props));

		register(r, getId(dandelifeon), new ItemBlockSpecialFlower(dandelifeon, props));
		register(r, getId(dandelifeonFloating), new ItemBlockSpecialFlower(dandelifeonFloating, props));

		register(r, getId(rafflowsia), new ItemBlockSpecialFlower(rafflowsia, props));
		register(r, getId(rafflowsiaFloating), new ItemBlockSpecialFlower(rafflowsiaFloating, props));

		register(r, getId(shulkMeNot), new ItemBlockSpecialFlower(shulkMeNot, props));
		register(r, getId(shulkMeNotFloating), new ItemBlockSpecialFlower(shulkMeNotFloating, props));

		register(r, getId(bellethorn), new ItemBlockSpecialFlower(bellethorn, props));
		register(r, getId(bellethornChibi), new ItemBlockSpecialFlower(bellethornChibi, props));
		register(r, getId(bellethornFloating), new ItemBlockSpecialFlower(bellethornFloating, props));
		register(r, getId(bellethornChibiFloating), new ItemBlockSpecialFlower(bellethornChibiFloating, props));

		register(r, getId(bergamute), new ItemBlockSpecialFlower(bergamute, props));
		register(r, getId(bergamuteFloating), new ItemBlockSpecialFlower(bergamuteFloating, props));

		register(r, getId(dreadthorn), new ItemBlockSpecialFlower(dreadthorn, props));
		register(r, getId(dreadthornFloating), new ItemBlockSpecialFlower(dreadthornFloating, props));

		register(r, getId(heiseiDream), new ItemBlockSpecialFlower(heiseiDream, props));
		register(r, getId(heiseiDreamFloating), new ItemBlockSpecialFlower(heiseiDreamFloating, props));

		register(r, getId(tigerseye), new ItemBlockSpecialFlower(tigerseye, props));
		register(r, getId(tigerseyeFloating), new ItemBlockSpecialFlower(tigerseyeFloating, props));

		register(r, getId(jadedAmaranthus), new ItemBlockSpecialFlower(jadedAmaranthus, props));
		register(r, getId(jadedAmaranthusFloating), new ItemBlockSpecialFlower(jadedAmaranthusFloating, props));

		register(r, getId(orechid), new ItemBlockSpecialFlower(orechid, props));
		register(r, getId(orechidFloating), new ItemBlockSpecialFlower(orechidFloating, props));

		register(r, getId(fallenKanade), new ItemBlockSpecialFlower(fallenKanade, props));
		register(r, getId(fallenKanadeFloating), new ItemBlockSpecialFlower(fallenKanadeFloating, props));

		register(r, getId(exoflame), new ItemBlockSpecialFlower(exoflame, props));
		register(r, getId(exoflameFloating), new ItemBlockSpecialFlower(exoflameFloating, props));

		register(r, getId(agricarnation), new ItemBlockSpecialFlower(agricarnation, props));
		register(r, getId(agricarnationChibi), new ItemBlockSpecialFlower(agricarnationChibi, props));
		register(r, getId(agricarnationFloating), new ItemBlockSpecialFlower(agricarnationFloating, props));
		register(r, getId(agricarnationChibiFloating), new ItemBlockSpecialFlower(agricarnationChibiFloating, props));

		register(r, getId(hopperhock), new ItemBlockSpecialFlower(hopperhock, props));
		register(r, getId(hopperhockChibi), new ItemBlockSpecialFlower(hopperhockChibi, props));
		register(r, getId(hopperhockFloating), new ItemBlockSpecialFlower(hopperhockFloating, props));
		register(r, getId(hopperhockChibiFloating), new ItemBlockSpecialFlower(hopperhockChibiFloating, props));

		register(r, getId(tangleberrie), new ItemBlockSpecialFlower(tangleberrie, props));
		register(r, getId(tangleberrieFloating), new ItemBlockSpecialFlower(tangleberrieFloating, props));

		register(r, getId(jiyuulia), new ItemBlockSpecialFlower(jiyuulia, props));
		register(r, getId(jiyuuliaFloating), new ItemBlockSpecialFlower(jiyuuliaFloating, props));

		register(r, getId(rannuncarpus), new ItemBlockSpecialFlower(rannuncarpus, props));
		register(r, getId(rannuncarpusChibi), new ItemBlockSpecialFlower(rannuncarpusChibi, props));
		register(r, getId(rannuncarpusFloating), new ItemBlockSpecialFlower(rannuncarpusFloating, props));
		register(r, getId(rannuncarpusChibiFloating), new ItemBlockSpecialFlower(rannuncarpusChibiFloating, props));

		register(r, getId(hyacidus), new ItemBlockSpecialFlower(hyacidus, props));
		register(r, getId(hyacidusFloating), new ItemBlockSpecialFlower(hyacidusFloating, props));

		register(r, getId(pollidisiac), new ItemBlockSpecialFlower(pollidisiac, props));
		register(r, getId(pollidisiacFloating), new ItemBlockSpecialFlower(pollidisiacFloating, props));

		register(r, getId(clayconia), new ItemBlockSpecialFlower(clayconia, props));
		register(r, getId(clayconiaChibi), new ItemBlockSpecialFlower(clayconiaChibi, props));
		register(r, getId(clayconiaFloating), new ItemBlockSpecialFlower(clayconiaFloating, props));
		register(r, getId(clayconiaChibiFloating), new ItemBlockSpecialFlower(clayconiaChibiFloating, props));

		register(r, getId(loonium), new ItemBlockSpecialFlower(loonium, props));
		register(r, getId(looniumFloating), new ItemBlockSpecialFlower(looniumFloating, props));

		register(r, getId(daffomill), new ItemBlockSpecialFlower(daffomill, props));
		register(r, getId(daffomillFloating), new ItemBlockSpecialFlower(daffomillFloating, props));

		register(r, getId(vinculotus), new ItemBlockSpecialFlower(vinculotus, props));
		register(r, getId(vinculotusFloating), new ItemBlockSpecialFlower(vinculotusFloating, props));

		register(r, getId(spectranthemum), new ItemBlockSpecialFlower(spectranthemum, props));
		register(r, getId(spectranthemumFloating), new ItemBlockSpecialFlower(spectranthemumFloating, props));

		register(r, getId(medumone), new ItemBlockSpecialFlower(medumone, props));
		register(r, getId(medumoneFloating), new ItemBlockSpecialFlower(medumoneFloating, props));

		register(r, getId(marimorphosis), new ItemBlockSpecialFlower(marimorphosis, props));
		register(r, getId(marimorphosisChibi), new ItemBlockSpecialFlower(marimorphosisChibi, props));
		register(r, getId(marimorphosisFloating), new ItemBlockSpecialFlower(marimorphosisFloating, props));
		register(r, getId(marimorphosisChibiFloating), new ItemBlockSpecialFlower(marimorphosisChibiFloating, props));

		register(r, getId(bubbell), new ItemBlockSpecialFlower(bubbell, props));
		register(r, getId(bubbellChibi), new ItemBlockSpecialFlower(bubbellChibi, props));
		register(r, getId(bubbellFloating), new ItemBlockSpecialFlower(bubbellFloating, props));
		register(r, getId(bubbellChibiFloating), new ItemBlockSpecialFlower(bubbellChibiFloating, props));

		register(r, getId(solegnolia), new ItemBlockSpecialFlower(solegnolia, props));
		register(r, getId(solegnoliaChibi), new ItemBlockSpecialFlower(solegnoliaChibi, props));
		register(r, getId(solegnoliaFloating), new ItemBlockSpecialFlower(solegnoliaFloating, props));
		register(r, getId(solegnoliaChibiFloating), new ItemBlockSpecialFlower(solegnoliaChibiFloating, props));

		register(r, getId(orechidIgnem), new ItemBlockSpecialFlower(orechidIgnem, props));
		register(r, getId(orechidIgnemFloating), new ItemBlockSpecialFlower(orechidIgnemFloating, props));
	}

	public static void registerTEs() {
		class_2378<class_2591<?>> r = class_2378.field_11137;
		register(r, getId(pureDaisy), PURE_DAISY);
		register(r, getId(manastar), MANASTAR);
		register(r, getId(hydroangeas), HYDROANGEAS);
		register(r, getId(endoflame), ENDOFLAME);
		register(r, getId(thermalily), THERMALILY);
		register(r, getId(rosaArcana), ROSA_ARCANA);
		register(r, getId(munchdew), MUNCHDEW);
		register(r, getId(entropinnyum), ENTROPINNYUM);
		register(r, getId(kekimurus), KEKIMURUS);
		register(r, getId(gourmaryllis), GOURMARYLLIS);
		register(r, getId(narslimmus), NARSLIMMUS);
		register(r, getId(spectrolus), SPECTROLUS);
		register(r, getId(dandelifeon), DANDELIFEON);
		register(r, getId(rafflowsia), RAFFLOWSIA);
		register(r, getId(shulkMeNot), SHULK_ME_NOT);
		register(r, getId(bellethorn), BELLETHORNE);
		register(r, getId(bellethornChibi), BELLETHORNE_CHIBI);
		register(r, getId(bergamute), BERGAMUTE);
		register(r, getId(dreadthorn), DREADTHORN);
		register(r, getId(heiseiDream), HEISEI_DREAM);
		register(r, getId(tigerseye), TIGERSEYE);
		register(r, getId(jadedAmaranthus), JADED_AMARANTHUS);
		register(r, getId(orechid), ORECHID);
		register(r, getId(fallenKanade), FALLEN_KANADE);
		register(r, getId(exoflame), EXOFLAME);
		register(r, getId(agricarnation), AGRICARNATION);
		register(r, getId(agricarnationChibi), AGRICARNATION_CHIBI);
		register(r, getId(hopperhock), HOPPERHOCK);
		register(r, getId(hopperhockChibi), HOPPERHOCK_CHIBI);
		register(r, getId(tangleberrie), TANGLEBERRIE);
		register(r, getId(jiyuulia), JIYUULIA);
		register(r, getId(rannuncarpus), RANNUNCARPUS);
		register(r, getId(rannuncarpusChibi), RANNUNCARPUS_CHIBI);
		register(r, getId(hyacidus), HYACIDUS);
		register(r, getId(pollidisiac), POLLIDISIAC);
		register(r, getId(clayconia), CLAYCONIA);
		register(r, getId(clayconiaChibi), CLAYCONIA_CHIBI);
		register(r, getId(loonium), LOONIUM);
		register(r, getId(daffomill), DAFFOMILL);
		register(r, getId(vinculotus), VINCULOTUS);
		register(r, getId(spectranthemum), SPECTRANTHEMUM);
		register(r, getId(medumone), MEDUMONE);
		register(r, getId(marimorphosis), MARIMORPHOSIS);
		register(r, getId(marimorphosisChibi), MARIMORPHOSIS_CHIBI);
		register(r, getId(bubbell), BUBBELL);
		register(r, getId(bubbellChibi), BUBBELL_CHIBI);
		register(r, getId(solegnolia), SOLEGNOLIA);
		register(r, getId(solegnoliaChibi), SOLEGNOLIA_CHIBI);
		register(r, getId(orechidIgnem), ORECHID_IGNEM);
	}
}
