/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2544;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import vazkii.botania.common.block.decor.panes.BlockModPane;
import vazkii.botania.common.block.decor.stairs.BlockModStairs;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibBlockNames;

import static vazkii.botania.common.block.ModBlocks.*;
import static vazkii.botania.common.lib.LibBlockNames.*;

public final class ModFluffBlocks {
	public static final class_2248 livingwoodStairs = new BlockModStairs(livingwood.method_9564(), class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodSlab = new class_2482(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodWall = new class_2544(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFence = new class_2354(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodPlankStairs = new BlockModStairs(livingwoodPlanks.method_9564(), class_4970.class_2251.method_9630(livingwoodPlanks));
	public static final class_2248 livingwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(livingwoodPlanks));

	public static final class_2248 livingrockStairs = new BlockModStairs(livingrock.method_9564(), class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockSlab = new class_2482(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockWall = new class_2544(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickStairs = new BlockModStairs(livingrockBrick.method_9564(), class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickSlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickMossyStairs = new BlockModStairs(livingrockBrickMossy.method_9564(), class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossySlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossyWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrickMossy));

	public static final class_2248 dreamwoodStairs = new BlockModStairs(dreamwood.method_9564(), class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodSlab = new class_2482(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodWall = new class_2544(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFence = new class_2354(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodPlankStairs = new BlockModStairs(dreamwoodPlanks.method_9564(), class_4970.class_2251.method_9630(dreamwoodPlanks));
	public static final class_2248 dreamwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(dreamwoodPlanks));

	public static final class_2248 darkQuartz = new BlockMod(class_4970.class_2251.method_9630(class_2246.field_10153));
	public static final class_2248 darkQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 manaQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 manaQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 blazeQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 blazeQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 lavenderQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 lavenderQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 redQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 redQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 elfQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 elfQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 sunnyQuartz = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzChiseled = new BlockMod(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 sunnyQuartzStairs = new BlockModStairs(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 whitePavement = new BlockMod(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 whitePavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 whitePavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 blackPavement = new BlockMod(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 blackPavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 blackPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 bluePavement = new BlockMod(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 bluePavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 bluePavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 yellowPavement = new BlockMod(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 yellowPavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 yellowPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 redPavement = new BlockMod(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 redPavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 redPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 greenPavement = new BlockMod(class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 greenPavementStair = new BlockModStairs(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 greenPavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 biomeStoneForest = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(1.5F, 10).method_9626(class_2498.field_11544));
	public static final class_2248 biomeStoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneForestStairs = new BlockModStairs(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForest = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestStairs = new BlockModStairs(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForest = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestStairs = new BlockModStairs(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeChiseledBrickForest = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));

	public static final class_2248 biomeStonePlains = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeStonePlainsStairs = new BlockModStairs(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlains = new BlockMod(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsStairs = new BlockModStairs(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlains = new BlockMod(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsStairs = new BlockModStairs(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeChiseledBrickPlains = new BlockMod(class_4970.class_2251.method_9630(biomeStonePlains));

	public static final class_2248 biomeStoneMountain = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeStoneMountainStairs = new BlockModStairs(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountain = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainStairs = new BlockModStairs(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountain = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainStairs = new BlockModStairs(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeChiseledBrickMountain = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMountain));

	public static final class_2248 biomeStoneFungal = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeStoneFungalStairs = new BlockModStairs(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungal = new BlockMod(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalStairs = new BlockModStairs(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungal = new BlockMod(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalStairs = new BlockModStairs(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeChiseledBrickFungal = new BlockMod(class_4970.class_2251.method_9630(biomeStoneFungal));

	public static final class_2248 biomeStoneSwamp = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeStoneSwampStairs = new BlockModStairs(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwamp = new BlockMod(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampStairs = new BlockModStairs(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwamp = new BlockMod(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampStairs = new BlockModStairs(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeChiseledBrickSwamp = new BlockMod(class_4970.class_2251.method_9630(biomeStoneSwamp));

	public static final class_2248 biomeStoneDesert = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeStoneDesertStairs = new BlockModStairs(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesert = new BlockMod(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertStairs = new BlockModStairs(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesert = new BlockMod(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertStairs = new BlockModStairs(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeChiseledBrickDesert = new BlockMod(class_4970.class_2251.method_9630(biomeStoneDesert));

	public static final class_2248 biomeStoneTaiga = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeStoneTaigaStairs = new BlockModStairs(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaiga = new BlockMod(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaStairs = new BlockModStairs(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaiga = new BlockMod(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaStairs = new BlockModStairs(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeChiseledBrickTaiga = new BlockMod(class_4970.class_2251.method_9630(biomeStoneTaiga));

	public static final class_2248 biomeStoneMesa = new BlockMod(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeStoneMesaStairs = new BlockModStairs(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesa = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaStairs = new BlockModStairs(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesa = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaStairs = new BlockModStairs(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeChiseledBrickMesa = new BlockMod(class_4970.class_2251.method_9630(biomeStoneMesa));

	public static final class_2248 shimmerrockSlab = new class_2482(class_4970.class_2251.method_9630(shimmerrock));
	public static final class_2248 shimmerrockStairs = new BlockModStairs(shimmerrock.method_9564(), class_4970.class_2251.method_9630(shimmerrock));

	public static final class_2248 shimmerwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(shimmerwoodPlanks));
	public static final class_2248 shimmerwoodPlankStairs = new BlockModStairs(shimmerwoodPlanks.method_9564(), class_4970.class_2251.method_9630(shimmerwoodPlanks));

	public static final class_2248 managlassPane = new BlockModPane(class_4970.class_2251.method_9630(manaGlass));
	public static final class_2248 alfglassPane = new BlockModPane(class_4970.class_2251.method_9630(elfGlass));
	public static final class_2248 bifrostPane = new BlockModPane(class_4970.class_2251.method_9630(bifrostPerm));

	public static void registerBlocks() {
		class_2378<class_2248> r = class_2378.field_11146;

		register(r, LibBlockNames.LIVING_WOOD + STAIR_SUFFIX, livingwoodStairs);
		register(r, LibBlockNames.LIVING_WOOD + SLAB_SUFFIX, livingwoodSlab);
		register(r, LibBlockNames.LIVING_WOOD + WALL_SUFFIX, livingwoodWall);
		register(r, LibBlockNames.LIVING_WOOD + FENCE_SUFFIX, livingwoodFence);
		register(r, LibBlockNames.LIVING_WOOD + FENCE_GATE_SUFFIX, livingwoodFenceGate);

		register(r, LibBlockNames.LIVING_WOOD_PLANKS + STAIR_SUFFIX, livingwoodPlankStairs);
		register(r, LibBlockNames.LIVING_WOOD_PLANKS + SLAB_SUFFIX, livingwoodPlankSlab);

		register(r, LibBlockNames.LIVING_ROCK + STAIR_SUFFIX, livingrockStairs);
		register(r, LibBlockNames.LIVING_ROCK + SLAB_SUFFIX, livingrockSlab);
		register(r, LibBlockNames.LIVING_ROCK + WALL_SUFFIX, livingrockWall);

		register(r, LibBlockNames.LIVING_ROCK_BRICK + STAIR_SUFFIX, livingrockBrickStairs);
		register(r, LibBlockNames.LIVING_ROCK_BRICK + SLAB_SUFFIX, livingrockBrickSlab);
		register(r, LibBlockNames.LIVING_ROCK_BRICK + WALL_SUFFIX, livingrockBrickWall);

		register(r, LibBlockNames.LIVING_ROCK_BRICK_MOSSY + STAIR_SUFFIX, livingrockBrickMossyStairs);
		register(r, LibBlockNames.LIVING_ROCK_BRICK_MOSSY + SLAB_SUFFIX, livingrockBrickMossySlab);
		register(r, LibBlockNames.LIVING_ROCK_BRICK_MOSSY + WALL_SUFFIX, livingrockBrickMossyWall);

		register(r, LibBlockNames.DREAM_WOOD + STAIR_SUFFIX, dreamwoodStairs);
		register(r, LibBlockNames.DREAM_WOOD + SLAB_SUFFIX, dreamwoodSlab);
		register(r, LibBlockNames.DREAM_WOOD + WALL_SUFFIX, dreamwoodWall);
		register(r, LibBlockNames.DREAM_WOOD + FENCE_SUFFIX, dreamwoodFence);
		register(r, LibBlockNames.DREAM_WOOD + FENCE_GATE_SUFFIX, dreamwoodFenceGate);

		register(r, LibBlockNames.DREAM_WOOD_PLANKS + STAIR_SUFFIX, dreamwoodPlankStairs);
		register(r, LibBlockNames.DREAM_WOOD_PLANKS + SLAB_SUFFIX, dreamwoodPlankSlab);

		register(r, QUARTZ_DARK, darkQuartz);
		register(r, "chiseled_" + QUARTZ_DARK, darkQuartzChiseled);
		register(r, QUARTZ_DARK + "_pillar", darkQuartzPillar);
		register(r, QUARTZ_DARK + SLAB_SUFFIX, darkQuartzSlab);
		register(r, QUARTZ_DARK + STAIR_SUFFIX, darkQuartzStairs);

		register(r, QUARTZ_MANA, manaQuartz);
		register(r, "chiseled_" + QUARTZ_MANA, manaQuartzChiseled);
		register(r, QUARTZ_MANA + "_pillar", manaQuartzPillar);
		register(r, QUARTZ_MANA + SLAB_SUFFIX, manaQuartzSlab);
		register(r, QUARTZ_MANA + STAIR_SUFFIX, manaQuartzStairs);

		register(r, QUARTZ_BLAZE, blazeQuartz);
		register(r, "chiseled_" + QUARTZ_BLAZE, blazeQuartzChiseled);
		register(r, QUARTZ_BLAZE + "_pillar", blazeQuartzPillar);
		register(r, QUARTZ_BLAZE + SLAB_SUFFIX, blazeQuartzSlab);
		register(r, QUARTZ_BLAZE + STAIR_SUFFIX, blazeQuartzStairs);

		register(r, QUARTZ_LAVENDER, lavenderQuartz);
		register(r, "chiseled_" + QUARTZ_LAVENDER, lavenderQuartzChiseled);
		register(r, QUARTZ_LAVENDER + "_pillar", lavenderQuartzPillar);
		register(r, QUARTZ_LAVENDER + SLAB_SUFFIX, lavenderQuartzSlab);
		register(r, QUARTZ_LAVENDER + STAIR_SUFFIX, lavenderQuartzStairs);

		register(r, QUARTZ_RED, redQuartz);
		register(r, "chiseled_" + QUARTZ_RED, redQuartzChiseled);
		register(r, QUARTZ_RED + "_pillar", redQuartzPillar);
		register(r, QUARTZ_RED + SLAB_SUFFIX, redQuartzSlab);
		register(r, QUARTZ_RED + STAIR_SUFFIX, redQuartzStairs);

		register(r, QUARTZ_ELF, elfQuartz);
		register(r, "chiseled_" + QUARTZ_ELF, elfQuartzChiseled);
		register(r, QUARTZ_ELF + "_pillar", elfQuartzPillar);
		register(r, QUARTZ_ELF + SLAB_SUFFIX, elfQuartzSlab);
		register(r, QUARTZ_ELF + STAIR_SUFFIX, elfQuartzStairs);

		register(r, QUARTZ_SUNNY, sunnyQuartz);
		register(r, "chiseled_" + QUARTZ_SUNNY, sunnyQuartzChiseled);
		register(r, QUARTZ_SUNNY + "_pillar", sunnyQuartzPillar);
		register(r, QUARTZ_SUNNY + SLAB_SUFFIX, sunnyQuartzSlab);
		register(r, QUARTZ_SUNNY + STAIR_SUFFIX, sunnyQuartzStairs);

		register(r, "white" + PAVEMENT_SUFFIX, whitePavement);
		register(r, "white" + PAVEMENT_SUFFIX + STAIR_SUFFIX, whitePavementStair);
		register(r, "white" + PAVEMENT_SUFFIX + SLAB_SUFFIX, whitePavementSlab);

		register(r, "black" + PAVEMENT_SUFFIX, blackPavement);
		register(r, "black" + PAVEMENT_SUFFIX + STAIR_SUFFIX, blackPavementStair);
		register(r, "black" + PAVEMENT_SUFFIX + SLAB_SUFFIX, blackPavementSlab);

		register(r, "blue" + PAVEMENT_SUFFIX, bluePavement);
		register(r, "blue" + PAVEMENT_SUFFIX + STAIR_SUFFIX, bluePavementStair);
		register(r, "blue" + PAVEMENT_SUFFIX + SLAB_SUFFIX, bluePavementSlab);

		register(r, "yellow" + PAVEMENT_SUFFIX, yellowPavement);
		register(r, "yellow" + PAVEMENT_SUFFIX + STAIR_SUFFIX, yellowPavementStair);
		register(r, "yellow" + PAVEMENT_SUFFIX + SLAB_SUFFIX, yellowPavementSlab);

		register(r, "red" + PAVEMENT_SUFFIX, redPavement);
		register(r, "red" + PAVEMENT_SUFFIX + STAIR_SUFFIX, redPavementStair);
		register(r, "red" + PAVEMENT_SUFFIX + SLAB_SUFFIX, redPavementSlab);

		register(r, "green" + PAVEMENT_SUFFIX, greenPavement);
		register(r, "green" + PAVEMENT_SUFFIX + STAIR_SUFFIX, greenPavementStair);
		register(r, "green" + PAVEMENT_SUFFIX + SLAB_SUFFIX, greenPavementSlab);

		register(r, METAMORPHIC_PREFIX + "forest_stone", biomeStoneForest);
		register(r, METAMORPHIC_PREFIX + "forest_stone" + SLAB_SUFFIX, biomeStoneForestSlab);
		register(r, METAMORPHIC_PREFIX + "forest_stone" + STAIR_SUFFIX, biomeStoneForestStairs);
		register(r, METAMORPHIC_PREFIX + "forest_cobblestone", biomeCobblestoneForest);
		register(r, METAMORPHIC_PREFIX + "forest_cobblestone" + SLAB_SUFFIX, biomeCobblestoneForestSlab);
		register(r, METAMORPHIC_PREFIX + "forest_cobblestone" + STAIR_SUFFIX, biomeCobblestoneForestStairs);
		register(r, METAMORPHIC_PREFIX + "forest_cobblestone" + WALL_SUFFIX, biomeCobblestoneForestWall);
		register(r, METAMORPHIC_PREFIX + "forest_bricks", biomeBrickForest);
		register(r, METAMORPHIC_PREFIX + "forest_bricks" + SLAB_SUFFIX, biomeBrickForestSlab);
		register(r, METAMORPHIC_PREFIX + "forest_bricks" + STAIR_SUFFIX, biomeBrickForestStairs);
		register(r, METAMORPHIC_PREFIX + "forest_bricks" + WALL_SUFFIX, biomeBrickForestWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "forest_bricks", biomeChiseledBrickForest);

		register(r, METAMORPHIC_PREFIX + "plains_stone", biomeStonePlains);
		register(r, METAMORPHIC_PREFIX + "plains_stone" + SLAB_SUFFIX, biomeStonePlainsSlab);
		register(r, METAMORPHIC_PREFIX + "plains_stone" + STAIR_SUFFIX, biomeStonePlainsStairs);
		register(r, METAMORPHIC_PREFIX + "plains_cobblestone", biomeCobblestonePlains);
		register(r, METAMORPHIC_PREFIX + "plains_cobblestone" + SLAB_SUFFIX, biomeCobblestonePlainsSlab);
		register(r, METAMORPHIC_PREFIX + "plains_cobblestone" + STAIR_SUFFIX, biomeCobblestonePlainsStairs);
		register(r, METAMORPHIC_PREFIX + "plains_cobblestone" + WALL_SUFFIX, biomeCobblestonePlainsWall);
		register(r, METAMORPHIC_PREFIX + "plains_bricks", biomeBrickPlains);
		register(r, METAMORPHIC_PREFIX + "plains_bricks" + SLAB_SUFFIX, biomeBrickPlainsSlab);
		register(r, METAMORPHIC_PREFIX + "plains_bricks" + STAIR_SUFFIX, biomeBrickPlainsStairs);
		register(r, METAMORPHIC_PREFIX + "plains_bricks" + WALL_SUFFIX, biomeBrickPlainsWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "plains_bricks", biomeChiseledBrickPlains);

		register(r, METAMORPHIC_PREFIX + "mountain_stone", biomeStoneMountain);
		register(r, METAMORPHIC_PREFIX + "mountain_stone" + SLAB_SUFFIX, biomeStoneMountainSlab);
		register(r, METAMORPHIC_PREFIX + "mountain_stone" + STAIR_SUFFIX, biomeStoneMountainStairs);
		register(r, METAMORPHIC_PREFIX + "mountain_cobblestone", biomeCobblestoneMountain);
		register(r, METAMORPHIC_PREFIX + "mountain_cobblestone" + SLAB_SUFFIX, biomeCobblestoneMountainSlab);
		register(r, METAMORPHIC_PREFIX + "mountain_cobblestone" + STAIR_SUFFIX, biomeCobblestoneMountainStairs);
		register(r, METAMORPHIC_PREFIX + "mountain_cobblestone" + WALL_SUFFIX, biomeCobblestoneMountainWall);
		register(r, METAMORPHIC_PREFIX + "mountain_bricks", biomeBrickMountain);
		register(r, METAMORPHIC_PREFIX + "mountain_bricks" + SLAB_SUFFIX, biomeBrickMountainSlab);
		register(r, METAMORPHIC_PREFIX + "mountain_bricks" + STAIR_SUFFIX, biomeBrickMountainStairs);
		register(r, METAMORPHIC_PREFIX + "mountain_bricks" + WALL_SUFFIX, biomeBrickMountainWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "mountain_bricks", biomeChiseledBrickMountain);

		register(r, METAMORPHIC_PREFIX + "fungal_stone", biomeStoneFungal);
		register(r, METAMORPHIC_PREFIX + "fungal_stone" + SLAB_SUFFIX, biomeStoneFungalSlab);
		register(r, METAMORPHIC_PREFIX + "fungal_stone" + STAIR_SUFFIX, biomeStoneFungalStairs);
		register(r, METAMORPHIC_PREFIX + "fungal_cobblestone", biomeCobblestoneFungal);
		register(r, METAMORPHIC_PREFIX + "fungal_cobblestone" + SLAB_SUFFIX, biomeCobblestoneFungalSlab);
		register(r, METAMORPHIC_PREFIX + "fungal_cobblestone" + STAIR_SUFFIX, biomeCobblestoneFungalStairs);
		register(r, METAMORPHIC_PREFIX + "fungal_cobblestone" + WALL_SUFFIX, biomeCobblestoneFungalWall);
		register(r, METAMORPHIC_PREFIX + "fungal_bricks", biomeBrickFungal);
		register(r, METAMORPHIC_PREFIX + "fungal_bricks" + SLAB_SUFFIX, biomeBrickFungalSlab);
		register(r, METAMORPHIC_PREFIX + "fungal_bricks" + STAIR_SUFFIX, biomeBrickFungalStairs);
		register(r, METAMORPHIC_PREFIX + "fungal_bricks" + WALL_SUFFIX, biomeBrickFungalWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "fungal_bricks", biomeChiseledBrickFungal);

		register(r, METAMORPHIC_PREFIX + "swamp_stone", biomeStoneSwamp);
		register(r, METAMORPHIC_PREFIX + "swamp_stone" + SLAB_SUFFIX, biomeStoneSwampSlab);
		register(r, METAMORPHIC_PREFIX + "swamp_stone" + STAIR_SUFFIX, biomeStoneSwampStairs);
		register(r, METAMORPHIC_PREFIX + "swamp_cobblestone", biomeCobblestoneSwamp);
		register(r, METAMORPHIC_PREFIX + "swamp_cobblestone" + SLAB_SUFFIX, biomeCobblestoneSwampSlab);
		register(r, METAMORPHIC_PREFIX + "swamp_cobblestone" + STAIR_SUFFIX, biomeCobblestoneSwampStairs);
		register(r, METAMORPHIC_PREFIX + "swamp_cobblestone" + WALL_SUFFIX, biomeCobblestoneSwampWall);
		register(r, METAMORPHIC_PREFIX + "swamp_bricks", biomeBrickSwamp);
		register(r, METAMORPHIC_PREFIX + "swamp_bricks" + SLAB_SUFFIX, biomeBrickSwampSlab);
		register(r, METAMORPHIC_PREFIX + "swamp_bricks" + STAIR_SUFFIX, biomeBrickSwampStairs);
		register(r, METAMORPHIC_PREFIX + "swamp_bricks" + WALL_SUFFIX, biomeBrickSwampWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "swamp_bricks", biomeChiseledBrickSwamp);

		register(r, METAMORPHIC_PREFIX + "desert_stone", biomeStoneDesert);
		register(r, METAMORPHIC_PREFIX + "desert_stone" + SLAB_SUFFIX, biomeStoneDesertSlab);
		register(r, METAMORPHIC_PREFIX + "desert_stone" + STAIR_SUFFIX, biomeStoneDesertStairs);
		register(r, METAMORPHIC_PREFIX + "desert_cobblestone", biomeCobblestoneDesert);
		register(r, METAMORPHIC_PREFIX + "desert_cobblestone" + SLAB_SUFFIX, biomeCobblestoneDesertSlab);
		register(r, METAMORPHIC_PREFIX + "desert_cobblestone" + STAIR_SUFFIX, biomeCobblestoneDesertStairs);
		register(r, METAMORPHIC_PREFIX + "desert_cobblestone" + WALL_SUFFIX, biomeCobblestoneDesertWall);
		register(r, METAMORPHIC_PREFIX + "desert_bricks", biomeBrickDesert);
		register(r, METAMORPHIC_PREFIX + "desert_bricks" + SLAB_SUFFIX, biomeBrickDesertSlab);
		register(r, METAMORPHIC_PREFIX + "desert_bricks" + STAIR_SUFFIX, biomeBrickDesertStairs);
		register(r, METAMORPHIC_PREFIX + "desert_bricks" + WALL_SUFFIX, biomeBrickDesertWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "desert_bricks", biomeChiseledBrickDesert);

		register(r, METAMORPHIC_PREFIX + "taiga_stone", biomeStoneTaiga);
		register(r, METAMORPHIC_PREFIX + "taiga_stone" + SLAB_SUFFIX, biomeStoneTaigaSlab);
		register(r, METAMORPHIC_PREFIX + "taiga_stone" + STAIR_SUFFIX, biomeStoneTaigaStairs);
		register(r, METAMORPHIC_PREFIX + "taiga_cobblestone", biomeCobblestoneTaiga);
		register(r, METAMORPHIC_PREFIX + "taiga_cobblestone" + SLAB_SUFFIX, biomeCobblestoneTaigaSlab);
		register(r, METAMORPHIC_PREFIX + "taiga_cobblestone" + STAIR_SUFFIX, biomeCobblestoneTaigaStairs);
		register(r, METAMORPHIC_PREFIX + "taiga_cobblestone" + WALL_SUFFIX, biomeCobblestoneTaigaWall);
		register(r, METAMORPHIC_PREFIX + "taiga_bricks", biomeBrickTaiga);
		register(r, METAMORPHIC_PREFIX + "taiga_bricks" + SLAB_SUFFIX, biomeBrickTaigaSlab);
		register(r, METAMORPHIC_PREFIX + "taiga_bricks" + STAIR_SUFFIX, biomeBrickTaigaStairs);
		register(r, METAMORPHIC_PREFIX + "taiga_bricks" + WALL_SUFFIX, biomeBrickTaigaWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "taiga_bricks", biomeChiseledBrickTaiga);

		register(r, METAMORPHIC_PREFIX + "mesa_stone", biomeStoneMesa);
		register(r, METAMORPHIC_PREFIX + "mesa_stone" + SLAB_SUFFIX, biomeStoneMesaSlab);
		register(r, METAMORPHIC_PREFIX + "mesa_stone" + STAIR_SUFFIX, biomeStoneMesaStairs);
		register(r, METAMORPHIC_PREFIX + "mesa_cobblestone", biomeCobblestoneMesa);
		register(r, METAMORPHIC_PREFIX + "mesa_cobblestone" + SLAB_SUFFIX, biomeCobblestoneMesaSlab);
		register(r, METAMORPHIC_PREFIX + "mesa_cobblestone" + STAIR_SUFFIX, biomeCobblestoneMesaStairs);
		register(r, METAMORPHIC_PREFIX + "mesa_cobblestone" + WALL_SUFFIX, biomeCobblestoneMesaWall);
		register(r, METAMORPHIC_PREFIX + "mesa_bricks", biomeBrickMesa);
		register(r, METAMORPHIC_PREFIX + "mesa_bricks" + SLAB_SUFFIX, biomeBrickMesaSlab);
		register(r, METAMORPHIC_PREFIX + "mesa_bricks" + STAIR_SUFFIX, biomeBrickMesaStairs);
		register(r, METAMORPHIC_PREFIX + "mesa_bricks" + WALL_SUFFIX, biomeBrickMesaWall);
		register(r, "chiseled_" + METAMORPHIC_PREFIX + "mesa_bricks", biomeChiseledBrickMesa);

		register(r, LibBlockNames.SHIMMERROCK + SLAB_SUFFIX, shimmerrockSlab);
		register(r, LibBlockNames.SHIMMERROCK + STAIR_SUFFIX, shimmerrockStairs);

		register(r, LibBlockNames.SHIMMERWOOD_PLANKS + SLAB_SUFFIX, shimmerwoodPlankSlab);
		register(r, LibBlockNames.SHIMMERWOOD_PLANKS + STAIR_SUFFIX, shimmerwoodPlankStairs);

		register(r, LibBlockNames.MANA_GLASS + "_pane", managlassPane);
		register(r, LibBlockNames.ELF_GLASS + "_pane", alfglassPane);
		register(r, LibBlockNames.BIFROST + "_pane", bifrostPane);
	}

	public static void registerItemBlocks() {
		class_2378<class_1792> r = class_2378.field_11142;
		class_1792.class_1793 props = ModItems.defaultBuilder();

		register(r, class_2378.field_11146.method_10221(livingwoodStairs), new class_1747(livingwoodStairs, props));
		register(r, class_2378.field_11146.method_10221(livingwoodSlab), new class_1747(livingwoodSlab, props));
		register(r, class_2378.field_11146.method_10221(livingwoodWall), new class_1747(livingwoodWall, props));
		register(r, class_2378.field_11146.method_10221(livingwoodFence), new class_1747(livingwoodFence, props));
		register(r, class_2378.field_11146.method_10221(livingwoodFenceGate), new class_1747(livingwoodFenceGate, props));

		register(r, class_2378.field_11146.method_10221(livingwoodPlankStairs), new class_1747(livingwoodPlankStairs, props));
		register(r, class_2378.field_11146.method_10221(livingwoodPlankSlab), new class_1747(livingwoodPlankSlab, props));

		register(r, class_2378.field_11146.method_10221(livingrockStairs), new class_1747(livingrockStairs, props));
		register(r, class_2378.field_11146.method_10221(livingrockSlab), new class_1747(livingrockSlab, props));
		register(r, class_2378.field_11146.method_10221(livingrockWall), new class_1747(livingrockWall, props));

		register(r, class_2378.field_11146.method_10221(livingrockBrickStairs), new class_1747(livingrockBrickStairs, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickSlab), new class_1747(livingrockBrickSlab, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickWall), new class_1747(livingrockBrickWall, props));

		register(r, class_2378.field_11146.method_10221(livingrockBrickMossyStairs), new class_1747(livingrockBrickMossyStairs, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickMossySlab), new class_1747(livingrockBrickMossySlab, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickMossyWall), new class_1747(livingrockBrickMossyWall, props));

		register(r, class_2378.field_11146.method_10221(dreamwoodStairs), new class_1747(dreamwoodStairs, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodSlab), new class_1747(dreamwoodSlab, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodWall), new class_1747(dreamwoodWall, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodFence), new class_1747(dreamwoodFence, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodFenceGate), new class_1747(dreamwoodFenceGate, props));

		register(r, class_2378.field_11146.method_10221(dreamwoodPlankStairs), new class_1747(dreamwoodPlankStairs, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodPlankSlab), new class_1747(dreamwoodPlankSlab, props));

		register(r, class_2378.field_11146.method_10221(darkQuartz), new class_1747(darkQuartz, props));
		register(r, class_2378.field_11146.method_10221(darkQuartzPillar), new class_1747(darkQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(darkQuartzChiseled), new class_1747(darkQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(darkQuartzSlab), new class_1747(darkQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(darkQuartzStairs), new class_1747(darkQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(manaQuartz), new class_1747(manaQuartz, props));
		register(r, class_2378.field_11146.method_10221(manaQuartzPillar), new class_1747(manaQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(manaQuartzChiseled), new class_1747(manaQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(manaQuartzSlab), new class_1747(manaQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(manaQuartzStairs), new class_1747(manaQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(blazeQuartz), new class_1747(blazeQuartz, props));
		register(r, class_2378.field_11146.method_10221(blazeQuartzPillar), new class_1747(blazeQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(blazeQuartzChiseled), new class_1747(blazeQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(blazeQuartzSlab), new class_1747(blazeQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(blazeQuartzStairs), new class_1747(blazeQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(lavenderQuartz), new class_1747(lavenderQuartz, props));
		register(r, class_2378.field_11146.method_10221(lavenderQuartzPillar), new class_1747(lavenderQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(lavenderQuartzChiseled), new class_1747(lavenderQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(lavenderQuartzSlab), new class_1747(lavenderQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(lavenderQuartzStairs), new class_1747(lavenderQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(redQuartz), new class_1747(redQuartz, props));
		register(r, class_2378.field_11146.method_10221(redQuartzPillar), new class_1747(redQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(redQuartzChiseled), new class_1747(redQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(redQuartzSlab), new class_1747(redQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(redQuartzStairs), new class_1747(redQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(elfQuartz), new class_1747(elfQuartz, props));
		register(r, class_2378.field_11146.method_10221(elfQuartzPillar), new class_1747(elfQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(elfQuartzChiseled), new class_1747(elfQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(elfQuartzSlab), new class_1747(elfQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(elfQuartzStairs), new class_1747(elfQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(sunnyQuartz), new class_1747(sunnyQuartz, props));
		register(r, class_2378.field_11146.method_10221(sunnyQuartzPillar), new class_1747(sunnyQuartzPillar, props));
		register(r, class_2378.field_11146.method_10221(sunnyQuartzChiseled), new class_1747(sunnyQuartzChiseled, props));
		register(r, class_2378.field_11146.method_10221(sunnyQuartzSlab), new class_1747(sunnyQuartzSlab, props));
		register(r, class_2378.field_11146.method_10221(sunnyQuartzStairs), new class_1747(sunnyQuartzStairs, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneForest), new class_1747(biomeStoneForest, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneForestSlab), new class_1747(biomeStoneForestSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneForestStairs), new class_1747(biomeStoneForestStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickForest), new class_1747(biomeBrickForest, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickForestSlab), new class_1747(biomeBrickForestSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickForestStairs), new class_1747(biomeBrickForestStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickForestWall), new class_1747(biomeBrickForestWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneForest), new class_1747(biomeCobblestoneForest, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneForestSlab), new class_1747(biomeCobblestoneForestSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneForestStairs), new class_1747(biomeCobblestoneForestStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneForestWall), new class_1747(biomeCobblestoneForestWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickForest), new class_1747(biomeChiseledBrickForest, props));

		register(r, class_2378.field_11146.method_10221(biomeStonePlains), new class_1747(biomeStonePlains, props));
		register(r, class_2378.field_11146.method_10221(biomeStonePlainsSlab), new class_1747(biomeStonePlainsSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStonePlainsStairs), new class_1747(biomeStonePlainsStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickPlains), new class_1747(biomeBrickPlains, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickPlainsSlab), new class_1747(biomeBrickPlainsSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickPlainsStairs), new class_1747(biomeBrickPlainsStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickPlainsWall), new class_1747(biomeBrickPlainsWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestonePlains), new class_1747(biomeCobblestonePlains, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestonePlainsSlab), new class_1747(biomeCobblestonePlainsSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestonePlainsStairs), new class_1747(biomeCobblestonePlainsStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestonePlainsWall), new class_1747(biomeCobblestonePlainsWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickPlains), new class_1747(biomeChiseledBrickPlains, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneMountain), new class_1747(biomeStoneMountain, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneMountainSlab), new class_1747(biomeStoneMountainSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneMountainStairs), new class_1747(biomeStoneMountainStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMountain), new class_1747(biomeBrickMountain, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMountainSlab), new class_1747(biomeBrickMountainSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMountainStairs), new class_1747(biomeBrickMountainStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMountainWall), new class_1747(biomeBrickMountainWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMountain), new class_1747(biomeCobblestoneMountain, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMountainSlab), new class_1747(biomeCobblestoneMountainSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMountainStairs), new class_1747(biomeCobblestoneMountainStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMountainWall), new class_1747(biomeCobblestoneMountainWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickMountain), new class_1747(biomeChiseledBrickMountain, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneFungal), new class_1747(biomeStoneFungal, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneFungalSlab), new class_1747(biomeStoneFungalSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneFungalStairs), new class_1747(biomeStoneFungalStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickFungal), new class_1747(biomeBrickFungal, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickFungalSlab), new class_1747(biomeBrickFungalSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickFungalStairs), new class_1747(biomeBrickFungalStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickFungalWall), new class_1747(biomeBrickFungalWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneFungal), new class_1747(biomeCobblestoneFungal, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneFungalSlab), new class_1747(biomeCobblestoneFungalSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneFungalStairs), new class_1747(biomeCobblestoneFungalStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneFungalWall), new class_1747(biomeCobblestoneFungalWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickFungal), new class_1747(biomeChiseledBrickFungal, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneSwamp), new class_1747(biomeStoneSwamp, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneSwampSlab), new class_1747(biomeStoneSwampSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneSwampStairs), new class_1747(biomeStoneSwampStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickSwamp), new class_1747(biomeBrickSwamp, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickSwampSlab), new class_1747(biomeBrickSwampSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickSwampStairs), new class_1747(biomeBrickSwampStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickSwampWall), new class_1747(biomeBrickSwampWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneSwamp), new class_1747(biomeCobblestoneSwamp, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneSwampSlab), new class_1747(biomeCobblestoneSwampSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneSwampStairs), new class_1747(biomeCobblestoneSwampStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneSwampWall), new class_1747(biomeCobblestoneSwampWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickSwamp), new class_1747(biomeChiseledBrickSwamp, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneDesert), new class_1747(biomeStoneDesert, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneDesertSlab), new class_1747(biomeStoneDesertSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneDesertStairs), new class_1747(biomeStoneDesertStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickDesert), new class_1747(biomeBrickDesert, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickDesertSlab), new class_1747(biomeBrickDesertSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickDesertStairs), new class_1747(biomeBrickDesertStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickDesertWall), new class_1747(biomeBrickDesertWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneDesert), new class_1747(biomeCobblestoneDesert, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneDesertSlab), new class_1747(biomeCobblestoneDesertSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneDesertStairs), new class_1747(biomeCobblestoneDesertStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneDesertWall), new class_1747(biomeCobblestoneDesertWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickDesert), new class_1747(biomeChiseledBrickDesert, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneTaiga), new class_1747(biomeStoneTaiga, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneTaigaSlab), new class_1747(biomeStoneTaigaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneTaigaStairs), new class_1747(biomeStoneTaigaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickTaiga), new class_1747(biomeBrickTaiga, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickTaigaSlab), new class_1747(biomeBrickTaigaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickTaigaStairs), new class_1747(biomeBrickTaigaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickTaigaWall), new class_1747(biomeBrickTaigaWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneTaiga), new class_1747(biomeCobblestoneTaiga, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneTaigaSlab), new class_1747(biomeCobblestoneTaigaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneTaigaStairs), new class_1747(biomeCobblestoneTaigaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneTaigaWall), new class_1747(biomeCobblestoneTaigaWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickTaiga), new class_1747(biomeChiseledBrickTaiga, props));

		register(r, class_2378.field_11146.method_10221(biomeStoneMesa), new class_1747(biomeStoneMesa, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneMesaSlab), new class_1747(biomeStoneMesaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeStoneMesaStairs), new class_1747(biomeStoneMesaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMesa), new class_1747(biomeBrickMesa, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMesaSlab), new class_1747(biomeBrickMesaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMesaStairs), new class_1747(biomeBrickMesaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeBrickMesaWall), new class_1747(biomeBrickMesaWall, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMesa), new class_1747(biomeCobblestoneMesa, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMesaSlab), new class_1747(biomeCobblestoneMesaSlab, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMesaStairs), new class_1747(biomeCobblestoneMesaStairs, props));
		register(r, class_2378.field_11146.method_10221(biomeCobblestoneMesaWall), new class_1747(biomeCobblestoneMesaWall, props));
		register(r, class_2378.field_11146.method_10221(biomeChiseledBrickMesa), new class_1747(biomeChiseledBrickMesa, props));

		register(r, class_2378.field_11146.method_10221(whitePavement), new class_1747(whitePavement, props));
		register(r, class_2378.field_11146.method_10221(blackPavement), new class_1747(blackPavement, props));
		register(r, class_2378.field_11146.method_10221(bluePavement), new class_1747(bluePavement, props));
		register(r, class_2378.field_11146.method_10221(yellowPavement), new class_1747(yellowPavement, props));
		register(r, class_2378.field_11146.method_10221(redPavement), new class_1747(redPavement, props));
		register(r, class_2378.field_11146.method_10221(greenPavement), new class_1747(greenPavement, props));

		register(r, class_2378.field_11146.method_10221(whitePavementSlab), new class_1747(whitePavementSlab, props));
		register(r, class_2378.field_11146.method_10221(blackPavementSlab), new class_1747(blackPavementSlab, props));
		register(r, class_2378.field_11146.method_10221(bluePavementSlab), new class_1747(bluePavementSlab, props));
		register(r, class_2378.field_11146.method_10221(yellowPavementSlab), new class_1747(yellowPavementSlab, props));
		register(r, class_2378.field_11146.method_10221(redPavementSlab), new class_1747(redPavementSlab, props));
		register(r, class_2378.field_11146.method_10221(greenPavementSlab), new class_1747(greenPavementSlab, props));

		register(r, class_2378.field_11146.method_10221(whitePavementStair), new class_1747(whitePavementStair, props));
		register(r, class_2378.field_11146.method_10221(blackPavementStair), new class_1747(blackPavementStair, props));
		register(r, class_2378.field_11146.method_10221(bluePavementStair), new class_1747(bluePavementStair, props));
		register(r, class_2378.field_11146.method_10221(yellowPavementStair), new class_1747(yellowPavementStair, props));
		register(r, class_2378.field_11146.method_10221(redPavementStair), new class_1747(redPavementStair, props));
		register(r, class_2378.field_11146.method_10221(greenPavementStair), new class_1747(greenPavementStair, props));

		register(r, class_2378.field_11146.method_10221(shimmerrockSlab), new class_1747(shimmerrockSlab, props));
		register(r, class_2378.field_11146.method_10221(shimmerrockStairs), new class_1747(shimmerrockStairs, props));

		register(r, class_2378.field_11146.method_10221(shimmerwoodPlankSlab), new class_1747(shimmerwoodPlankSlab, props));
		register(r, class_2378.field_11146.method_10221(shimmerwoodPlankStairs), new class_1747(shimmerwoodPlankStairs, props));

		register(r, class_2378.field_11146.method_10221(managlassPane), new class_1747(managlassPane, props));
		register(r, class_2378.field_11146.method_10221(alfglassPane), new class_1747(alfglassPane, props));
		register(r, class_2378.field_11146.method_10221(bifrostPane), new class_1747(bifrostPane, props));
	}

}
