/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.block.*;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1827;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_2969;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.item.*;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.corporea.*;
import vazkii.botania.common.block.decor.*;
import vazkii.botania.common.block.decor.stairs.BlockModStairs;
import vazkii.botania.common.block.dispenser.*;
import vazkii.botania.common.block.mana.*;
import vazkii.botania.common.block.string.*;
import vazkii.botania.common.entity.EntityEnderAirBottle;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockDreamwood;
import vazkii.botania.common.item.block.ItemBlockElven;
import vazkii.botania.common.item.block.ItemBlockPool;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.mixin.AccessorDispenserBlock;

import javax.annotation.Nonnull;

import java.util.Locale;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class ModBlocks {
	private static final class_4970.class_4972<class_1299<?>> NO_SPAWN = (state, world, pos, et) -> false;
	private static final class_4970.class_4973 NO_SUFFOCATION = (state, world, pos) -> false;

	public static final class_2248 whiteFlower = new BlockModFlower(class_1767.field_7952, class_4970.class_2251.method_9637(class_3614.field_15935).method_9634().method_9632(0).method_9626(class_2498.field_11535));
	public static final class_2248 orangeFlower = new BlockModFlower(class_1767.field_7946, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 magentaFlower = new BlockModFlower(class_1767.field_7958, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightBlueFlower = new BlockModFlower(class_1767.field_7951, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 yellowFlower = new BlockModFlower(class_1767.field_7947, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 limeFlower = new BlockModFlower(class_1767.field_7961, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 pinkFlower = new BlockModFlower(class_1767.field_7954, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 grayFlower = new BlockModFlower(class_1767.field_7944, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightGrayFlower = new BlockModFlower(class_1767.field_7967, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 cyanFlower = new BlockModFlower(class_1767.field_7955, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 purpleFlower = new BlockModFlower(class_1767.field_7945, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blueFlower = new BlockModFlower(class_1767.field_7966, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 brownFlower = new BlockModFlower(class_1767.field_7957, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 greenFlower = new BlockModFlower(class_1767.field_7942, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 redFlower = new BlockModFlower(class_1767.field_7964, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blackFlower = new BlockModFlower(class_1767.field_7963, class_4970.class_2251.method_9630(whiteFlower));

	public static final class_2248 whiteShinyFlower = new BlockShinyFlower(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 15));
	public static final class_2248 orangeShinyFlower = new BlockShinyFlower(class_1767.field_7946, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 magentaShinyFlower = new BlockShinyFlower(class_1767.field_7958, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightBlueShinyFlower = new BlockShinyFlower(class_1767.field_7951, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 yellowShinyFlower = new BlockShinyFlower(class_1767.field_7947, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 limeShinyFlower = new BlockShinyFlower(class_1767.field_7961, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 pinkShinyFlower = new BlockShinyFlower(class_1767.field_7954, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 grayShinyFlower = new BlockShinyFlower(class_1767.field_7944, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightGrayShinyFlower = new BlockShinyFlower(class_1767.field_7967, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 cyanShinyFlower = new BlockShinyFlower(class_1767.field_7955, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 purpleShinyFlower = new BlockShinyFlower(class_1767.field_7945, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blueShinyFlower = new BlockShinyFlower(class_1767.field_7966, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 brownShinyFlower = new BlockShinyFlower(class_1767.field_7957, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 greenShinyFlower = new BlockShinyFlower(class_1767.field_7942, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 redShinyFlower = new BlockShinyFlower(class_1767.field_7964, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blackShinyFlower = new BlockShinyFlower(class_1767.field_7963, class_4970.class_2251.method_9630(whiteShinyFlower));

	public static final class_2248 whiteBuriedPetals = new BlockBuriedPetals(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 4));
	public static final class_2248 orangeBuriedPetals = new BlockBuriedPetals(class_1767.field_7946, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 magentaBuriedPetals = new BlockBuriedPetals(class_1767.field_7958, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightBlueBuriedPetals = new BlockBuriedPetals(class_1767.field_7951, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 yellowBuriedPetals = new BlockBuriedPetals(class_1767.field_7947, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 limeBuriedPetals = new BlockBuriedPetals(class_1767.field_7961, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 pinkBuriedPetals = new BlockBuriedPetals(class_1767.field_7954, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 grayBuriedPetals = new BlockBuriedPetals(class_1767.field_7944, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightGrayBuriedPetals = new BlockBuriedPetals(class_1767.field_7967, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 cyanBuriedPetals = new BlockBuriedPetals(class_1767.field_7955, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 purpleBuriedPetals = new BlockBuriedPetals(class_1767.field_7945, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blueBuriedPetals = new BlockBuriedPetals(class_1767.field_7966, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 brownBuriedPetals = new BlockBuriedPetals(class_1767.field_7957, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 greenBuriedPetals = new BlockBuriedPetals(class_1767.field_7942, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 redBuriedPetals = new BlockBuriedPetals(class_1767.field_7964, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blackBuriedPetals = new BlockBuriedPetals(class_1767.field_7963, class_4970.class_2251.method_9630(whiteBuriedPetals));

	public static final class_4970.class_2251 FLOATING_PROPS = FabricBlockSettings.copyOf(class_4970.class_2251.method_9637(class_3614.field_15941).method_9632(0.5F).method_9626(class_2498.field_11529).method_9631(s -> 15))
			.breakByTool(FabricToolTags.SHOVELS);
	public static final class_2248 whiteFloatingFlower = new BlockFloatingFlower(class_1767.field_7952, FLOATING_PROPS);
	public static final class_2248 orangeFloatingFlower = new BlockFloatingFlower(class_1767.field_7946, FLOATING_PROPS);
	public static final class_2248 magentaFloatingFlower = new BlockFloatingFlower(class_1767.field_7958, FLOATING_PROPS);
	public static final class_2248 lightBlueFloatingFlower = new BlockFloatingFlower(class_1767.field_7951, FLOATING_PROPS);
	public static final class_2248 yellowFloatingFlower = new BlockFloatingFlower(class_1767.field_7947, FLOATING_PROPS);
	public static final class_2248 limeFloatingFlower = new BlockFloatingFlower(class_1767.field_7961, FLOATING_PROPS);
	public static final class_2248 pinkFloatingFlower = new BlockFloatingFlower(class_1767.field_7954, FLOATING_PROPS);
	public static final class_2248 grayFloatingFlower = new BlockFloatingFlower(class_1767.field_7944, FLOATING_PROPS);
	public static final class_2248 lightGrayFloatingFlower = new BlockFloatingFlower(class_1767.field_7967, FLOATING_PROPS);
	public static final class_2248 cyanFloatingFlower = new BlockFloatingFlower(class_1767.field_7955, FLOATING_PROPS);
	public static final class_2248 purpleFloatingFlower = new BlockFloatingFlower(class_1767.field_7945, FLOATING_PROPS);
	public static final class_2248 blueFloatingFlower = new BlockFloatingFlower(class_1767.field_7966, FLOATING_PROPS);
	public static final class_2248 brownFloatingFlower = new BlockFloatingFlower(class_1767.field_7957, FLOATING_PROPS);
	public static final class_2248 greenFloatingFlower = new BlockFloatingFlower(class_1767.field_7942, FLOATING_PROPS);
	public static final class_2248 redFloatingFlower = new BlockFloatingFlower(class_1767.field_7964, FLOATING_PROPS);
	public static final class_2248 blackFloatingFlower = new BlockFloatingFlower(class_1767.field_7963, FLOATING_PROPS);

	public static final class_2248 petalBlockWhite = new BlockPetalBlock(class_1767.field_7952, class_4970.class_2251.method_9637(class_3614.field_15935).method_9632(0.4F).method_9626(class_2498.field_11535));
	public static final class_2248 petalBlockOrange = new BlockPetalBlock(class_1767.field_7946, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockMagenta = new BlockPetalBlock(class_1767.field_7958, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockLightBlue = new BlockPetalBlock(class_1767.field_7951, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockYellow = new BlockPetalBlock(class_1767.field_7947, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockLime = new BlockPetalBlock(class_1767.field_7961, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockPink = new BlockPetalBlock(class_1767.field_7954, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockGray = new BlockPetalBlock(class_1767.field_7944, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockSilver = new BlockPetalBlock(class_1767.field_7967, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockCyan = new BlockPetalBlock(class_1767.field_7955, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockPurple = new BlockPetalBlock(class_1767.field_7945, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBlue = new BlockPetalBlock(class_1767.field_7966, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBrown = new BlockPetalBlock(class_1767.field_7957, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockGreen = new BlockPetalBlock(class_1767.field_7942, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockRed = new BlockPetalBlock(class_1767.field_7964, class_4970.class_2251.method_9630(petalBlockWhite));
	public static final class_2248 petalBlockBlack = new BlockPetalBlock(class_1767.field_7963, class_4970.class_2251.method_9630(petalBlockWhite));

	public static final class_2248 whiteMushroom = new BlockModMushroom(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 3));
	public static final class_2248 orangeMushroom = new BlockModMushroom(class_1767.field_7946, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 magentaMushroom = new BlockModMushroom(class_1767.field_7958, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightBlueMushroom = new BlockModMushroom(class_1767.field_7951, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 yellowMushroom = new BlockModMushroom(class_1767.field_7947, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 limeMushroom = new BlockModMushroom(class_1767.field_7961, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 pinkMushroom = new BlockModMushroom(class_1767.field_7954, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 grayMushroom = new BlockModMushroom(class_1767.field_7944, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightGrayMushroom = new BlockModMushroom(class_1767.field_7967, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 cyanMushroom = new BlockModMushroom(class_1767.field_7955, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 purpleMushroom = new BlockModMushroom(class_1767.field_7945, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blueMushroom = new BlockModMushroom(class_1767.field_7966, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 brownMushroom = new BlockModMushroom(class_1767.field_7957, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 greenMushroom = new BlockModMushroom(class_1767.field_7942, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 redMushroom = new BlockModMushroom(class_1767.field_7964, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blackMushroom = new BlockModMushroom(class_1767.field_7963, class_4970.class_2251.method_9630(whiteMushroom));

	public static final class_2248 doubleFlowerWhite = new BlockModDoubleFlower(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 doubleFlowerOrange = new BlockModDoubleFlower(class_1767.field_7946, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerMagenta = new BlockModDoubleFlower(class_1767.field_7958, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightBlue = new BlockModDoubleFlower(class_1767.field_7951, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerYellow = new BlockModDoubleFlower(class_1767.field_7947, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLime = new BlockModDoubleFlower(class_1767.field_7961, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPink = new BlockModDoubleFlower(class_1767.field_7954, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGray = new BlockModDoubleFlower(class_1767.field_7944, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightGray = new BlockModDoubleFlower(class_1767.field_7967, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerCyan = new BlockModDoubleFlower(class_1767.field_7955, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPurple = new BlockModDoubleFlower(class_1767.field_7945, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlue = new BlockModDoubleFlower(class_1767.field_7966, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBrown = new BlockModDoubleFlower(class_1767.field_7957, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGreen = new BlockModDoubleFlower(class_1767.field_7942, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerRed = new BlockModDoubleFlower(class_1767.field_7964, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlack = new BlockModDoubleFlower(class_1767.field_7963, class_4970.class_2251.method_9630(doubleFlowerWhite));

	public static final class_2248 defaultAltar = new BlockAltar(BlockAltar.Variant.DEFAULT, class_4970.class_2251.method_9637(class_3614.field_15914).method_9632(3.5F).method_9626(class_2498.field_11544)
			.method_9631(s -> s.method_11654(BlockAltar.FLUID) == IPetalApothecary.State.LAVA ? 15 : 0));
	public static final class_2248 forestAltar = new BlockAltar(BlockAltar.Variant.FOREST, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 plainsAltar = new BlockAltar(BlockAltar.Variant.PLAINS, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 mountainAltar = new BlockAltar(BlockAltar.Variant.MOUNTAIN, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 fungalAltar = new BlockAltar(BlockAltar.Variant.FUNGAL, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 swampAltar = new BlockAltar(BlockAltar.Variant.SWAMP, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 desertAltar = new BlockAltar(BlockAltar.Variant.DESERT, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 taigaAltar = new BlockAltar(BlockAltar.Variant.TAIGA, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 mesaAltar = new BlockAltar(BlockAltar.Variant.MESA, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 mossyAltar = new BlockAltar(BlockAltar.Variant.MOSSY, class_4970.class_2251.method_9630(defaultAltar));

	public static final class_2248 livingrock = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 10).method_9626(class_2498.field_11544));
	public static final class_2248 livingrockBrick = new BlockMod(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickChiseled = new BlockMod(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickCracked = new BlockMod(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickMossy = new BlockMod(class_4970.class_2251.method_9630(livingrock));

	// TODO 1.16+ livingwood/dreamwood should support leaves?
	public static final class_2248 livingwood = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(2).method_9626(class_2498.field_11547));
	public static final class_2248 livingwoodPlanks = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodPlanksMossy = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFramed = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodPatternFramed = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodGlimmering = new BlockMod(class_4970.class_2251.method_9630(livingwood).method_9631(s -> 12));

	public static final class_2248 dreamwood = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodPlanks = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodPlanksMossy = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodFramed = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodPatternFramed = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dreamwoodGlimmering = new BlockMod(class_4970.class_2251.method_9630(livingwoodGlimmering));

	public static final class_2248 manaSpreader = new BlockSpreader(BlockSpreader.Variant.MANA, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 redstoneSpreader = new BlockSpreader(BlockSpreader.Variant.REDSTONE, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 elvenSpreader = new BlockSpreader(BlockSpreader.Variant.ELVEN, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 gaiaSpreader = new BlockSpreader(BlockSpreader.Variant.GAIA, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));

	public static final class_2248 manaPool = new BlockPool(BlockPool.Variant.DEFAULT, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 creativePool = new BlockPool(BlockPool.Variant.CREATIVE, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 dilutedPool = new BlockPool(BlockPool.Variant.DILUTED, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 fabulousPool = new BlockPool(BlockPool.Variant.FABULOUS, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 alchemyCatalyst = new BlockAlchemyCatalyst(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 conjurationCatalyst = new BlockConjurationCatalyst(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 manasteelBlock = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(3, 10).method_9626(class_2498.field_11533));
	public static final class_2248 terrasteelBlock = new BlockMod(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 elementiumBlock = new BlockMod(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 manaDiamondBlock = new BlockMod(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 dragonstoneBlock = new BlockMod(class_4970.class_2251.method_9630(manasteelBlock));

	public static final class_2248 manaGlass = new BlockModGlass(class_4970.class_2251.method_9630(class_2246.field_10033).method_9631(s -> 15).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 elfGlass = new BlockModGlass(class_4970.class_2251.method_9630(manaGlass).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrost = new BlockBifrost(class_4970.class_2251.method_9637(class_3614.field_15942).method_9629(-1, 0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrostPerm = new BlockBifrostPerm(class_4970.class_2251.method_9637(class_3614.field_15942).method_9632(0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));

	public static final class_2248 runeAltar = new BlockRuneAltar(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 enchanter = new BlockEnchanter(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(3, 5).method_9631(s -> 15).method_9626(class_2498.field_11544));
	public static final class_2248 brewery = new BlockBrewery(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 terraPlate = new BlockTerraPlate(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(3, 10).method_9626(class_2498.field_11533));
	public static final class_2248 alfPortal = new BlockAlfPortal(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(10).method_9626(class_2498.field_11547)
			.method_9631(s -> s.method_11654(BotaniaStateProps.ALFPORTAL_STATE) != AlfPortalState.OFF ? 15 : 0));

	public static final class_2248 manaPylon = new BlockPylon(BlockPylon.Variant.MANA, class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_9631(s -> 7));
	public static final class_2248 naturaPylon = new BlockPylon(BlockPylon.Variant.NATURA, class_4970.class_2251.method_9630(manaPylon));
	public static final class_2248 gaiaPylon = new BlockPylon(BlockPylon.Variant.GAIA, class_4970.class_2251.method_9630(manaPylon));

	public static final class_2248 distributor = new BlockDistributor(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 10).method_9626(class_2498.field_11544));
	public static final class_2248 manaVoid = new BlockManaVoid(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 2000).method_9626(class_2498.field_11544));
	public static final class_2248 manaDetector = new BlockManaDetector(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 pistonRelay = new BlockPistonRelay(class_4970.class_2251.method_9637(class_3614.field_15954).method_9629(2, 10).method_9626(class_2498.field_11533).method_26235(NO_SPAWN));
	public static final class_2248 turntable = new BlockTurntable(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 tinyPlanet = new BlockTinyPlanet(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(20, 100).method_9626(class_2498.field_11544));
	public static final class_2248 wildDrum = new BlockForestDrum(BlockForestDrum.Variant.WILD, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 gatheringDrum = new BlockForestDrum(BlockForestDrum.Variant.GATHERING, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 canopyDrum = new BlockForestDrum(BlockForestDrum.Variant.CANOPY, class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 spawnerClaw = new BlockSpawnerClaw(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(3));
	public static final class_2248 rfGenerator = new BlockRFGenerator(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 prism = new BlockPrism(class_4970.class_2251.method_9630(elfGlass).method_9634());
	public static final class_2248 pump = new BlockPump(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 sparkChanger = new BlockSparkChanger(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 manaBomb = new BlockManaBomb(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(12).method_9626(class_2498.field_11547));
	public static final class_2248 bellows = new BlockBellows(class_4970.class_2251.method_9630(livingwood));

	public static final class_2248 openCrate = new BlockOpenCrate(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 craftCrate = new BlockCraftyCrate(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 forestEye = new BlockForestEye(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(5, 10).method_9626(class_2498.field_11533));
	public static final class_2248 solidVines = new BlockSolidVines(class_4970.class_2251.method_9637(class_3614.field_15956).method_9632(0.2F).method_9626(class_2498.field_11535).method_22488());
	public static final class_2248 abstrusePlatform = new BlockPlatform(BlockPlatform.Variant.ABSTRUSE, class_4970.class_2251.method_9637(class_3614.field_15932).method_9629(2, 5).method_9626(class_2498.field_11547));
	public static final class_2248 spectralPlatform = new BlockPlatform(BlockPlatform.Variant.SPECTRAL, class_4970.class_2251.method_9630(abstrusePlatform));
	public static final class_2248 infrangiblePlatform = new BlockPlatform(BlockPlatform.Variant.INFRANGIBLE, class_4970.class_2251.method_9637(class_3614.field_15932).method_9629(-1, Float.MAX_VALUE).method_9626(class_2498.field_11547));
	public static final class_2248 tinyPotato = new BlockTinyPotato(class_4970.class_2251.method_9637(class_3614.field_15931).method_9632(0.25F));
	public static final class_2248 enderEye = new BlockEnderEye(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 redStringContainer = new BlockRedStringContainer(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringDispenser = new BlockRedStringDispenser(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringFertilizer = new BlockRedStringFertilizer(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringComparator = new BlockRedStringComparator(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringRelay = new BlockRedStringRelay(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringInterceptor = new BlockRedStringInterceptor(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 corporeaIndex = new BlockCorporeaIndex(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533).method_22488());
	public static final class_2248 corporeaFunnel = new BlockCorporeaFunnel(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533));
	public static final class_2248 corporeaInterceptor = new BlockCorporeaInterceptor(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533));
	public static final class_2248 corporeaCrystalCube = new BlockCorporeaCrystalCube(class_4970.class_2251.method_9630(corporeaInterceptor));
	public static final class_2248 corporeaRetainer = new BlockCorporeaRetainer(class_4970.class_2251.method_9630(corporeaInterceptor));

	public static final class_2248 corporeaBlock = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(5.5F).method_9626(class_2498.field_11533));
	public static final class_2248 corporeaBrick = new BlockMod(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2510 corporeaStairs = new BlockModStairs(corporeaBlock.method_9564(), class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaBrickSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2510 corporeaBrickStairs = new BlockModStairs(corporeaBrick.method_9564(), class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2248 corporeaBrickWall = new class_2544(class_4970.class_2251.method_9630(corporeaBrick));

	public static final class_2248 incensePlate = new BlockIncensePlate(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 hourglass = new BlockHourglass(class_4970.class_2251.method_9637(class_3614.field_15953).method_9632(2).method_9626(class_2498.field_11533));
	public static final class_2248 ghostRail = new BlockGhostRail(class_4970.class_2251.method_9630(class_2246.field_10167));
	public static final class_2248 lightRelayDefault = new BlockLightRelay(LuminizerVariant.DEFAULT, class_4970.class_2251.method_9637(class_3614.field_15942).method_9634());
	public static final class_2248 lightRelayDetector = new BlockLightRelay(LuminizerVariant.DETECTOR, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayFork = new BlockLightRelay(LuminizerVariant.FORK, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayToggle = new BlockLightRelay(LuminizerVariant.TOGGLE, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightLauncher = new BlockLightLauncher(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 cacophonium = new BlockCacophonium(class_4970.class_2251.method_9637(class_3614.field_15932).method_9632(0.8F));
	public static final class_2248 cellBlock = new BlockCell(class_4970.class_2251.method_9637(class_3614.field_15954).method_9626(class_2498.field_11543));
	public static final class_2248 teruTeruBozu = new BlockTeruTeruBozu(class_4970.class_2251.method_9637(class_3614.field_15931));
	public static final class_2248 avatar = new BlockAvatar(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 fakeAir = new BlockFakeAir(class_4970.class_2251.method_9637(class_3614.field_15927).method_26250().method_9640());
	public static final class_2248 root = new BlockRoot(class_4970.class_2251.method_9637(class_3614.field_15935).method_9632(1.2F).method_9626(class_2498.field_11547));
	public static final class_2248 felPumpkin = new BlockFelPumpkin(class_4970.class_2251.method_9630(class_2246.field_10147));
	public static final class_2248 cocoon = new BlockCocoon(class_4970.class_2251.method_9637(class_3614.field_15931).method_9629(3, 60).method_9626(class_2498.field_11543));
	public static final class_2248 enchantedSoil = new BlockEnchantedSoil(class_4970.class_2251.method_9637(class_3614.field_15945).method_9632(0.6F).method_9626(class_2498.field_11535));
	public static final class_2248 animatedTorch = new BlockAnimatedTorch(class_4970.class_2251.method_9637(class_3614.field_15924).method_9631(s -> 7).method_22488());
	public static final class_2248 starfield = new BlockStarfield(class_4970.class_2251.method_9637(class_3614.field_15953).method_9629(5, 2000).method_9626(class_2498.field_11533));

	public static final class_2248 azulejo0 = new BlockMod(class_4970.class_2251.method_9637(class_3614.field_15914).method_9629(2, 5).method_9626(class_2498.field_11544));
	public static final class_2248 azulejo1 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo2 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo3 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo4 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo5 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo6 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo7 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo8 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo9 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo10 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo11 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo12 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo13 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo14 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo15 = new BlockMod(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 manaFlame = new BlockManaFlame(class_4970.class_2251.method_9637(class_3614.field_15924).method_9626(class_2498.field_11543).method_9631(s -> 15).method_9634());
	public static final class_2248 blazeBlock = new BlockMod(class_4970.class_2251.method_9630(manasteelBlock).method_9631(s -> 15));
	public static final class_2248 gaiaHeadWall = new BlockGaiaHeadWall(class_4970.class_2251.method_9637(class_3614.field_15924).method_9632(1));
	public static final class_2248 gaiaHead = new BlockGaiaHead(class_4970.class_2251.method_9637(class_3614.field_15924).method_9632(1));
	public static final class_2248 shimmerrock = new BlockMod(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 shimmerwoodPlanks = new BlockMod(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dryGrass = new BlockAltGrass(BlockAltGrass.Variant.DRY, FabricBlockSettings.copyOf(class_4970.class_2251.method_9637(class_3614.field_15945).method_9632(0.6F).method_9640().method_9626(class_2498.field_11535)).breakByTool(FabricToolTags.SHOVELS));
	public static final class_2248 goldenGrass = new BlockAltGrass(BlockAltGrass.Variant.GOLDEN, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 vividGrass = new BlockAltGrass(BlockAltGrass.Variant.VIVID, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 scorchedGrass = new BlockAltGrass(BlockAltGrass.Variant.SCORCHED, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 infusedGrass = new BlockAltGrass(BlockAltGrass.Variant.INFUSED, class_4970.class_2251.method_9630(dryGrass));
	public static final class_2248 mutatedGrass = new BlockAltGrass(BlockAltGrass.Variant.MUTATED, class_4970.class_2251.method_9630(dryGrass));

	public static final class_2248 motifDaybloom = new BlockMotifFlower(class_1294.field_5919, 15, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifNightshade = new BlockMotifFlower(class_1294.field_5899, 20, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifHydroangeas = new BlockMotifFlower(class_1294.field_5908, 10, class_4970.class_2251.method_9630(class_2246.field_10449), false);

	public static void registerBlocks() {
		class_2378<class_2248> r = class_2378.field_11146;
		register(r, "white" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, whiteFlower);
		register(r, "orange" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, orangeFlower);
		register(r, "magenta" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, magentaFlower);
		register(r, "light_blue" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, lightBlueFlower);
		register(r, "yellow" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, yellowFlower);
		register(r, "lime" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, limeFlower);
		register(r, "pink" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, pinkFlower);
		register(r, "gray" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, grayFlower);
		register(r, "light_gray" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, lightGrayFlower);
		register(r, "cyan" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, cyanFlower);
		register(r, "purple" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, purpleFlower);
		register(r, "blue" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, blueFlower);
		register(r, "brown" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, brownFlower);
		register(r, "green" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, greenFlower);
		register(r, "red" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, redFlower);
		register(r, "black" + LibBlockNames.MYSTICAL_FLOWER_SUFFIX, blackFlower);
		register(r, "white" + LibBlockNames.SHINY_FLOWER_SUFFIX, whiteShinyFlower);
		register(r, "orange" + LibBlockNames.SHINY_FLOWER_SUFFIX, orangeShinyFlower);
		register(r, "magenta" + LibBlockNames.SHINY_FLOWER_SUFFIX, magentaShinyFlower);
		register(r, "light_blue" + LibBlockNames.SHINY_FLOWER_SUFFIX, lightBlueShinyFlower);
		register(r, "yellow" + LibBlockNames.SHINY_FLOWER_SUFFIX, yellowShinyFlower);
		register(r, "lime" + LibBlockNames.SHINY_FLOWER_SUFFIX, limeShinyFlower);
		register(r, "pink" + LibBlockNames.SHINY_FLOWER_SUFFIX, pinkShinyFlower);
		register(r, "gray" + LibBlockNames.SHINY_FLOWER_SUFFIX, grayShinyFlower);
		register(r, "light_gray" + LibBlockNames.SHINY_FLOWER_SUFFIX, lightGrayShinyFlower);
		register(r, "cyan" + LibBlockNames.SHINY_FLOWER_SUFFIX, cyanShinyFlower);
		register(r, "purple" + LibBlockNames.SHINY_FLOWER_SUFFIX, purpleShinyFlower);
		register(r, "blue" + LibBlockNames.SHINY_FLOWER_SUFFIX, blueShinyFlower);
		register(r, "brown" + LibBlockNames.SHINY_FLOWER_SUFFIX, brownShinyFlower);
		register(r, "green" + LibBlockNames.SHINY_FLOWER_SUFFIX, greenShinyFlower);
		register(r, "red" + LibBlockNames.SHINY_FLOWER_SUFFIX, redShinyFlower);
		register(r, "black" + LibBlockNames.SHINY_FLOWER_SUFFIX, blackShinyFlower);
		register(r, "white" + LibBlockNames.BURIED_PETALS_SUFFIX, whiteBuriedPetals);
		register(r, "orange" + LibBlockNames.BURIED_PETALS_SUFFIX, orangeBuriedPetals);
		register(r, "magenta" + LibBlockNames.BURIED_PETALS_SUFFIX, magentaBuriedPetals);
		register(r, "light_blue" + LibBlockNames.BURIED_PETALS_SUFFIX, lightBlueBuriedPetals);
		register(r, "yellow" + LibBlockNames.BURIED_PETALS_SUFFIX, yellowBuriedPetals);
		register(r, "lime" + LibBlockNames.BURIED_PETALS_SUFFIX, limeBuriedPetals);
		register(r, "pink" + LibBlockNames.BURIED_PETALS_SUFFIX, pinkBuriedPetals);
		register(r, "gray" + LibBlockNames.BURIED_PETALS_SUFFIX, grayBuriedPetals);
		register(r, "light_gray" + LibBlockNames.BURIED_PETALS_SUFFIX, lightGrayBuriedPetals);
		register(r, "cyan" + LibBlockNames.BURIED_PETALS_SUFFIX, cyanBuriedPetals);
		register(r, "purple" + LibBlockNames.BURIED_PETALS_SUFFIX, purpleBuriedPetals);
		register(r, "blue" + LibBlockNames.BURIED_PETALS_SUFFIX, blueBuriedPetals);
		register(r, "brown" + LibBlockNames.BURIED_PETALS_SUFFIX, brownBuriedPetals);
		register(r, "green" + LibBlockNames.BURIED_PETALS_SUFFIX, greenBuriedPetals);
		register(r, "red" + LibBlockNames.BURIED_PETALS_SUFFIX, redBuriedPetals);
		register(r, "black" + LibBlockNames.BURIED_PETALS_SUFFIX, blackBuriedPetals);
		register(r, "white" + LibBlockNames.FLOATING_FLOWER_SUFFIX, whiteFloatingFlower);
		register(r, "orange" + LibBlockNames.FLOATING_FLOWER_SUFFIX, orangeFloatingFlower);
		register(r, "magenta" + LibBlockNames.FLOATING_FLOWER_SUFFIX, magentaFloatingFlower);
		register(r, "light_blue" + LibBlockNames.FLOATING_FLOWER_SUFFIX, lightBlueFloatingFlower);
		register(r, "yellow" + LibBlockNames.FLOATING_FLOWER_SUFFIX, yellowFloatingFlower);
		register(r, "lime" + LibBlockNames.FLOATING_FLOWER_SUFFIX, limeFloatingFlower);
		register(r, "pink" + LibBlockNames.FLOATING_FLOWER_SUFFIX, pinkFloatingFlower);
		register(r, "gray" + LibBlockNames.FLOATING_FLOWER_SUFFIX, grayFloatingFlower);
		register(r, "light_gray" + LibBlockNames.FLOATING_FLOWER_SUFFIX, lightGrayFloatingFlower);
		register(r, "cyan" + LibBlockNames.FLOATING_FLOWER_SUFFIX, cyanFloatingFlower);
		register(r, "purple" + LibBlockNames.FLOATING_FLOWER_SUFFIX, purpleFloatingFlower);
		register(r, "blue" + LibBlockNames.FLOATING_FLOWER_SUFFIX, blueFloatingFlower);
		register(r, "brown" + LibBlockNames.FLOATING_FLOWER_SUFFIX, brownFloatingFlower);
		register(r, "green" + LibBlockNames.FLOATING_FLOWER_SUFFIX, greenFloatingFlower);
		register(r, "red" + LibBlockNames.FLOATING_FLOWER_SUFFIX, redFloatingFlower);
		register(r, "black" + LibBlockNames.FLOATING_FLOWER_SUFFIX, blackFloatingFlower);
		register(r, "white" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockWhite);
		register(r, "orange" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockOrange);
		register(r, "magenta" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockMagenta);
		register(r, "light_blue" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockLightBlue);
		register(r, "yellow" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockYellow);
		register(r, "lime" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockLime);
		register(r, "pink" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockPink);
		register(r, "gray" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockGray);
		register(r, "light_gray" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockSilver);
		register(r, "cyan" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockCyan);
		register(r, "purple" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockPurple);
		register(r, "blue" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockBlue);
		register(r, "brown" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockBrown);
		register(r, "green" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockGreen);
		register(r, "red" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockRed);
		register(r, "black" + LibBlockNames.PETAL_BLOCK_SUFFIX, petalBlockBlack);
		register(r, "white" + LibBlockNames.MUSHROOM_SUFFIX, whiteMushroom);
		register(r, "orange" + LibBlockNames.MUSHROOM_SUFFIX, orangeMushroom);
		register(r, "magenta" + LibBlockNames.MUSHROOM_SUFFIX, magentaMushroom);
		register(r, "light_blue" + LibBlockNames.MUSHROOM_SUFFIX, lightBlueMushroom);
		register(r, "yellow" + LibBlockNames.MUSHROOM_SUFFIX, yellowMushroom);
		register(r, "lime" + LibBlockNames.MUSHROOM_SUFFIX, limeMushroom);
		register(r, "pink" + LibBlockNames.MUSHROOM_SUFFIX, pinkMushroom);
		register(r, "gray" + LibBlockNames.MUSHROOM_SUFFIX, grayMushroom);
		register(r, "light_gray" + LibBlockNames.MUSHROOM_SUFFIX, lightGrayMushroom);
		register(r, "cyan" + LibBlockNames.MUSHROOM_SUFFIX, cyanMushroom);
		register(r, "purple" + LibBlockNames.MUSHROOM_SUFFIX, purpleMushroom);
		register(r, "blue" + LibBlockNames.MUSHROOM_SUFFIX, blueMushroom);
		register(r, "brown" + LibBlockNames.MUSHROOM_SUFFIX, brownMushroom);
		register(r, "green" + LibBlockNames.MUSHROOM_SUFFIX, greenMushroom);
		register(r, "red" + LibBlockNames.MUSHROOM_SUFFIX, redMushroom);
		register(r, "black" + LibBlockNames.MUSHROOM_SUFFIX, blackMushroom);
		register(r, "white" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerWhite);
		register(r, "orange" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerOrange);
		register(r, "magenta" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerMagenta);
		register(r, "light_blue" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerLightBlue);
		register(r, "yellow" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerYellow);
		register(r, "lime" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerLime);
		register(r, "pink" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerPink);
		register(r, "gray" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerGray);
		register(r, "light_gray" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerLightGray);
		register(r, "cyan" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerCyan);
		register(r, "purple" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerPurple);
		register(r, "blue" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerBlue);
		register(r, "brown" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerBrown);
		register(r, "green" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerGreen);
		register(r, "red" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerRed);
		register(r, "black" + LibBlockNames.DOUBLE_FLOWER_SUFFIX, doubleFlowerBlack);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.DEFAULT.name().toLowerCase(Locale.ROOT), defaultAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.FOREST.name().toLowerCase(Locale.ROOT), forestAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.PLAINS.name().toLowerCase(Locale.ROOT), plainsAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.MOUNTAIN.name().toLowerCase(Locale.ROOT), mountainAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.FUNGAL.name().toLowerCase(Locale.ROOT), fungalAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.SWAMP.name().toLowerCase(Locale.ROOT), swampAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.DESERT.name().toLowerCase(Locale.ROOT), desertAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.TAIGA.name().toLowerCase(Locale.ROOT), taigaAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.MESA.name().toLowerCase(Locale.ROOT), mesaAltar);
		register(r, LibBlockNames.APOTHECARY_PREFIX + BlockAltar.Variant.MOSSY.name().toLowerCase(Locale.ROOT), mossyAltar);
		register(r, LibBlockNames.LIVING_ROCK, livingrock);
		register(r, LibBlockNames.LIVING_ROCK_BRICK, livingrockBrick);
		register(r, LibBlockNames.LIVING_ROCK_BRICK_CHISELED, livingrockBrickChiseled);
		register(r, LibBlockNames.LIVING_ROCK_BRICK_CRACKED, livingrockBrickCracked);
		register(r, LibBlockNames.LIVING_ROCK_BRICK_MOSSY, livingrockBrickMossy);
		register(r, LibBlockNames.LIVING_WOOD, livingwood);
		register(r, LibBlockNames.LIVING_WOOD_PLANKS, livingwoodPlanks);
		register(r, LibBlockNames.LIVING_WOOD_PLANKS_MOSSY, livingwoodPlanksMossy);
		register(r, LibBlockNames.LIVING_WOOD_FRAMED, livingwoodFramed);
		register(r, LibBlockNames.LIVING_WOOD_PATTERN_FRAMED, livingwoodPatternFramed);
		register(r, LibBlockNames.LIVING_WOOD_GLIMMERING, livingwoodGlimmering);
		register(r, LibBlockNames.DREAM_WOOD, dreamwood);
		register(r, LibBlockNames.DREAM_WOOD_PLANKS, dreamwoodPlanks);
		register(r, LibBlockNames.DREAM_WOOD_PLANKS_MOSSY, dreamwoodPlanksMossy);
		register(r, LibBlockNames.DREAM_WOOD_FRAMED, dreamwoodFramed);
		register(r, LibBlockNames.DREAM_WOOD_PATTERN_FRAMED, dreamwoodPatternFramed);
		register(r, LibBlockNames.DREAM_WOOD_GLIMMERING, dreamwoodGlimmering);
		register(r, LibBlockNames.SPREADER, manaSpreader);
		register(r, LibBlockNames.SPREADER_REDSTONE, redstoneSpreader);
		register(r, LibBlockNames.SPREADER_ELVEN, elvenSpreader);
		register(r, LibBlockNames.SPREADER_GAIA, gaiaSpreader);
		register(r, LibBlockNames.POOL, manaPool);
		register(r, LibBlockNames.POOL_CREATIVE, creativePool);
		register(r, LibBlockNames.POOL_DILUTED, dilutedPool);
		register(r, LibBlockNames.POOL_FABULOUS, fabulousPool);
		register(r, LibBlockNames.ALCHEMY_CATALYST, alchemyCatalyst);
		register(r, LibBlockNames.CONJURATION_CATALYST, conjurationCatalyst);
		register(r, LibBlockNames.MANASTEEL_BLOCK, manasteelBlock);
		register(r, LibBlockNames.TERRASTEEL_BLOCK, terrasteelBlock);
		register(r, LibBlockNames.ELEMENTIUM_BLOCK, elementiumBlock);
		register(r, LibBlockNames.MANA_DIAMOND_BLOCK, manaDiamondBlock);
		register(r, LibBlockNames.DRAGONSTONE_BLOCK, dragonstoneBlock);
		register(r, LibBlockNames.MANA_GLASS, manaGlass);
		register(r, LibBlockNames.ELF_GLASS, elfGlass);
		register(r, LibBlockNames.BIFROST, bifrost);
		register(r, LibBlockNames.BIFROST_PERM, bifrostPerm);
		register(r, LibBlockNames.RUNE_ALTAR, runeAltar);
		register(r, LibBlockNames.ENCHANTER, enchanter);
		register(r, LibBlockNames.BREWERY, brewery);
		register(r, LibBlockNames.TERRA_PLATE, terraPlate);
		register(r, LibBlockNames.ALF_PORTAL, alfPortal);
		register(r, LibBlockNames.PYLON, manaPylon);
		register(r, LibBlockNames.PYLON_NATURA, naturaPylon);
		register(r, LibBlockNames.PYLON_GAIA, gaiaPylon);
		register(r, LibBlockNames.DISTRIBUTOR, distributor);
		register(r, LibBlockNames.MANA_VOID, manaVoid);
		register(r, LibBlockNames.MANA_DETECTOR, manaDetector);
		register(r, LibBlockNames.PISTON_RELAY, pistonRelay);
		register(r, LibBlockNames.TURNTABLE, turntable);
		register(r, LibBlockNames.TINY_PLANET, tinyPlanet);
		register(r, LibBlockNames.DRUM_WILD, wildDrum);
		register(r, LibBlockNames.DRUM_GATHERING, gatheringDrum);
		register(r, LibBlockNames.DRUM_CANOPY, canopyDrum);
		register(r, LibBlockNames.SPAWNER_CLAW, spawnerClaw);
		register(r, LibBlockNames.FLUXFIELD, rfGenerator);
		register(r, LibBlockNames.PRISM, prism);
		register(r, LibBlockNames.PUMP, pump);
		register(r, LibBlockNames.SPARK_CHANGER, sparkChanger);
		register(r, LibBlockNames.MANA_BOMB, manaBomb);
		register(r, LibBlockNames.BELLOWS, bellows);
		register(r, LibBlockNames.OPEN_CRATE, openCrate);
		register(r, LibBlockNames.CRAFT_CRATE, craftCrate);
		register(r, LibBlockNames.FOREST_EYE, forestEye);
		register(r, LibBlockNames.SOLID_VINE, solidVines);
		register(r, LibBlockNames.PLATFORM_ABSTRUSE, abstrusePlatform);
		register(r, LibBlockNames.PLATFORM_SPECTRAL, spectralPlatform);
		register(r, LibBlockNames.PLATFORM_INFRANGIBLE, infrangiblePlatform);
		register(r, LibBlockNames.TINY_POTATO, tinyPotato);
		register(r, LibBlockNames.ENDER_EYE_BLOCK, enderEye);
		register(r, LibBlockNames.RED_STRING_CONTAINER, redStringContainer);
		register(r, LibBlockNames.RED_STRING_DISPENSER, redStringDispenser);
		register(r, LibBlockNames.RED_STRING_FERTILIZER, redStringFertilizer);
		register(r, LibBlockNames.RED_STRING_COMPARATOR, redStringComparator);
		register(r, LibBlockNames.RED_STRING_RELAY, redStringRelay);
		register(r, LibBlockNames.RED_STRING_INTERCEPTOR, redStringInterceptor);
		register(r, LibBlockNames.CORPOREA_INDEX, corporeaIndex);
		register(r, LibBlockNames.CORPOREA_FUNNEL, corporeaFunnel);
		register(r, LibBlockNames.CORPOREA_INTERCEPTOR, corporeaInterceptor);
		register(r, LibBlockNames.CORPOREA_CRYSTAL_CUBE, corporeaCrystalCube);
		register(r, LibBlockNames.CORPOREA_RETAINER, corporeaRetainer);
		register(r, LibBlockNames.CORPOREA_BLOCK, corporeaBlock);
		register(r, LibBlockNames.CORPOREA_SLAB, corporeaSlab);
		register(r, LibBlockNames.CORPOREA_STAIRS, corporeaStairs);
		register(r, LibBlockNames.CORPOREA_BRICK, corporeaBrick);
		register(r, LibBlockNames.CORPOREA_BRICK + LibBlockNames.SLAB_SUFFIX, corporeaBrickSlab);
		register(r, LibBlockNames.CORPOREA_BRICK + LibBlockNames.STAIR_SUFFIX, corporeaBrickStairs);
		register(r, LibBlockNames.CORPOREA_BRICK + LibBlockNames.WALL_SUFFIX, corporeaBrickWall);
		register(r, LibBlockNames.INCENSE_PLATE, incensePlate);
		register(r, LibBlockNames.HOURGLASS, hourglass);
		register(r, LibBlockNames.GHOST_RAIL, ghostRail);
		register(r, LibBlockNames.LIGHT_RELAY, lightRelayDefault);
		register(r, "detector" + LibBlockNames.LIGHT_RELAY_SUFFIX, lightRelayDetector);
		register(r, "fork" + LibBlockNames.LIGHT_RELAY_SUFFIX, lightRelayFork);
		register(r, "toggle" + LibBlockNames.LIGHT_RELAY_SUFFIX, lightRelayToggle);
		register(r, LibBlockNames.LIGHT_LAUNCHER, lightLauncher);
		register(r, LibBlockNames.CACOPHONIUM, cacophonium);
		register(r, LibBlockNames.CELL_BLOCK, cellBlock);
		register(r, LibBlockNames.TERU_TERU_BOZU, teruTeruBozu);
		register(r, LibBlockNames.AVATAR, avatar);
		register(r, LibBlockNames.FAKE_AIR, fakeAir);
		register(r, LibBlockNames.ROOT, root);
		register(r, LibBlockNames.FEL_PUMPKIN, felPumpkin);
		register(r, LibBlockNames.COCOON, cocoon);
		register(r, LibBlockNames.ENCHANTED_SOIL, enchantedSoil);
		register(r, LibBlockNames.ANIMATED_TORCH, animatedTorch);
		register(r, LibBlockNames.STARFIELD, starfield);
		register(r, LibBlockNames.AZULEJO_PREFIX + 0, azulejo0);
		register(r, LibBlockNames.AZULEJO_PREFIX + 1, azulejo1);
		register(r, LibBlockNames.AZULEJO_PREFIX + 2, azulejo2);
		register(r, LibBlockNames.AZULEJO_PREFIX + 3, azulejo3);
		register(r, LibBlockNames.AZULEJO_PREFIX + 4, azulejo4);
		register(r, LibBlockNames.AZULEJO_PREFIX + 5, azulejo5);
		register(r, LibBlockNames.AZULEJO_PREFIX + 6, azulejo6);
		register(r, LibBlockNames.AZULEJO_PREFIX + 7, azulejo7);
		register(r, LibBlockNames.AZULEJO_PREFIX + 8, azulejo8);
		register(r, LibBlockNames.AZULEJO_PREFIX + 9, azulejo9);
		register(r, LibBlockNames.AZULEJO_PREFIX + 10, azulejo10);
		register(r, LibBlockNames.AZULEJO_PREFIX + 11, azulejo11);
		register(r, LibBlockNames.AZULEJO_PREFIX + 12, azulejo12);
		register(r, LibBlockNames.AZULEJO_PREFIX + 13, azulejo13);
		register(r, LibBlockNames.AZULEJO_PREFIX + 14, azulejo14);
		register(r, LibBlockNames.AZULEJO_PREFIX + 15, azulejo15);
		register(r, LibBlockNames.MANA_FLAME, manaFlame);
		register(r, LibBlockNames.BLAZE_BLOCK, blazeBlock);
		register(r, LibBlockNames.GAIA_WALL_HEAD, gaiaHeadWall);
		register(r, LibBlockNames.GAIA_HEAD, gaiaHead);
		register(r, LibBlockNames.SHIMMERROCK, shimmerrock);
		register(r, LibBlockNames.SHIMMERWOOD_PLANKS, shimmerwoodPlanks);
		register(r, BlockAltGrass.Variant.DRY.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, dryGrass);
		register(r, BlockAltGrass.Variant.GOLDEN.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, goldenGrass);
		register(r, BlockAltGrass.Variant.VIVID.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, vividGrass);
		register(r, BlockAltGrass.Variant.SCORCHED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, scorchedGrass);
		register(r, BlockAltGrass.Variant.INFUSED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, infusedGrass);
		register(r, BlockAltGrass.Variant.MUTATED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX, mutatedGrass);
		register(r, LibBlockNames.MOTIF_DAYBLOOM, motifDaybloom);
		register(r, LibBlockNames.MOTIF_NIGHTSHADE, motifNightshade);
		register(r, LibBlockNames.MOTIF_HYDROANGEAS, motifHydroangeas);
	}

	public static void registerItemBlocks() {
		class_2378<class_1792> r = class_2378.field_11142;
		class_1792.class_1793 props = ModItems.defaultBuilder();
		register(r, class_2378.field_11146.method_10221(whiteFlower), new class_1747(whiteFlower, props));
		register(r, class_2378.field_11146.method_10221(orangeFlower), new class_1747(orangeFlower, props));
		register(r, class_2378.field_11146.method_10221(magentaFlower), new class_1747(magentaFlower, props));
		register(r, class_2378.field_11146.method_10221(lightBlueFlower), new class_1747(lightBlueFlower, props));
		register(r, class_2378.field_11146.method_10221(yellowFlower), new class_1747(yellowFlower, props));
		register(r, class_2378.field_11146.method_10221(limeFlower), new class_1747(limeFlower, props));
		register(r, class_2378.field_11146.method_10221(pinkFlower), new class_1747(pinkFlower, props));
		register(r, class_2378.field_11146.method_10221(grayFlower), new class_1747(grayFlower, props));
		register(r, class_2378.field_11146.method_10221(lightGrayFlower), new class_1747(lightGrayFlower, props));
		register(r, class_2378.field_11146.method_10221(cyanFlower), new class_1747(cyanFlower, props));
		register(r, class_2378.field_11146.method_10221(purpleFlower), new class_1747(purpleFlower, props));
		register(r, class_2378.field_11146.method_10221(blueFlower), new class_1747(blueFlower, props));
		register(r, class_2378.field_11146.method_10221(brownFlower), new class_1747(brownFlower, props));
		register(r, class_2378.field_11146.method_10221(greenFlower), new class_1747(greenFlower, props));
		register(r, class_2378.field_11146.method_10221(redFlower), new class_1747(redFlower, props));
		register(r, class_2378.field_11146.method_10221(blackFlower), new class_1747(blackFlower, props));
		register(r, class_2378.field_11146.method_10221(whiteShinyFlower), new class_1747(whiteShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(orangeShinyFlower), new class_1747(orangeShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(magentaShinyFlower), new class_1747(magentaShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(lightBlueShinyFlower), new class_1747(lightBlueShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(yellowShinyFlower), new class_1747(yellowShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(limeShinyFlower), new class_1747(limeShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(pinkShinyFlower), new class_1747(pinkShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(grayShinyFlower), new class_1747(grayShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(lightGrayShinyFlower), new class_1747(lightGrayShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(cyanShinyFlower), new class_1747(cyanShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(purpleShinyFlower), new class_1747(purpleShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(blueShinyFlower), new class_1747(blueShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(brownShinyFlower), new class_1747(brownShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(greenShinyFlower), new class_1747(greenShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(redShinyFlower), new class_1747(redShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(blackShinyFlower), new class_1747(blackShinyFlower, props));
		register(r, class_2378.field_11146.method_10221(whiteFloatingFlower), new class_1747(whiteFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(orangeFloatingFlower), new class_1747(orangeFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(magentaFloatingFlower), new class_1747(magentaFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(lightBlueFloatingFlower), new class_1747(lightBlueFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(yellowFloatingFlower), new class_1747(yellowFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(limeFloatingFlower), new class_1747(limeFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(pinkFloatingFlower), new class_1747(pinkFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(grayFloatingFlower), new class_1747(grayFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(lightGrayFloatingFlower), new class_1747(lightGrayFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(cyanFloatingFlower), new class_1747(cyanFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(purpleFloatingFlower), new class_1747(purpleFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(blueFloatingFlower), new class_1747(blueFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(brownFloatingFlower), new class_1747(brownFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(greenFloatingFlower), new class_1747(greenFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(redFloatingFlower), new class_1747(redFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(blackFloatingFlower), new class_1747(blackFloatingFlower, props));
		register(r, class_2378.field_11146.method_10221(petalBlockWhite), new class_1747(petalBlockWhite, props));
		register(r, class_2378.field_11146.method_10221(petalBlockOrange), new class_1747(petalBlockOrange, props));
		register(r, class_2378.field_11146.method_10221(petalBlockMagenta), new class_1747(petalBlockMagenta, props));
		register(r, class_2378.field_11146.method_10221(petalBlockLightBlue), new class_1747(petalBlockLightBlue, props));
		register(r, class_2378.field_11146.method_10221(petalBlockYellow), new class_1747(petalBlockYellow, props));
		register(r, class_2378.field_11146.method_10221(petalBlockLime), new class_1747(petalBlockLime, props));
		register(r, class_2378.field_11146.method_10221(petalBlockPink), new class_1747(petalBlockPink, props));
		register(r, class_2378.field_11146.method_10221(petalBlockGray), new class_1747(petalBlockGray, props));
		register(r, class_2378.field_11146.method_10221(petalBlockSilver), new class_1747(petalBlockSilver, props));
		register(r, class_2378.field_11146.method_10221(petalBlockCyan), new class_1747(petalBlockCyan, props));
		register(r, class_2378.field_11146.method_10221(petalBlockPurple), new class_1747(petalBlockPurple, props));
		register(r, class_2378.field_11146.method_10221(petalBlockBlue), new class_1747(petalBlockBlue, props));
		register(r, class_2378.field_11146.method_10221(petalBlockBrown), new class_1747(petalBlockBrown, props));
		register(r, class_2378.field_11146.method_10221(petalBlockGreen), new class_1747(petalBlockGreen, props));
		register(r, class_2378.field_11146.method_10221(petalBlockRed), new class_1747(petalBlockRed, props));
		register(r, class_2378.field_11146.method_10221(petalBlockBlack), new class_1747(petalBlockBlack, props));
		register(r, class_2378.field_11146.method_10221(whiteMushroom), new class_1747(whiteMushroom, props));
		register(r, class_2378.field_11146.method_10221(orangeMushroom), new class_1747(orangeMushroom, props));
		register(r, class_2378.field_11146.method_10221(magentaMushroom), new class_1747(magentaMushroom, props));
		register(r, class_2378.field_11146.method_10221(lightBlueMushroom), new class_1747(lightBlueMushroom, props));
		register(r, class_2378.field_11146.method_10221(yellowMushroom), new class_1747(yellowMushroom, props));
		register(r, class_2378.field_11146.method_10221(limeMushroom), new class_1747(limeMushroom, props));
		register(r, class_2378.field_11146.method_10221(pinkMushroom), new class_1747(pinkMushroom, props));
		register(r, class_2378.field_11146.method_10221(grayMushroom), new class_1747(grayMushroom, props));
		register(r, class_2378.field_11146.method_10221(lightGrayMushroom), new class_1747(lightGrayMushroom, props));
		register(r, class_2378.field_11146.method_10221(cyanMushroom), new class_1747(cyanMushroom, props));
		register(r, class_2378.field_11146.method_10221(purpleMushroom), new class_1747(purpleMushroom, props));
		register(r, class_2378.field_11146.method_10221(blueMushroom), new class_1747(blueMushroom, props));
		register(r, class_2378.field_11146.method_10221(brownMushroom), new class_1747(brownMushroom, props));
		register(r, class_2378.field_11146.method_10221(greenMushroom), new class_1747(greenMushroom, props));
		register(r, class_2378.field_11146.method_10221(redMushroom), new class_1747(redMushroom, props));
		register(r, class_2378.field_11146.method_10221(blackMushroom), new class_1747(blackMushroom, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerWhite), new class_1747(doubleFlowerWhite, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerOrange), new class_1747(doubleFlowerOrange, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerMagenta), new class_1747(doubleFlowerMagenta, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerLightBlue), new class_1747(doubleFlowerLightBlue, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerYellow), new class_1747(doubleFlowerYellow, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerLime), new class_1747(doubleFlowerLime, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerPink), new class_1747(doubleFlowerPink, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerGray), new class_1747(doubleFlowerGray, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerLightGray), new class_1747(doubleFlowerLightGray, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerCyan), new class_1747(doubleFlowerCyan, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerPurple), new class_1747(doubleFlowerPurple, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerBlue), new class_1747(doubleFlowerBlue, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerBrown), new class_1747(doubleFlowerBrown, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerGreen), new class_1747(doubleFlowerGreen, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerRed), new class_1747(doubleFlowerRed, props));
		register(r, class_2378.field_11146.method_10221(doubleFlowerBlack), new class_1747(doubleFlowerBlack, props));
		register(r, class_2378.field_11146.method_10221(defaultAltar), new class_1747(defaultAltar, props));
		register(r, class_2378.field_11146.method_10221(forestAltar), new class_1747(forestAltar, props));
		register(r, class_2378.field_11146.method_10221(plainsAltar), new class_1747(plainsAltar, props));
		register(r, class_2378.field_11146.method_10221(mountainAltar), new class_1747(mountainAltar, props));
		register(r, class_2378.field_11146.method_10221(fungalAltar), new class_1747(fungalAltar, props));
		register(r, class_2378.field_11146.method_10221(swampAltar), new class_1747(swampAltar, props));
		register(r, class_2378.field_11146.method_10221(desertAltar), new class_1747(desertAltar, props));
		register(r, class_2378.field_11146.method_10221(taigaAltar), new class_1747(taigaAltar, props));
		register(r, class_2378.field_11146.method_10221(mesaAltar), new class_1747(mesaAltar, props));
		register(r, class_2378.field_11146.method_10221(mossyAltar), new class_1747(mossyAltar, props));
		register(r, class_2378.field_11146.method_10221(livingrock), new class_1747(livingrock, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrick), new class_1747(livingrockBrick, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickChiseled), new class_1747(livingrockBrickChiseled, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickCracked), new class_1747(livingrockBrickCracked, props));
		register(r, class_2378.field_11146.method_10221(livingrockBrickMossy), new class_1747(livingrockBrickMossy, props));
		register(r, class_2378.field_11146.method_10221(livingwood), new class_1747(livingwood, props));
		register(r, class_2378.field_11146.method_10221(livingwoodPlanks), new class_1747(livingwoodPlanks, props));
		register(r, class_2378.field_11146.method_10221(livingwoodPlanksMossy), new class_1747(livingwoodPlanksMossy, props));
		register(r, class_2378.field_11146.method_10221(livingwoodFramed), new class_1747(livingwoodFramed, props));
		register(r, class_2378.field_11146.method_10221(livingwoodPatternFramed), new class_1747(livingwoodPatternFramed, props));
		register(r, class_2378.field_11146.method_10221(livingwoodGlimmering), new class_1747(livingwoodGlimmering, props));
		register(r, class_2378.field_11146.method_10221(dreamwood), new ItemBlockDreamwood(dreamwood, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodPlanks), new ItemBlockDreamwood(dreamwoodPlanks, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodPlanksMossy), new ItemBlockDreamwood(dreamwoodPlanksMossy, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodFramed), new ItemBlockDreamwood(dreamwoodFramed, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodPatternFramed), new ItemBlockDreamwood(dreamwoodPatternFramed, props));
		register(r, class_2378.field_11146.method_10221(dreamwoodGlimmering), new ItemBlockDreamwood(dreamwoodGlimmering, props));
		register(r, class_2378.field_11146.method_10221(manaSpreader), new class_1747(manaSpreader, props));
		register(r, class_2378.field_11146.method_10221(redstoneSpreader), new class_1747(redstoneSpreader, props));
		register(r, class_2378.field_11146.method_10221(elvenSpreader), new class_1747(elvenSpreader, props));
		register(r, class_2378.field_11146.method_10221(gaiaSpreader), new class_1747(gaiaSpreader, props));
		register(r, class_2378.field_11146.method_10221(manaPool), new ItemBlockPool(manaPool, props));
		register(r, class_2378.field_11146.method_10221(creativePool), new ItemBlockPool(creativePool, ModItems.defaultBuilder().method_7894(class_1814.field_8904)));
		register(r, class_2378.field_11146.method_10221(dilutedPool), new ItemBlockPool(dilutedPool, props));
		register(r, class_2378.field_11146.method_10221(fabulousPool), new ItemBlockPool(fabulousPool, props));
		register(r, class_2378.field_11146.method_10221(alchemyCatalyst), new class_1747(alchemyCatalyst, props));
		register(r, class_2378.field_11146.method_10221(conjurationCatalyst), new class_1747(conjurationCatalyst, props));
		register(r, class_2378.field_11146.method_10221(manasteelBlock), new class_1747(manasteelBlock, props));
		register(r, class_2378.field_11146.method_10221(terrasteelBlock), new class_1747(terrasteelBlock, ModItems.defaultBuilder().method_7894(class_1814.field_8907)));
		register(r, class_2378.field_11146.method_10221(elementiumBlock), new ItemBlockElven(elementiumBlock, props));
		register(r, class_2378.field_11146.method_10221(manaDiamondBlock), new class_1747(manaDiamondBlock, props));
		register(r, class_2378.field_11146.method_10221(dragonstoneBlock), new class_1747(dragonstoneBlock, props));
		register(r, class_2378.field_11146.method_10221(manaGlass), new class_1747(manaGlass, props));
		register(r, class_2378.field_11146.method_10221(elfGlass), new ItemBlockElven(elfGlass, props));
		register(r, class_2378.field_11146.method_10221(bifrostPerm), new class_1747(bifrostPerm, props));
		register(r, class_2378.field_11146.method_10221(runeAltar), new class_1747(runeAltar, props));
		register(r, class_2378.field_11146.method_10221(enchanter), new class_1747(enchanter, props));
		register(r, class_2378.field_11146.method_10221(brewery), new class_1747(brewery, props));
		register(r, class_2378.field_11146.method_10221(terraPlate), new class_1747(terraPlate, props));
		register(r, class_2378.field_11146.method_10221(alfPortal), new class_1747(alfPortal, ModItems.defaultBuilder().method_7894(class_1814.field_8907)));

		register(r, class_2378.field_11146.method_10221(manaPylon), new class_1747(manaPylon, props));
		register(r, class_2378.field_11146.method_10221(naturaPylon), new class_1747(naturaPylon, props));
		register(r, class_2378.field_11146.method_10221(gaiaPylon), new class_1747(gaiaPylon, props));
		register(r, class_2378.field_11146.method_10221(distributor), new class_1747(distributor, props));
		register(r, class_2378.field_11146.method_10221(manaVoid), new class_1747(manaVoid, props));
		register(r, class_2378.field_11146.method_10221(manaDetector), new class_1747(manaDetector, props));
		register(r, class_2378.field_11146.method_10221(pistonRelay), new class_1747(pistonRelay, props));
		register(r, class_2378.field_11146.method_10221(turntable), new class_1747(turntable, props));
		register(r, class_2378.field_11146.method_10221(tinyPlanet), new class_1747(tinyPlanet, props));
		register(r, class_2378.field_11146.method_10221(wildDrum), new class_1747(wildDrum, props));
		register(r, class_2378.field_11146.method_10221(gatheringDrum), new class_1747(gatheringDrum, props));
		register(r, class_2378.field_11146.method_10221(canopyDrum), new class_1747(canopyDrum, props));
		register(r, class_2378.field_11146.method_10221(spawnerClaw), new class_1747(spawnerClaw, props));
		register(r, class_2378.field_11146.method_10221(rfGenerator), new class_1747(rfGenerator, props));
		register(r, class_2378.field_11146.method_10221(prism), new class_1747(prism, props));
		register(r, class_2378.field_11146.method_10221(pump), new class_1747(pump, props));
		register(r, class_2378.field_11146.method_10221(sparkChanger), new class_1747(sparkChanger, props));
		register(r, class_2378.field_11146.method_10221(manaBomb), new class_1747(manaBomb, props));
		register(r, class_2378.field_11146.method_10221(bellows), new class_1747(bellows, props));
		register(r, class_2378.field_11146.method_10221(openCrate), new class_1747(openCrate, props));
		register(r, class_2378.field_11146.method_10221(craftCrate), new class_1747(craftCrate, props));
		register(r, class_2378.field_11146.method_10221(forestEye), new class_1747(forestEye, props));
		register(r, class_2378.field_11146.method_10221(abstrusePlatform), new class_1747(abstrusePlatform, props));
		register(r, class_2378.field_11146.method_10221(spectralPlatform), new class_1747(spectralPlatform, props));
		register(r, class_2378.field_11146.method_10221(infrangiblePlatform), new class_1747(infrangiblePlatform, ModItems.defaultBuilder().method_7894(class_1814.field_8904)));
		register(r, class_2378.field_11146.method_10221(tinyPotato), new ItemBlockTinyPotato(tinyPotato, ModItems.defaultBuilder().method_7894(class_1814.field_8907)));
		register(r, class_2378.field_11146.method_10221(enderEye), new class_1747(enderEye, props));
		register(r, class_2378.field_11146.method_10221(redStringContainer), new class_1747(redStringContainer, props));
		register(r, class_2378.field_11146.method_10221(redStringDispenser), new class_1747(redStringDispenser, props));
		register(r, class_2378.field_11146.method_10221(redStringFertilizer), new class_1747(redStringFertilizer, props));
		register(r, class_2378.field_11146.method_10221(redStringComparator), new class_1747(redStringComparator, props));
		register(r, class_2378.field_11146.method_10221(redStringRelay), new class_1747(redStringRelay, props));
		register(r, class_2378.field_11146.method_10221(redStringInterceptor), new class_1747(redStringInterceptor, props));
		register(r, class_2378.field_11146.method_10221(corporeaIndex), new class_1747(corporeaIndex, props));
		register(r, class_2378.field_11146.method_10221(corporeaFunnel), new class_1747(corporeaFunnel, props));
		register(r, class_2378.field_11146.method_10221(corporeaInterceptor), new class_1747(corporeaInterceptor, props));
		register(r, class_2378.field_11146.method_10221(corporeaCrystalCube), new class_1747(corporeaCrystalCube, props));
		register(r, class_2378.field_11146.method_10221(corporeaRetainer), new class_1747(corporeaRetainer, props));
		register(r, class_2378.field_11146.method_10221(corporeaBlock), new class_1747(corporeaBlock, props));
		register(r, class_2378.field_11146.method_10221(corporeaSlab), new class_1747(corporeaSlab, props));
		register(r, class_2378.field_11146.method_10221(corporeaStairs), new class_1747(corporeaStairs, props));
		register(r, class_2378.field_11146.method_10221(corporeaBrick), new class_1747(corporeaBrick, props));
		register(r, class_2378.field_11146.method_10221(corporeaBrickSlab), new class_1747(corporeaBrickSlab, props));
		register(r, class_2378.field_11146.method_10221(corporeaBrickStairs), new class_1747(corporeaBrickStairs, props));
		register(r, class_2378.field_11146.method_10221(corporeaBrickWall), new class_1747(corporeaBrickWall, props));
		register(r, class_2378.field_11146.method_10221(incensePlate), new class_1747(incensePlate, props));
		register(r, class_2378.field_11146.method_10221(hourglass), new class_1747(hourglass, props));
		register(r, class_2378.field_11146.method_10221(ghostRail), new class_1747(ghostRail, props));
		register(r, class_2378.field_11146.method_10221(lightRelayDefault), new class_1747(lightRelayDefault, props));
		register(r, class_2378.field_11146.method_10221(lightRelayDetector), new class_1747(lightRelayDetector, props));
		register(r, class_2378.field_11146.method_10221(lightRelayFork), new class_1747(lightRelayFork, props));
		register(r, class_2378.field_11146.method_10221(lightRelayToggle), new class_1747(lightRelayToggle, props));
		register(r, class_2378.field_11146.method_10221(lightLauncher), new class_1747(lightLauncher, props));
		register(r, class_2378.field_11146.method_10221(cacophonium), new class_1747(cacophonium, props));
		register(r, class_2378.field_11146.method_10221(cellBlock), new class_1747(cellBlock, props));
		register(r, class_2378.field_11146.method_10221(teruTeruBozu), new class_1747(teruTeruBozu, props));
		register(r, class_2378.field_11146.method_10221(avatar), new class_1747(avatar, props));
		register(r, class_2378.field_11146.method_10221(root), new class_1747(root, props));
		register(r, class_2378.field_11146.method_10221(felPumpkin), new class_1747(felPumpkin, props));
		register(r, class_2378.field_11146.method_10221(cocoon), new class_1747(cocoon, props));
		register(r, class_2378.field_11146.method_10221(enchantedSoil), new class_1747(enchantedSoil, ModItems.defaultBuilder().method_7894(class_1814.field_8903)));
		register(r, class_2378.field_11146.method_10221(animatedTorch), new class_1747(animatedTorch, props));
		register(r, class_2378.field_11146.method_10221(starfield), new class_1747(starfield, props));
		register(r, class_2378.field_11146.method_10221(azulejo0), new class_1747(azulejo0, props));
		register(r, class_2378.field_11146.method_10221(azulejo1), new class_1747(azulejo1, props));
		register(r, class_2378.field_11146.method_10221(azulejo2), new class_1747(azulejo2, props));
		register(r, class_2378.field_11146.method_10221(azulejo3), new class_1747(azulejo3, props));
		register(r, class_2378.field_11146.method_10221(azulejo4), new class_1747(azulejo4, props));
		register(r, class_2378.field_11146.method_10221(azulejo5), new class_1747(azulejo5, props));
		register(r, class_2378.field_11146.method_10221(azulejo6), new class_1747(azulejo6, props));
		register(r, class_2378.field_11146.method_10221(azulejo7), new class_1747(azulejo7, props));
		register(r, class_2378.field_11146.method_10221(azulejo8), new class_1747(azulejo8, props));
		register(r, class_2378.field_11146.method_10221(azulejo9), new class_1747(azulejo9, props));
		register(r, class_2378.field_11146.method_10221(azulejo10), new class_1747(azulejo10, props));
		register(r, class_2378.field_11146.method_10221(azulejo11), new class_1747(azulejo11, props));
		register(r, class_2378.field_11146.method_10221(azulejo12), new class_1747(azulejo12, props));
		register(r, class_2378.field_11146.method_10221(azulejo13), new class_1747(azulejo13, props));
		register(r, class_2378.field_11146.method_10221(azulejo14), new class_1747(azulejo14, props));
		register(r, class_2378.field_11146.method_10221(azulejo15), new class_1747(azulejo15, props));
		class_1792 blazeBlockItem = new ItemBlockBlaze(blazeBlock, props);
		register(r, class_2378.field_11146.method_10221(blazeBlock), blazeBlockItem);
		int blazeTime = 2400;
		FuelRegistry.INSTANCE.add(blazeBlockItem, blazeTime * (Botania.gardenOfGlassLoaded ? 5 : 10));
		register(r, class_2378.field_11146.method_10221(gaiaHead), new class_1827(gaiaHead, gaiaHeadWall, ModItems.defaultBuilder().method_7894(class_1814.field_8907)));
		register(r, class_2378.field_11146.method_10221(shimmerrock), new class_1747(shimmerrock, props));
		register(r, class_2378.field_11146.method_10221(shimmerwoodPlanks), new class_1747(shimmerwoodPlanks, props));
		register(r, class_2378.field_11146.method_10221(dryGrass), new class_1747(dryGrass, props));
		register(r, class_2378.field_11146.method_10221(goldenGrass), new class_1747(goldenGrass, props));
		register(r, class_2378.field_11146.method_10221(vividGrass), new class_1747(vividGrass, props));
		register(r, class_2378.field_11146.method_10221(scorchedGrass), new class_1747(scorchedGrass, props));
		register(r, class_2378.field_11146.method_10221(infusedGrass), new class_1747(infusedGrass, props));
		register(r, class_2378.field_11146.method_10221(mutatedGrass), new class_1747(mutatedGrass, props));
		register(r, class_2378.field_11146.method_10221(motifDaybloom), new class_1747(motifDaybloom, props));
		register(r, class_2378.field_11146.method_10221(motifNightshade), new class_1747(motifNightshade, props));
		register(r, class_2378.field_11146.method_10221(motifHydroangeas), new class_1747(motifHydroangeas, props));
	}

	public static <T> void register(class_2378<? super T> reg, class_2960 name, T thing) {
		class_2378.method_10230(reg, name, thing);
	}

	public static <T> void register(class_2378<? super T> reg, String name, T thing) {
		register(reg, prefix(name), thing);
	}

	public static void addDispenserBehaviours() {
		class_2315.method_10009(ModItems.twigWand, new BehaviourWand());
		class_2315.method_10009(ModItems.obedienceStick, new BehaviourStick());
		class_2315.method_10009(ModItems.poolMinecart, new BehaviourPoolMinecart());
		class_2315.method_10009(ModBlocks.felPumpkin, new BehaviourFelPumpkin());
		class_2315.method_10009(ModItems.spark, new BehaviourSpark());
		class_2315.method_10009(ModBlocks.gaiaHead, new class_2969() {
			@Nonnull
			@Override
			protected class_1799 method_10135(@Nonnull class_2342 source, @Nonnull class_1799 stack) {
				method_27955(class_1738.method_7684(source, stack));
				return stack;
			}
		});

		class_2357 behavior = new BehaviourCorporeaSpark();
		class_2315.method_10009(ModItems.corporeaSpark, behavior);
		class_2315.method_10009(ModItems.corporeaSparkMaster, behavior);
		class_2315.method_10009(ModItems.enderAirBottle, new class_2965() {
			@Nonnull
			@Override
			protected class_1676 method_12844(@Nonnull class_1937 world, @Nonnull class_2374 pos, @Nonnull class_1799 stack) {
				return new EntityEnderAirBottle(pos.method_10216(), pos.method_10214(), pos.method_10215(), world);
			}
		});

		behavior = AccessorDispenserBlock.getDispenseBehaviorRegistry().get(class_1802.field_8469);
		class_2315.method_10009(class_1802.field_8469, new BehaviourEnderAirBottling(behavior));

		SeedBehaviours.init();
	}

	public static class_2248 getFlower(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whiteFlower;
		case field_7946:
			return orangeFlower;
		case field_7958:
			return magentaFlower;
		case field_7951:
			return lightBlueFlower;
		case field_7947:
			return yellowFlower;
		case field_7961:
			return limeFlower;
		case field_7954:
			return pinkFlower;
		case field_7944:
			return grayFlower;
		case field_7967:
			return lightGrayFlower;
		case field_7955:
			return cyanFlower;
		case field_7945:
			return purpleFlower;
		case field_7966:
			return blueFlower;
		case field_7957:
			return brownFlower;
		case field_7942:
			return greenFlower;
		case field_7964:
			return redFlower;
		case field_7963:
			return blackFlower;
		}
	}

	public static class_2248 getMushroom(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whiteMushroom;
		case field_7946:
			return orangeMushroom;
		case field_7958:
			return magentaMushroom;
		case field_7951:
			return lightBlueMushroom;
		case field_7947:
			return yellowMushroom;
		case field_7961:
			return limeMushroom;
		case field_7954:
			return pinkMushroom;
		case field_7944:
			return grayMushroom;
		case field_7967:
			return lightGrayMushroom;
		case field_7955:
			return cyanMushroom;
		case field_7945:
			return purpleMushroom;
		case field_7966:
			return blueMushroom;
		case field_7957:
			return brownMushroom;
		case field_7942:
			return greenMushroom;
		case field_7964:
			return redMushroom;
		case field_7963:
			return blackMushroom;
		}
	}

	public static class_2248 getBuriedPetal(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whiteBuriedPetals;
		case field_7946:
			return orangeBuriedPetals;
		case field_7958:
			return magentaBuriedPetals;
		case field_7951:
			return lightBlueBuriedPetals;
		case field_7947:
			return yellowBuriedPetals;
		case field_7961:
			return limeBuriedPetals;
		case field_7954:
			return pinkBuriedPetals;
		case field_7944:
			return grayBuriedPetals;
		case field_7967:
			return lightGrayBuriedPetals;
		case field_7955:
			return cyanBuriedPetals;
		case field_7945:
			return purpleBuriedPetals;
		case field_7966:
			return blueBuriedPetals;
		case field_7957:
			return brownBuriedPetals;
		case field_7942:
			return greenBuriedPetals;
		case field_7964:
			return redBuriedPetals;
		case field_7963:
			return blackBuriedPetals;
		}
	}

	public static class_2248 getShinyFlower(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whiteShinyFlower;
		case field_7946:
			return orangeShinyFlower;
		case field_7958:
			return magentaShinyFlower;
		case field_7951:
			return lightBlueShinyFlower;
		case field_7947:
			return yellowShinyFlower;
		case field_7961:
			return limeShinyFlower;
		case field_7954:
			return pinkShinyFlower;
		case field_7944:
			return grayShinyFlower;
		case field_7967:
			return lightGrayShinyFlower;
		case field_7955:
			return cyanShinyFlower;
		case field_7945:
			return purpleShinyFlower;
		case field_7966:
			return blueShinyFlower;
		case field_7957:
			return brownShinyFlower;
		case field_7942:
			return greenShinyFlower;
		case field_7964:
			return redShinyFlower;
		case field_7963:
			return blackShinyFlower;
		}
	}

	public static class_2248 getFloatingFlower(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return whiteFloatingFlower;
		case field_7946:
			return orangeFloatingFlower;
		case field_7958:
			return magentaFloatingFlower;
		case field_7951:
			return lightBlueFloatingFlower;
		case field_7947:
			return yellowFloatingFlower;
		case field_7961:
			return limeFloatingFlower;
		case field_7954:
			return pinkFloatingFlower;
		case field_7944:
			return grayFloatingFlower;
		case field_7967:
			return lightGrayFloatingFlower;
		case field_7955:
			return cyanFloatingFlower;
		case field_7945:
			return purpleFloatingFlower;
		case field_7966:
			return blueFloatingFlower;
		case field_7957:
			return brownFloatingFlower;
		case field_7942:
			return greenFloatingFlower;
		case field_7964:
			return redFloatingFlower;
		case field_7963:
			return blackFloatingFlower;
		}
	}

	public static class_2248 getDoubleFlower(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return doubleFlowerWhite;
		case field_7946:
			return doubleFlowerOrange;
		case field_7958:
			return doubleFlowerMagenta;
		case field_7951:
			return doubleFlowerLightBlue;
		case field_7947:
			return doubleFlowerYellow;
		case field_7961:
			return doubleFlowerLime;
		case field_7954:
			return doubleFlowerPink;
		case field_7944:
			return doubleFlowerGray;
		case field_7967:
			return doubleFlowerLightGray;
		case field_7955:
			return doubleFlowerCyan;
		case field_7945:
			return doubleFlowerPurple;
		case field_7966:
			return doubleFlowerBlue;
		case field_7957:
			return doubleFlowerBrown;
		case field_7942:
			return doubleFlowerGreen;
		case field_7964:
			return doubleFlowerRed;
		case field_7963:
			return doubleFlowerBlack;
		}
	}

	public static class_2248 getPetalBlock(class_1767 color) {
		switch (color) {
		default:
		case field_7952:
			return petalBlockWhite;
		case field_7946:
			return petalBlockOrange;
		case field_7958:
			return petalBlockMagenta;
		case field_7951:
			return petalBlockLightBlue;
		case field_7947:
			return petalBlockYellow;
		case field_7961:
			return petalBlockLime;
		case field_7954:
			return petalBlockPink;
		case field_7944:
			return petalBlockGray;
		case field_7967:
			return petalBlockSilver;
		case field_7955:
			return petalBlockCyan;
		case field_7945:
			return petalBlockPurple;
		case field_7966:
			return petalBlockBlue;
		case field_7957:
			return petalBlockBrown;
		case field_7942:
			return petalBlockGreen;
		case field_7964:
			return petalBlockRed;
		case field_7963:
			return petalBlockBlack;
		}
	}
}
