/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1802;
import net.minecraft.class_1935;
import vazkii.botania.common.item.ModItems;

public final class ModBanners {

	// public static final Map<IRegistryDelegate<Item>, BannerPattern> PATTERNS = new LinkedHashMap<>();

	public static void init() {
		addPattern("flower", "flr", ModItems.livingwoodTwig);
		addPattern("lexicon", "lex", ModItems.lexicon);
		addPattern("logo", "lgo", ModItems.terrasteel);
		addPattern("sapling", "spl", ModItems.dreamwoodTwig);
		addPattern("tiny_potato", "tpt", ModBlocks.tinyPotato);

		addPattern("spark_dispersive", "sds", ModItems.sparkUpgradeDispersive);
		addPattern("spark_dominant", "sdm", ModItems.sparkUpgradeDominant);
		addPattern("spark_recessive", "src", ModItems.sparkUpgradeRecessive);
		addPattern("spark_isolated", "sis", ModItems.sparkUpgradeIsolated);

		addPattern("fish", "fis", class_1802.field_8429);
		addPattern("axe", "axe", class_1802.field_8475);
		addPattern("hoe", "hoe", class_1802.field_8609);
		addPattern("pickaxe", "pik", class_1802.field_8403);
		addPattern("shovel", "shv", class_1802.field_8699);
		addPattern("sword", "srd", class_1802.field_8371);
	}

	private static void addPattern(String name, String id, class_1935 craftingItem) {
		name = "botania_" + name;
		id = "bt_" + id;
		/* todo 1.16-fabric
		BannerPattern pattern = BannerPattern.create(name.toUpperCase(Locale.ROOT), name, id, false);
		PATTERNS.put(craftingItem.asItem().delegate, pattern);
		*/
	}
}
