/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.tile.TileTeruTeruBozu;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockTeruTeruBozu extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(4, 0.16, 4, 12, 15.84, 12);

	public BlockTeruTeruBozu(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 e) {
		if (!world.field_9236 && e instanceof class_1542) {
			class_1542 item = (class_1542) e;
			class_1799 stack = item.method_6983();
			if (isSunflower(stack) && removeRain(world) || isBlueOrchid(stack) && startRain(world)) {
				stack.method_7934(1);
			}
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && (isSunflower(stack) && removeRain(world) || isBlueOrchid(stack) && startRain(world))) {
			if (!player.field_7503.field_7477) {
				stack.method_7934(1);
			}
			return class_1269.field_5812;
		}
		return class_1269.field_5811;
	}

	private boolean isSunflower(class_1799 stack) {
		return stack.method_7909() == class_2246.field_10583.method_8389();
	}

	private boolean isBlueOrchid(class_1799 stack) {
		return stack.method_7909() == class_2246.field_10086.method_8389();
	}

	private boolean removeRain(class_1937 world) {
		if (world.method_8419()) {
			world.method_8401().method_157(false);
			TileTeruTeruBozu.resetRainTime(world);
			return true;
		}
		return false;
	}

	private boolean startRain(class_1937 world) {
		if (!world.method_8419()) {
			if (world.field_9229.nextInt(10) == 0) {
				world.method_8401().method_157(true);
				TileTeruTeruBozu.resetRainTime(world);
			}
			return true;
		}
		return false;
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return world.method_8419() ? 15 : 0;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileTeruTeruBozu();
	}

}
