/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.function.Supplier;

public class BlockSpecialFlower extends class_2356 implements class_2343, IWandable, IWandHUD {
	private static final class_265 SHAPE = method_9541(4.8, 0, 4.8, 12.8, 16, 12.8);
	private final Supplier<? extends TileEntitySpecialFlower> teProvider;

	protected BlockSpecialFlower(class_1291 stewEffect, int stewDuration, class_2251 props, Supplier<? extends TileEntitySpecialFlower> teProvider) {
		super(stewEffect, stewDuration, props);
		this.teProvider = teProvider;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, @Nonnull class_1922 world, @Nonnull class_2338 pos, class_3726 ctx) {
		class_243 shift = state.method_26226(world, pos);
		return field_11085.method_1096(shift.field_1352, shift.field_1351, shift.field_1350);
	}

	@Override
	protected boolean method_9695(class_2680 state, class_1922 worldIn, class_2338 pos) {
		return state.method_26204() == ModBlocks.redStringRelay
				|| state.method_26204() == class_2246.field_10402
				|| super.method_9695(state, worldIn, pos);
	}

	@Override
	public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int event, int param) {
		super.method_9592(state, world, pos, event, param);
		class_2586 tileentity = world.method_8321(pos);
		return tileentity != null && tileentity.method_11004(event, param);
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return teProvider.get();
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		return ((TileEntitySpecialFlower) world.method_8321(pos)).onWanded(player, stack);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
		((TileEntitySpecialFlower) world.method_8321(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileEntitySpecialFlower) world.method_8321(pos)).renderHUD(ms, mc);
	}
}
