/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.TileSparkChanger;
import vazkii.botania.common.item.ItemSparkUpgrade;

import javax.annotation.Nonnull;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockSparkChanger extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 3, 16);

	public BlockSparkChanger(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, true));
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_8482(pos) > 0 || world.method_8482(pos.method_10084()) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			((TileSparkChanger) world.method_8321(pos)).doSwap();
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), 4);
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), 4);
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileSparkChanger changer = (TileSparkChanger) world.method_8321(pos);
		class_1799 pstack = player.method_5998(hand);
		class_1799 cstack = changer.getItemHandler().method_5438(0);
		if (!cstack.method_7960()) {
			changer.getItemHandler().method_5447(0, class_1799.field_8037);
			player.field_7514.method_7398(player.field_6002, cstack);
			return class_1269.field_5812;
		} else if (!pstack.method_7960() && pstack.method_7909() instanceof ItemSparkUpgrade) {
			changer.getItemHandler().method_5447(0, pstack.method_7971(1));
			changer.method_5431();

			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TileSparkChanger changer = (TileSparkChanger) world.method_8321(pos);
		class_1799 stack = changer.getItemHandler().method_5438(0);
		if (!stack.method_7960() && stack.method_7909() instanceof ItemSparkUpgrade) {
			return ((ItemSparkUpgrade) stack.method_7909()).type.ordinal() + 1;
		}
		return 0;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileSparkChanger();
	}

}
