/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.tile.TilePylon;

import javax.annotation.Nonnull;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;

public class BlockPylon extends BlockModWaterloggable implements class_2343 {
	private static final class_265 SHAPE = class_2248.method_9541(2, 0, 2, 14, 21, 14);

	public enum Variant {
		MANA(8f, 0.5f, 0.5f, 1f, ModBlocks.enchanter),
		NATURA(15f, 0.5f, 1f, 0.5f, ModBlocks.alfPortal),
		GAIA(15f, 1f, 0.5f, 1f, ModBlocks.alfPortal);

		public final float enchantPowerBonus;
		public final float r, g, b;
		public final class_2248 targetBlock;

		private Variant(float epb, float r, float g, float b, class_2248 tb) {
			enchantPowerBonus = epb;
			this.r = r;
			this.g = g;
			this.b = b;
			targetBlock = tb;
		}
	}

	public final Variant variant;

	public BlockPylon(@Nonnull Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	/* todo 1.16-fabric
	@Override
	public float getEnchantPowerBonus(BlockState state, WorldView world, BlockPos pos) {
		return variant.enchantPowerBonus;
	}
	*/

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TilePylon();
	}

}
