/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2667;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2764;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.lens.LensPiston;
import vazkii.botania.common.network.PacketBotaniaEffect;

import javax.annotation.Nonnull;

import java.util.*;

public class BlockPistonRelay extends BlockMod implements IWandable {

	// Currently active binding attempts
	public final Map<UUID, class_4208> activeBindingAttempts = new HashMap<>();

	private final Set<class_4208> removeQueue = new HashSet<>();
	private final Set<class_4208> checkedCoords = new HashSet<>();
	private final Map<class_4208, Integer> coordsToCheck = new HashMap<>();

	public BlockPistonRelay(class_2251 builder) {
		super(builder);
		ServerTickEvents.END_SERVER_TICK.register(this::tickEnd);
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (!world.field_9236) {
			mapCoords(world.method_27983(), pos, 2);
		}
	}

	private void mapCoords(class_5321<class_1937> type, class_2338 pos, int time) {
		coordsToCheck.put(class_4208.method_19443(type, pos), time);
	}

	private void decrCoords(class_4208 key) {
		int time = getTimeInCoords(key);

		if (time <= 0) {
			removeQueue.add(key);
		} else {
			coordsToCheck.merge(key, -1, Integer::sum);
		}
	}

	private int getTimeInCoords(class_4208 key) {
		return coordsToCheck.getOrDefault(key, 0);
	}

	private class_2586 getTeAt(class_4208 key) {
		Object game = FabricLoader.getInstance().getGameInstance();
		if (game instanceof MinecraftServer) {
			MinecraftServer server = (MinecraftServer) game;
			class_1937 world = server.method_3847(key.method_19442());
			if (world != null) {
				return world.method_8321(key.method_19446());
			}
		}
		return null;
	}

	private class_2680 getStateAt(class_4208 key) {
		Object game = FabricLoader.getInstance().getGameInstance();
		if (game instanceof MinecraftServer) {
			MinecraftServer server = (MinecraftServer) game;
			class_1937 world = server.method_3847(key.method_19442());
			if (world != null) {
				return world.method_8320(key.method_19446());
			}
		}
		return class_2246.field_10124.method_9564();
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		if (world.field_9236) {
			return false;
		}

		if (player == null || player.method_5715()) {
			method_9577(world, pos, new class_1799(this));
			world.method_22352(pos, false);
		} else {
			class_4208 clicked = class_4208.method_19443(world.method_27983(), pos.method_10062());
			if (ItemTwigWand.getBindMode(stack)) {
				activeBindingAttempts.put(player.method_5667(), clicked);
				world.method_8396(null, pos, ModSounds.ding, class_3419.field_15245, 0.5F, 1F);
			} else {
				class_2338 dest = WorldData.get(world).mapping.get(pos);
				if (dest != null) {
					PacketBotaniaEffect.sendNearby(world, pos, PacketBotaniaEffect.EffectType.PARTICLE_BEAM,
							pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5,
							dest.method_10263(), dest.method_10264(), dest.method_10260());
				}
			}
		}

		return true;
	}

	public static class WorldData extends class_18 {

		private static final String ID = "PistonRelayPairs";
		public final Map<class_2338, class_2338> mapping = new HashMap<>();

		public WorldData() {
			super(ID);
		}

		@Override
		public void method_77(@Nonnull class_2487 cmp) {
			mapping.clear();

			class_2499 list = cmp.method_10554("list", 11);
			for (int i = 0; i < list.size(); i += 2) {
				class_2520 from = list.method_10534(i);
				class_2520 to = list.method_10534(i + 1);
				class_2338 fromPos = class_2338.field_25064.decode(class_2509.field_11560, from).result().get().getFirst();
				class_2338 toPos = class_2338.field_25064.decode(class_2509.field_11560, to).result().get().getFirst();

				mapping.put(fromPos, toPos);
			}
		}

		@Nonnull
		@Override
		public class_2487 method_75(@Nonnull class_2487 cmp) {
			class_2499 list = new class_2499();
			for (Map.Entry<class_2338, class_2338> e : mapping.entrySet()) {
				class_2520 from = class_2338.field_25064.encodeStart(class_2509.field_11560, e.getKey()).result().get();
				class_2520 to = class_2338.field_25064.encodeStart(class_2509.field_11560, e.getValue()).result().get();
				list.add(from);
				list.add(to);
			}
			cmp.method_10566("list", list);
			return cmp;
		}

		public static WorldData get(class_1937 world) {
			WorldData data = ((class_3218) world).method_17983().method_20786(WorldData::new, ID);
			if (data == null) {
				data = new WorldData();
				data.method_80();
				((class_3218) world).method_17983().method_123(data);
			}
			return data;
		}
	}

	public void tickEnd(MinecraftServer server) {
		for (class_4208 s : coordsToCheck.keySet()) {
			class_3218 world = server.method_3847(s.method_19442());
			WorldData data = WorldData.get(world);

			decrCoords(s);
			if (checkedCoords.contains(s)) {
				continue;
			}

			class_2680 state = getStateAt(s);
			if (state.method_26204() == class_2246.field_10008) {
				boolean sticky = class_2764.field_12634 == state.method_11654(class_2667.field_12197);
				class_2350 dir = ((class_2669) getTeAt(s)).method_11506();

				if (getTimeInCoords(s) == 0) {
					class_2338 newPos;

					// Put the relay back, or drop it
					{
						int x = s.method_19446().method_10263(), y = s.method_19446().method_10264(), z = s.method_19446().method_10260();
						class_2338 pos = s.method_19446();
						if (world.method_22347(pos.method_10093(dir))) {
							world.method_8501(pos.method_10093(dir), ModBlocks.pistonRelay.method_9564());
						} else {
							class_1799 stack = new class_1799(ModBlocks.pistonRelay);
							world.method_8649(new class_1542(world, x + dir.method_10148(), y + dir.method_10164(), z + dir.method_10165(), stack));
						}
						checkedCoords.add(s);
						newPos = pos.method_10093(dir);
					}

					// Move the linked block and update the mapping
					if (data.mapping.containsKey(s.method_19446())) {
						class_2338 destPos = data.mapping.get(s.method_19446());

						class_2680 srcState = world.method_8320(destPos);
						class_2586 tile = world.method_8321(destPos);

						if (!sticky && tile == null && srcState.method_26223() == class_3619.field_15974 && srcState.method_26214(world, destPos) != -1 && !srcState.method_26215()) {
							class_3614 destMat = world.method_8320(destPos.method_10093(dir)).method_26207();
							if (world.method_22347(destPos.method_10093(dir)) || destMat.method_15800()) {
								world.method_8501(destPos, class_2246.field_10124.method_9564());
								world.method_8501(destPos.method_10093(dir), LensPiston.unWaterlog(srcState));
								data.mapping.put(s.method_19446(), destPos.method_10093(dir));
							}
						}

						destPos = data.mapping.get(s.method_19446());
						data.mapping.remove(s.method_19446());
						data.mapping.put(newPos, destPos);
						data.method_80();
					}
				}
			}
		}

		coordsToCheck.keySet().removeAll(removeQueue);
		checkedCoords.removeAll(removeQueue);
		removeQueue.clear();
	}
}
