/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.*;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ColorHelper;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockModFlower extends class_2356 implements class_2256 {
	public final class_1767 color;

	protected BlockModFlower(class_1767 color, class_2251 builder) {
		super(effectForFlower(color), 4, builder);
		this.color = color;
	}

	private static class_1291 effectForFlower(class_1767 color) {
		switch (color) {
		case field_7952:
			return class_1294.field_5904;
		case field_7946:
			return class_1294.field_5918;
		case field_7958:
			return class_1294.field_5901;
		case field_7951:
			return class_1294.field_5913;
		case field_7947:
			return class_1294.field_5898;
		case field_7961:
			return class_1294.field_5899;
		case field_7954:
			return class_1294.field_5924;
		case field_7944:
			return class_1294.field_5907;
		case field_7967:
			return class_1294.field_5911;
		case field_7955:
			return class_1294.field_5923;
		case field_7945:
			return class_1294.field_5916;
		case field_7966:
			return class_1294.field_5925;
		case field_7957:
			return class_1294.field_5920;
		case field_7942:
			return class_1294.field_5903;
		case field_7964:
			return class_1294.field_5910;
		case field_7963:
			return class_1294.field_5919;
		}
		return class_1294.field_5924;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {
		int hex = ColorHelper.getColorValue(this.color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;
		class_243 offset = state.method_26226(world, pos);
		double x = pos.method_10263() + offset.field_1352;
		double y = pos.method_10264() + offset.field_1351;
		double z = pos.method_10260() + offset.field_1350;

		if (rand.nextDouble() < ConfigHandler.CLIENT.flowerParticleFrequency.getValue()) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, x + 0.3 + rand.nextFloat() * 0.5, y + 0.5 + rand.nextFloat() * 0.5, z + 0.3 + rand.nextFloat() * 0.5, 0, 0, 0);
		}
	}

	@Override
	public boolean method_9651(@Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_2680 state, boolean fuckifiknow) {
		return world.method_8320(pos.method_10084()).method_26215();
	}

	@Override
	public boolean method_9650(@Nonnull class_1937 world, @Nonnull Random rand, @Nonnull class_2338 pos, @Nonnull class_2680 state) {
		return method_9651(world, pos, state, false);
	}

	@Override
	public void method_9652(@Nonnull class_3218 world, @Nonnull Random rand, @Nonnull class_2338 pos, @Nonnull class_2680 state) {
		class_2248 block = ModBlocks.getDoubleFlower(color);
		if (block instanceof class_2320) {
			((class_2320) block).method_10021(world, pos, 3);
		}
	}
}
