/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ColorHelper;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockModDoubleFlower extends class_2521 {
	private final class_1767 color;

	public BlockModDoubleFlower(class_1767 color, class_2251 builder) {
		super(builder);
		this.color = color;
	}

	// Normally, when an upper block is broken, the lower block recognizes the plant is no longer whole and automatically breaks itself.
	// But since we require shears, this is needed to pass the breaking context (tool, etc.) to the lower block.
	@Override
	public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
		if (state.method_11654(field_10929) == class_2756.field_12609) {
			class_2680 lower = world.method_8320(pos.method_10074());
			if (lower.method_26204() == this && lower.method_11654(field_10929) == class_2756.field_12607) {
				lower.method_26204().method_9576(world, pos.method_10074(), lower, player);
			}
		}
		super.method_9576(world, pos, state, player);
	}

	@Override
	public boolean method_9651(@Nonnull class_1922 world, @Nonnull class_2338 pos, @Nonnull class_2680 state, boolean fuckifiknow) {
		return false;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {
		int hex = ColorHelper.getColorValue(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		if (rand.nextDouble() < ConfigHandler.CLIENT.flowerParticleFrequency.getValue()) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, pos.method_10263() + 0.3 + rand.nextFloat() * 0.5, pos.method_10264() + 0.5 + rand.nextFloat() * 0.5, pos.method_10260() + 0.3 + rand.nextFloat() * 0.5, 0, 0, 0);
		}

	}
}
