/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.entity.EntityManaStorm;
import vazkii.botania.common.entity.ModEntities;

public class BlockManaBomb extends BlockMod implements IManaTrigger {

	public BlockManaBomb(class_2251 builder) {
		super(builder);
	}

	@Override
	public void onBurstCollision(IManaBurst burst, class_1937 world, class_2338 pos) {
		if (!burst.isFake() && !world.field_9236) {
			world.method_20290(2001, pos, class_2248.method_9507(method_9564()));
			world.method_8650(pos, false);
			EntityManaStorm storm = ModEntities.MANA_STORM.method_5883(world);
			storm.burstColor = burst.getColor();
			storm.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
			world.method_8649(storm);
		}
	}
}
