/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileIncensePlate;

import javax.annotation.Nonnull;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockIncensePlate extends BlockModWaterloggable implements class_2343 {

	private static final class_265 X_SHAPE = method_9541(6, 0, 2, 10, 1, 14);
	private static final class_265 Z_SHAPE = method_9541(2, 0, 6, 14, 1, 10);

	protected BlockIncensePlate(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11035));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12481);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileIncensePlate plate = (TileIncensePlate) world.method_8321(pos);
		class_1799 plateStack = plate.getItemHandler().method_5438(0);
		class_1799 stack = player.method_5998(hand);
		boolean did = false;

		if (world.field_9236) {
			if (state.method_11654(class_2741.field_12508)
					&& !plateStack.method_7960()
					&& !plate.burning
					&& !stack.method_7960()
					&& stack.method_7909() == class_1802.field_8884) {
				plate.spawnSmokeParticles();
			}
			return class_1269.field_5812;
		}

		if (plateStack.method_7960() && plate.acceptsItem(stack)) {
			plate.getItemHandler().method_5447(0, stack.method_7972());
			stack.method_7934(1);
			did = true;
		} else if (!plateStack.method_7960() && !plate.burning) {
			if (!stack.method_7960() && stack.method_7909() == class_1802.field_8884) {
				plate.ignite();
				stack.method_7956(1, player, e -> e.method_20236(hand));
				did = true;
			} else {
				player.field_7514.method_7398(player.field_6002, plateStack);
				plate.getItemHandler().method_5447(0, class_1799.field_8037);

				did = true;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
		}

		return did ? class_1269.field_5812 : class_1269.field_5811;
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		return super.method_9605(context).method_11657(class_2741.field_12481, context.method_8042().method_10153());
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((TileIncensePlate) world.method_8321(pos)).comparatorOutput;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		if (state.method_11654(class_2741.field_12481).method_10166() == class_2350.class_2351.field_11048) {
			return X_SHAPE;
		} else {
			return Z_SHAPE;
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileIncensePlate();
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 plate = world.method_8321(pos);
			if (plate instanceof TileIncensePlate && !((TileIncensePlate) plate).burning) {
				class_1264.method_5451(world, pos, ((TileIncensePlate) plate).getItemHandler());
			}
		}
		super.method_9536(state, world, pos, newState, isMoving);
	}

}
