/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockHourglass extends BlockModWaterloggable implements IManaTrigger, class_2343, IWandable, IWandHUD {

	private static final class_265 SHAPE = method_9541(4, 0, 4, 12, 18.4, 12);

	protected BlockHourglass(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileHourglass hourglass = (TileHourglass) world.method_8321(pos);
		class_1799 hgStack = hourglass.getItemHandler().method_5438(0);
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && stack.method_7909() == ModItems.twigWand) {
			return class_1269.field_5811;
		}

		if (hourglass.lock) {
			if (!player.field_6002.field_9236) {
				player.method_9203(new class_2588("botaniamisc.hourglassLock"), class_156.field_25140);
			}
			return class_1269.field_5814;
		}

		if (hgStack.method_7960() && TileHourglass.getStackItemTime(stack) > 0) {
			hourglass.getItemHandler().method_5447(0, stack.method_7972());
			stack.method_7939(0);
			return class_1269.field_5812;
		} else if (!hgStack.method_7960()) {
			player.field_7514.method_7398(player.field_6002, hgStack);
			hourglass.getItemHandler().method_5447(0, class_1799.field_8037);
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
		return state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random rand) {
		if (state.method_11654(class_2741.field_12484)) {
			world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
		}
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileHourglass();
	}

	@Override
	public void onBurstCollision(IManaBurst burst, class_1937 world, class_2338 pos) {
		if (!burst.isFake()) {
			TileHourglass tile = (TileHourglass) world.method_8321(pos);
			tile.onManaCollide();
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		TileHourglass tile = (TileHourglass) world.method_8321(pos);
		tile.lock = !tile.lock;
		if (!world.field_9236) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
		}
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		TileHourglass tile = (TileHourglass) world.method_8321(pos);
		tile.renderHUD(ms);
	}

}
