/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import com.google.common.base.Preconditions;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.components.GhostRailComponent;

import javax.annotation.Nonnull;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3481;

public class BlockGhostRail extends class_2241 {

	public static final String TAG_FLOAT_TICKS = "botania:float_ticks";

	public BlockGhostRail(class_2251 builder) {
		super(true, builder);
		method_9590(method_9564().method_11657(class_2741.field_12542, class_2768.field_12665));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12542);
	}

	private void updateFloating(class_1688 cart) {
		cart.field_6002.method_16107().method_15396("cartFloating");
		GhostRailComponent persistentData = EntityComponents.GHOST_RAIL.get(cart);
		int floatTicks = persistentData.floatTicks;
		Preconditions.checkState(floatTicks > 0);

		class_2338 entPos = cart.method_24515();
		class_2680 state = cart.field_6002.method_8320(entPos);
		boolean air = state.method_26215();

		if (state.method_26204() == ModBlocks.dreamwood
				|| (state.method_26204() != ModBlocks.ghostRail && state.method_26164(class_3481.field_15463))) {
			cart.field_6002.method_20290(2003, entPos, 0);
			persistentData.floatTicks = 0;
		} else {
			class_2338 down = entPos.method_10074();
			class_2680 stateBelow = cart.field_6002.method_8320(down);
			boolean airBelow = stateBelow.method_26215();
			if (air && airBelow || !air && !airBelow) {
				cart.field_5960 = true;
			}
			cart.method_18800(cart.method_18798().method_10216() * 1.4, 0.2, cart.method_18798().method_10215() * 1.4);
			persistentData.floatTicks--;
			cart.field_6002.method_20290(2000, entPos, 0);
		}

		cart.field_6002.method_16107().method_15407();
	}

	public void onMinecartPass(class_1937 world, class_1688 cart) {
		if (!world.field_9236) {
			EntityComponents.GHOST_RAIL.get(cart).floatTicks = 20;
			updateFloating(cart);
		}
	}

	public void tickCart(class_1688 c) {
		if (c.field_6002.field_9236) {
			return;
		}

		GhostRailComponent persistentData = EntityComponents.GHOST_RAIL.get(c);
		if (!c.method_5805() || persistentData.floatTicks <= 0) {
			c.field_5960 = false;
			return;
		}

		updateFloating(c);

		if (persistentData.floatTicks <= 0) {
			c.field_5960 = false;
		}
	}

	@Nonnull
	@Override
	public class_2769<class_2768> method_9474() {
		return class_2741.field_12542;
	}
}
