/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.common.block.tile.TileForestEye;

import javax.annotation.Nonnull;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;

public class BlockForestEye extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(4, 4, 4, 12, 12, 12);

	public BlockForestEye(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		TileForestEye eye = (TileForestEye) world.method_8321(pos);
		return eye == null ? 0 : Math.min(15, Math.max(0, eye.entities - 1));
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileForestEye();
	}

}
