/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.decor.BlockFloatingFlower;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.Random;
import java.util.function.Supplier;

public class BlockFloatingSpecialFlower extends BlockFloatingFlower implements IWandable, IWandHUD {
	private final Supplier<? extends TileEntitySpecialFlower> teProvider;

	public BlockFloatingSpecialFlower(class_2251 props, Supplier<? extends TileEntitySpecialFlower> teProvider) {
		super(class_1767.field_7952, props);
		this.teProvider = teProvider;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random rand) {}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		return ((TileEntitySpecialFlower) world.method_8321(pos)).onWanded(player, stack);
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
		((TileEntitySpecialFlower) world.method_8321(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileEntitySpecialFlower) world.method_8321(pos)).renderHUD(ms, mc);
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return teProvider.get();
	}
}
