/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.block.*;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import vazkii.botania.common.block.tile.TileFakeAir;

import javax.annotation.Nonnull;

import java.util.Random;

public class BlockFakeAir extends class_2189 implements class_2343 {

	public BlockFakeAir(class_2251 builder) {
		super(builder);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		if (shouldRemove(world, pos)) {
			world.method_8397().method_8676(pos, this, 4);
		}
	}

	private boolean shouldRemove(class_1937 world, class_2338 pos) {
		return !world.field_9236 && world.method_8321(pos) == null || !(world.method_8321(pos) instanceof TileFakeAir) || !((TileFakeAir) world.method_8321(pos)).canStay();
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random rand) {
		if (shouldRemove(world, pos)) {
			world.method_8501(pos, rand.nextInt(10) == 0 ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
		}
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileFakeAir();
	}
}
