/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.tile.TileCocoon;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class BlockCocoon extends BlockModWaterloggable implements class_2343 {

	private static final class_265 SHAPE = method_9541(3, 0, 3, 13, 14, 13);;

	protected BlockCocoon(class_2251 builder) {
		super(builder);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 e) {
		if (!world.field_9236 && e instanceof class_1542) {
			class_1542 item = (class_1542) e;
			class_1799 stack = item.method_6983();
			addStack(world, pos, stack, false);

			if (stack.method_7960()) {
				item.method_5650();
			}
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		return addStack(world, pos, stack, player.field_7503.field_7477);
	}

	private class_1269 addStack(class_1937 world, class_2338 pos, class_1799 stack, boolean creative) {
		TileCocoon cocoon = (TileCocoon) world.method_8321(pos);
		class_1792 item = stack.method_7909();

		if (cocoon != null && (item == class_1802.field_8687 || item == class_1802.field_8233 || item == ModItems.lifeEssence)) {
			if (!world.field_9236) {
				if (item == class_1802.field_8687 && cocoon.emeraldsGiven < TileCocoon.MAX_EMERALDS) {
					if (!creative) {
						stack.method_7934(1);
					}
					cocoon.emeraldsGiven++;
					((class_3218) world).method_14199(class_2398.field_11211, pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5, 1, 0.1, 0.05, 0.1, 0.5);
				} else if (item == class_1802.field_8233 && cocoon.chorusFruitGiven < TileCocoon.MAX_CHORUS_FRUITS) {
					if (!creative) {
						stack.method_7934(1);
					}
					cocoon.chorusFruitGiven++;
					((class_3218) world).method_14199(class_2398.field_11214, pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5, 32, 0, 0, 0, 0.5);
				} else if (item == ModItems.lifeEssence && !cocoon.gaiaSpiritGiven) {
					if (!creative) {
						stack.method_7934(1);
					}
					cocoon.forceRare();
					WispParticleData data = WispParticleData.wisp(0.6F, 0F, 1F, 0F);
					((class_3218) world).method_14199(data, pos.method_10263() + 0.5, pos.method_10264() + 0.7, pos.method_10260() + 0.5, 8, 0.1, 0.1, 0.1, 0.04);
				}
			}

			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileCocoon();
	}

}
