/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.tile.TileAnimatedTorch;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockAnimatedTorch extends BlockModWaterloggable implements class_2343, IWandable, IManaTrigger, IHourglassTrigger, IWandHUD {

	private static final class_265 SHAPE = method_9541(0, 0, 0, 16, 4, 16);

	public BlockAnimatedTorch(class_2251 builder) {
		super(builder);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
		if (hand == class_1268.field_5808 && playerIn.method_5715() && playerIn.method_5998(hand).method_7960()) {
			((TileAnimatedTorch) worldIn.method_8321(pos)).handRotate();
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
		((TileAnimatedTorch) world.method_8321(pos)).onPlace(entity);
	}

	@Override
	public void onBurstCollision(IManaBurst burst, class_1937 world, class_2338 pos) {
		if (!burst.isFake()) {
			((TileAnimatedTorch) world.method_8321(pos)).toggle();
		}
	}

	@Override
	public void onTriggeredByHourglass(class_1937 world, class_2338 pos, class_2586 hourglass) {
		((TileAnimatedTorch) world.method_8321(pos)).toggle();
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		((TileAnimatedTorch) world.method_8321(pos)).onWanded();
		return true;
	}

	@Override
	@Environment(EnvType.CLIENT)
	public void renderHUD(class_4587 ms, class_310 mc, class_1937 world, class_2338 pos) {
		((TileAnimatedTorch) world.method_8321(pos)).renderHUD(ms, mc);
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9603(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
		return method_9524(blockState, blockAccess, pos, side);
	}

	@Override
	public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
		TileAnimatedTorch tile = (TileAnimatedTorch) blockAccess.method_8321(pos);

		if (tile.rotating) {
			return 0;
		}

		if (TileAnimatedTorch.SIDES[tile.side] == side) {
			return 15;
		}

		return 0;
	}

	@Nonnull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileAnimatedTorch();
	}

	@Override
	public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
		// TE is already gone so best we can do is just notify everyone
		world.method_8408(pos, this);
		super.method_9585(world, pos, state);
	}

}
