/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IPetalApothecary.State;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.rod.ItemWaterRod;

import javax.annotation.Nonnull;


import alexiil.mc.lib.attributes.ItemAttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Ref;
import alexiil.mc.lib.attributes.misc.Reference;

public class BlockAltar extends BlockMod implements class_2343 {

	public static final class_2754<State> FLUID = class_2754.method_11850("fluid", State.class);
	private static final class_265 BASE = class_2248.method_9541(0, 0, 0, 16, 2, 16);
	private static final class_265 MIDDLE = class_2248.method_9541(2, 2, 2, 14, 12, 14);
	private static final class_265 TOP = class_2248.method_9541(2, 12, 2, 14, 20, 14);
	private static final class_265 TOP_CUTOUT = class_2248.method_9541(3, 14, 3, 13, 20, 13);
	private static final class_265 SHAPE = class_259.method_1084(class_259.method_1084(BASE, MIDDLE), class_259.method_1072(TOP, TOP_CUTOUT, class_247.field_16886));

	public enum Variant {
		DEFAULT,
		FOREST,
		PLAINS,
		MOUNTAIN,
		FUNGAL,
		SWAMP,
		DESERT,
		TAIGA,
		MESA,
		MOSSY
	}

	public final Variant variant;

	protected BlockAltar(Variant v, class_4970.class_2251 builder) {
		super(builder);
		this.variant = v;
		method_9590(method_9564().method_11657(FLUID, State.EMPTY));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(FLUID);
	}

	@Nonnull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
		if (!world.field_9236 && entity instanceof class_1542) {
			TileAltar tile = (TileAltar) world.method_8321(pos);
			if (tile.collideEntityItem((class_1542) entity)) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
			}
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		TileAltar tile = (TileAltar) world.method_8321(pos);
		State fluid = tile.getFluid();
		class_1799 stack = player.method_5998(hand);
		if (player.method_5715()) {
			InventoryHelper.withdrawFromInventory(tile, player);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
			return class_1269.field_5812;
		} else if (tile.isEmpty() && fluid == State.WATER && stack.method_7960()) {
			tile.trySetLastRecipe(player);
			return class_1269.field_5812;
		} else {
			if (!stack.method_7960() && fluid != State.EMPTY && isValidFluidContainerToFill(stack, tile.getFluid().asVanilla()) && !Botania.gardenOfGlassLoaded) {
				if (!player.field_7503.field_7477) {
					//support bucket stacks
					if (stack.method_7947() == 1) {
						player.method_6122(hand, fill(tile.getFluid().asVanilla(), stack));
					} else {
						player.field_7514.method_7398(player.field_6002, new class_1799(stack.method_7909()));
						stack.method_7934(1);
					}
				}

				tile.setFluid(State.EMPTY);
				world.method_8398().method_12130().method_15559(pos);

				return class_1269.field_5812;
			} else if (!stack.method_7960() && (isValidFluidContainerToDrain(stack, class_3612.field_15910) || stack.method_7909() == ModItems.waterRod && ManaItemHandler.instance().requestManaExact(stack, player, ItemWaterRod.COST, false))) {
				if (tile.getFluid() == State.EMPTY) {
					if (stack.method_7909() == ModItems.waterRod) {
						ManaItemHandler.instance().requestManaExact(stack, player, ItemWaterRod.COST, true);
					} else if (!player.field_7503.field_7477) {
						player.method_6122(hand, drain(class_3612.field_15910, stack));
					}

					tile.setFluid(State.WATER);
				}

				return class_1269.field_5812;
			} else if (!stack.method_7960() && isValidFluidContainerToDrain(stack, class_3612.field_15908)) {
				if (tile.getFluid() == State.EMPTY) {
					if (!player.field_7503.field_7477) {
						player.method_6122(hand, drain(class_3612.field_15908, stack));
					}

					tile.setFluid(State.LAVA);
				}

				return class_1269.field_5812;
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9504(class_1937 world, class_2338 pos) {
		if (world.field_9229.nextInt(20) == 1) {
			class_2680 state = world.method_8320(pos);
			if (state.method_11654(FLUID) == State.EMPTY) {
				world.method_8501(pos, state.method_11657(FLUID, State.WATER));
			}
		}
	}

	private boolean isValidFluidContainerToDrain(class_1799 stack, class_3611 fluid) {
		if (stack.method_7960() || stack.method_7947() != 1) {
			return false;
		}

		Reference<class_1799> ref = Reference.simulating(() -> stack, LimitedConsumer.fromConsumer($ -> {}));
		ItemAttributeList<FluidExtractable> extrs = FluidAttributes.EXTRACTABLE.getAll(ref);
		FluidFilter filt = ExactFluidFilter.of(fluid);
		FluidAmount left = FluidAmount.BUCKET;
		for (int i = 0; i < extrs.getCount(); i++) {
			FluidExtractable ex = extrs.get(i);
			FluidVolume vol = ex.attemptExtraction(filt, left, Simulation.SIMULATE);
			left = left.sub(vol.amount());
			if (left.isZero() || left.isNegative()) {
				return true;
			}
		}
		return false;
	}

	private class_1799 drain(class_3611 fluid, class_1799 stack) {
		Reference<class_1799> ref = new Ref<>(stack);
		ItemAttributeList<FluidExtractable> extrs = FluidAttributes.EXTRACTABLE.getAll(ref);
		FluidFilter filt = ExactFluidFilter.of(fluid);
		FluidAmount left = FluidAmount.BUCKET;
		for (int i = 0; i < extrs.getCount(); i++) {
			FluidExtractable ex = extrs.get(i);
			FluidVolume vol = ex.extract(filt, left);
			left = left.sub(vol.amount());
			if (left.isZero() || left.isNegative()) {
				break;
			}
		}
		return ref.get();
	}

	private boolean isValidFluidContainerToFill(class_1799 stack, class_3611 fluid) {
		if (stack.method_7960()) {
			return false;
		}
		//support bucket stacks
		class_1799 container = stack.method_7947() > 1 ? new class_1799(stack.method_7909()) : stack;

		Reference<class_1799> ref = Reference.simulating(() -> container, LimitedConsumer.fromConsumer($ -> {}));
		ItemAttributeList<FluidInsertable> extrs = FluidAttributes.INSERTABLE.getAll(ref);
		FluidKey key = FluidKeys.get(fluid);
		FluidVolume excess = key.withAmount(FluidAmount.BUCKET);
		for (int i = 0; i < extrs.getCount(); i++) {
			FluidInsertable ins = extrs.get(i);
			excess = ins.insert(excess);
			if (excess.isEmpty()) {
				return true;
			}
		}
		return false;
	}

	private class_1799 fill(class_3611 fluid, class_1799 stack) {
		Reference<class_1799> ref = new Ref<>(stack);
		ItemAttributeList<FluidInsertable> extrs = FluidAttributes.INSERTABLE.getAll(ref);
		FluidKey key = FluidKeys.get(fluid);
		FluidVolume excess = key.withAmount(FluidAmount.BUCKET);
		for (int i = 0; i < extrs.getCount(); i++) {
			FluidInsertable ins = extrs.get(i);
			excess = ins.insert(excess);
			if (excess.isEmpty()) {
				break;
			}
		}
		return ref.get();
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileAltar();
	}

	@Override
	public void method_9536(@Nonnull class_2680 state, @Nonnull class_1937 world, @Nonnull class_2338 pos, @Nonnull class_2680 newState, boolean isMoving) {
		if (state.method_26204() != newState.method_26204()) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof TileSimpleInventory) {
				class_1264.method_5451(world, pos, ((TileSimpleInventory) be).getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return state.method_11654(FLUID) == State.WATER ? 15 : 0;
	}
}
