/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import vazkii.botania.client.fx.SparkleParticleData;

import java.util.Random;

public class BlockAltGrass extends BlockMod {

	public enum Variant {
		DRY,
		GOLDEN,
		VIVID,
		SCORCHED,
		INFUSED,
		MUTATED
	}

	private final Variant variant;

	public BlockAltGrass(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 held = player.method_5998(hand);
		if (held.method_7909() instanceof class_1794 && world.method_22347(pos.method_10084())) {
			held.method_7956(1, player, e -> e.method_20236(hand));
			world.method_8501(pos, class_2246.field_10362.method_9564());
			return class_1269.field_5812;
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random rand) {
		if (!world.field_9236 && state.method_26204() == this && world.method_22339(pos.method_10084()) >= 9) {
			for (int l = 0; l < 4; ++l) {
				class_2338 pos1 = pos.method_10069(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
				class_2338 pos1up = pos1.method_10084();

				if (world.method_8320(pos1).method_26204() == class_2246.field_10566 && world.method_22339(pos1up) >= 4 && world.method_8320(pos1up).method_26193(world, pos1up) <= 2) {
					world.method_8501(pos1, method_9564());
				}
			}
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random r) {
		switch (variant) {
		case DRY:
			break;
		case GOLDEN:
			break;
		case VIVID:
			break;
		case SCORCHED:
			if (r.nextInt(80) == 0) {
				world.method_8406(class_2398.field_11240, pos.method_10263() + r.nextFloat(), pos.method_10264() + 1.1, pos.method_10260() + r.nextFloat(), 0, 0, 0);
			}
			break;
		case INFUSED:
			if (r.nextInt(100) == 0) {
				SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2F + 1F, 0F, 1F, 1F, 5);
				world.method_8406(data, pos.method_10263() + r.nextFloat(), pos.method_10264() + 1.05, pos.method_10260() + r.nextFloat(), 0, 0, 0);
			}
			break;
		case MUTATED:
			if (r.nextInt(100) == 0) {
				if (r.nextInt(100) > 25) {
					SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2F + 1F, 1F, 0F, 1F, 5);
					world.method_8406(data, pos.method_10263() + r.nextFloat(), pos.method_10264() + 1.05, pos.method_10260() + r.nextFloat(), 0, 0, 0);
				} else {
					SparkleParticleData data = SparkleParticleData.sparkle(r.nextFloat() * 0.2F + 1F, 1F, 1F, 0F, 5);
					world.method_8406(data, pos.method_10263() + r.nextFloat(), pos.method_10264() + 1.05, pos.method_10260() + r.nextFloat(), 0, 0, 0);
				}
			}
			break;
		}
	}
}
