/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.advancements.AlfPortalTrigger;
import vazkii.botania.common.block.tile.TileAlfPortal;

import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BlockAlfPortal extends BlockMod implements class_2343, IWandable {

	public BlockAlfPortal(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(BotaniaStateProps.ALFPORTAL_STATE, AlfPortalState.OFF));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(BotaniaStateProps.ALFPORTAL_STATE);
	}

	@Nonnull
	@Override
	public class_2586 method_10123(@Nonnull class_1922 world) {
		return new TileAlfPortal();
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2350 side) {
		if (!world.field_9236) {
			boolean did = ((TileAlfPortal) world.method_8321(pos)).onWanded();
			if (did && player instanceof class_3222) {
				AlfPortalTrigger.INSTANCE.trigger((class_3222) player, (class_3218) world, pos, stack);
			}
			return did;
		}
		return true;
	}
}
