/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

// Catch-all "used an item and it succeeded" trigger for Botania items, because making a separate
// trigger for each one is dumb.
public class UseItemSuccessTrigger extends class_4558<UseItemSuccessTrigger.Instance> {
	public static final class_2960 ID = prefix("use_item_success");
	public static final UseItemSuccessTrigger INSTANCE = new UseItemSuccessTrigger();

	private UseItemSuccessTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	public UseItemSuccessTrigger.Instance method_27854(@Nonnull JsonObject json, @Nonnull class_2048.class_5258 playerPred, class_5257 conditions) {
		return new UseItemSuccessTrigger.Instance(playerPred, class_2073.method_8969(json.get("item")), class_2090.method_9021(json.get("location")));
	}

	public void trigger(class_3222 player, class_1799 stack, class_3218 world, double x, double y, double z) {
		method_22510(player, instance -> instance.test(stack, world, x, y, z));
	}

	static class Instance extends class_195 {
		private final class_2073 item;
		private final class_2090 location;

		Instance(class_2048.class_5258 playerPred, class_2073 count, class_2090 indexPos) {
			super(ID, playerPred);
			this.item = count;
			this.location = indexPos;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_1799 stack, class_3218 world, double x, double y, double z) {
			return this.item.method_8970(stack) && this.location.method_9018(world, x, y, z);
		}
	}
}
