/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import vazkii.botania.common.item.ItemManaGun;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaGunTrigger extends class_4558<ManaGunTrigger.Instance> {
	private static final class_2960 ID = prefix("fire_mana_blaster");
	public static final ManaGunTrigger INSTANCE = new ManaGunTrigger();

	private ManaGunTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	public ManaGunTrigger.Instance method_27854(@Nonnull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		Boolean desu = json.get("desu") == null ? null : json.get("desu").getAsBoolean();
		return new ManaGunTrigger.Instance(playerPred, class_2073.method_8969(json.get("item")), class_2048.method_8913(json.get("user")), desu);
	}

	public void trigger(class_3222 player, class_1799 stack) {
		method_22510(player, instance -> instance.test(stack, player));
	}

	static class Instance extends class_195 {
		private final class_2073 item;
		private final class_2048 user;
		@Nullable
		private final Boolean desu;

		Instance(class_2048.class_5258 entityPred, class_2073 count, class_2048 user, Boolean desu) {
			super(ID, entityPred);
			this.item = count;
			this.user = user;
			this.desu = desu;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_1799 stack, class_3222 entity) {
			return this.item.method_8970(stack) && this.user.method_8914(entity, entity)
					&& (desu == null || desu == ItemManaGun.isSugoiKawaiiDesuNe(stack));
		}
	}
}
