/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import vazkii.botania.common.entity.EntityDoppleganger;

import javax.annotation.Nonnull;
import net.minecraft.class_1282;
import net.minecraft.class_195;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class DopplegangerNoArmorTrigger extends class_4558<DopplegangerNoArmorTrigger.Instance> {
	public static final class_2960 ID = prefix("gaia_guardian_no_armor");
	public static final DopplegangerNoArmorTrigger INSTANCE = new DopplegangerNoArmorTrigger();

	private DopplegangerNoArmorTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	public DopplegangerNoArmorTrigger.Instance method_27854(@Nonnull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		return new DopplegangerNoArmorTrigger.Instance(playerPred, class_2048.method_8913(json.get("guardian")), class_2022.method_8846(json.get("killing_blow")));
	}

	public void trigger(class_3222 player, EntityDoppleganger guardian, class_1282 src) {
		method_22510(player, instance -> instance.test(player, guardian, src));
	}

	static class Instance extends class_195 {
		private final class_2048 guardian;
		private final class_2022 killingBlow;

		Instance(class_2048.class_5258 playerPred, class_2048 count, class_2022 indexPos) {
			super(ID, playerPred);
			this.guardian = count;
			this.killingBlow = indexPos;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3222 player, EntityDoppleganger guardian, class_1282 src) {
			return this.guardian.method_8914(player, guardian) && this.killingBlow.method_8847(player, src);
		}
	}
}
