/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import vazkii.botania.common.advancements.CorporeaRequestTrigger.Instance;

import javax.annotation.Nonnull;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class CorporeaRequestTrigger extends class_4558<CorporeaRequestTrigger.Instance> {
	public static final class_2960 ID = prefix("corporea_index_request");
	public static final CorporeaRequestTrigger INSTANCE = new CorporeaRequestTrigger();

	private CorporeaRequestTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	protected Instance method_27854(JsonObject json, class_2048.class_5258 playerPredicate, class_5257 conditions) {
		return new Instance(playerPredicate, class_2096.class_2100.method_9056(json.get("extracted")), class_2090.method_9021(json.get("location")));
	}

	public void trigger(class_3222 player, class_3218 world, class_2338 pos, int count) {
		this.method_22510(player, instance -> instance.test(world, pos, count));
	}

	static class Instance extends class_195 {
		private final class_2096.class_2100 count;
		private final class_2090 indexPos;

		Instance(class_2048.class_5258 playerPredicate, class_2096.class_2100 count, class_2090 indexPos) {
			super(ID, playerPredicate);
			this.count = count;
			this.indexPos = indexPos;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3218 world, class_2338 pos, int count) {
			return this.count.method_9054(count) && this.indexPos.method_9020(world, pos.method_10263(), pos.method_10264(), pos.method_10260());
		}
	}

}
