/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import vazkii.botania.common.advancements.AlfPortalTrigger.Instance;

import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class AlfPortalTrigger extends class_4558<AlfPortalTrigger.Instance> {
	public static final class_2960 ID = prefix("open_elf_portal");
	public static final AlfPortalTrigger INSTANCE = new AlfPortalTrigger();

	private AlfPortalTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	public Instance method_27854(@Nonnull JsonObject json, class_2048.class_5258 playerPred, class_5257 conditions) {
		return new Instance(playerPred, class_2073.method_8969(json.get("wand")), class_2090.method_9021(json.get("location")));
	}

	public void trigger(class_3222 player, class_3218 world, class_2338 pos, class_1799 wand) {
		method_22510(player, instance -> instance.test(world, pos, wand));
	}

	static class Instance extends class_195 {
		private final class_2073 wand;
		private final class_2090 pos;

		Instance(class_2048.class_5258 playerPred, class_2073 predicate, class_2090 pos) {
			super(ID, playerPred);
			this.wand = predicate;
			this.pos = pos;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3218 world, class_2338 pos, class_1799 wand) {
			return this.wand.method_8970(wand) && this.pos.method_9020(world, pos.method_10263(), pos.method_10264(), pos.method_10260());
		}
	}
}
