/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class AlfPortalBreadTrigger extends class_4558<AlfPortalBreadTrigger.Instance> {
	public static final class_2960 ID = prefix("alf_portal_bread");
	public static final AlfPortalBreadTrigger INSTANCE = new AlfPortalBreadTrigger();

	private AlfPortalBreadTrigger() {}

	@Nonnull
	@Override
	public class_2960 method_794() {
		return ID;
	}

	@Nonnull
	@Override
	public AlfPortalBreadTrigger.Instance method_27854(@Nonnull JsonObject json, class_2048.class_5258 playerPredicate, class_5257 conditions) {
		return new AlfPortalBreadTrigger.Instance(playerPredicate, class_2090.method_9021(json.get("portal_location")));
	}

	public void trigger(class_3222 player, class_2338 portal) {
		this.method_22510(player, instance -> instance.test(player.method_14220(), portal));
	}

	static class Instance extends class_195 {
		private final class_2090 portal;

		Instance(class_2048.class_5258 playerPredicate, class_2090 portal) {
			super(ID, playerPredicate);
			this.portal = portal;
		}

		@Nonnull
		@Override
		public class_2960 method_806() {
			return ID;
		}

		boolean test(class_3218 world, class_2338 portal) {
			return this.portal.method_9020(world, portal.method_10263(), portal.method_10264(), portal.method_10260());
		}
	}
}
