/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common;

import com.mojang.brigadier.CommandDispatcher;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1308;
import net.minecraft.class_1528;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.mana.ManaNetworkCallback;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.common.advancements.*;
import vazkii.botania.common.block.ModBanners;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.string.BlockRedStringInterceptor;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.core.ModStats;
import vazkii.botania.common.core.command.SkyblockCommand;
import vazkii.botania.common.core.handler.*;
import vazkii.botania.common.core.loot.LootHandler;
import vazkii.botania.common.core.loot.ModLootModifiers;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;
import vazkii.botania.common.impl.corporea.CorporeaStringMatcher;
import vazkii.botania.common.item.ItemGrassSeeds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemTravelBelt;
import vazkii.botania.common.item.material.ItemEnderAir;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.world.ModFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.data.DataGenerators;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class Botania implements ModInitializer {

	public static boolean gardenOfGlassLoaded = false;

	public static boolean curiosLoaded = false;

	public static IProxy proxy = new IProxy() {};
	public static volatile boolean configLoaded = false;

	public static final Logger LOGGER = LogManager.getLogger(LibMisc.MOD_ID);

	@Override
	public void onInitialize() {
		gardenOfGlassLoaded = FabricLoader.getInstance().isModLoaded("gardenofglass");
		curiosLoaded = FabricLoader.getInstance().isModLoaded("curios");
		ConfigHandler.setup();

		IMCSender.enqueue();
		ModFeatures.registerFeatures();
		ModItems.registerItems();
		ModItems.registerRecipeSerializers();
		ModEntities.registerEntities();
		ModRecipeTypes.registerRecipeTypes();
		ModSounds.init();
		ModBrews.registerBrews();
		ModPotions.registerPotions();
		ModBlocks.registerBlocks();
		ModBlocks.registerItemBlocks();
		ModTiles.registerTiles();
		ModFluffBlocks.registerBlocks();
		ModFluffBlocks.registerItemBlocks();
		ModParticles.registerParticles();
		ModSubtiles.registerBlocks();
		ModSubtiles.registerItemBlocks();
		ModSubtiles.registerTEs();
		PixieHandler.registerAttribute();

		commonSetup();
		ServerLifecycleEvents.SERVER_STARTED.register(this::serverAboutToStart);
		CommandRegistrationCallback.EVENT.register(this::registerCommands);
		ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
		UseBlockCallback.EVENT.register(ItemLokiRing::onPlayerInteract);
		UseItemCallback.EVENT.register(ItemEnderAir::onPlayerInteract);
		ServerTickEvents.END_WORLD_TICK.register(ItemGrassSeeds::onTickEnd);
		ServerPlayerEvents.AFTER_RESPAWN.register(ItemKeepIvy::onPlayerRespawn);
		ServerTickEvents.END_WORLD_TICK.register(CommonTickHandler::onTick);
		UseBlockCallback.EVENT.register(BlockRedStringInterceptor::onInteract);
		ManaNetworkCallback.EVENT.register(ManaNetworkHandler.instance::onNetworkEvent);
		LootTableLoadingCallback.EVENT.register(LootHandler::lootLoad);
		ServerPlayConnectionEvents.DISCONNECT.register(ItemTravelBelt::playerLoggedOut);
		ServerPlayConnectionEvents.DISCONNECT.register(ItemFlightTiara::playerLoggedOut);

		ModLootModifiers.init();
		ModCriteriaTriggers.init();
	}

	private void commonSetup() {
		PacketHandler.init();

		EquipmentHandler.init();
		CorporeaHelper.instance().registerRequestMatcher(prefix("string"), CorporeaStringMatcher.class, CorporeaStringMatcher::createFromNBT);
		CorporeaHelper.instance().registerRequestMatcher(prefix("item_stack"), CorporeaItemStackMatcher.class, CorporeaItemStackMatcher::createFromNBT);

		if (Botania.gardenOfGlassLoaded) {
			UseBlockCallback.EVENT.register(SkyblockWorldEvents::onPlayerInteract);
		}

		SkyblockChunkGenerator.init();

		FabricDefaultAttributeRegistry.register(ModEntities.DOPPLEGANGER, class_1308.method_26828()
				.method_26868(class_5134.field_23719, 0.4)
				.method_26868(class_5134.field_23716, EntityDoppleganger.MAX_HP)
				.method_26868(class_5134.field_23718, 1.0));
		FabricDefaultAttributeRegistry.register(ModEntities.PIXIE, class_1308.method_26828()
				.method_26868(class_5134.field_23716, 2.0));
		FabricDefaultAttributeRegistry.register(ModEntities.PINK_WITHER, class_1528.method_26904());
		ModBanners.init();

		PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221(ModBlocks.alfPortal), TileAlfPortal.MULTIBLOCK.method_15332());
		PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221(ModBlocks.terraPlate), TileTerraPlate.MULTIBLOCK.method_15332());
		PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221(ModBlocks.enchanter), TileEnchanter.MULTIBLOCK.method_15332());

		String[][] pat = new String[][] {
				{
						"P_______P",
						"_________",
						"_________",
						"_________",
						"_________",
						"_________",
						"_________",
						"_________",
						"P_______P",
				},
				{
						"_________",
						"_________",
						"_________",
						"_________",
						"____B____",
						"_________",
						"_________",
						"_________",
						"_________",
				},
				{
						"_________",
						"_________",
						"_________",
						"___III___",
						"___I0I___",
						"___III___",
						"_________",
						"_________",
						"_________",
				}
		};
		IStateMatcher sm = PatchouliAPI.get().predicateMatcher(class_2246.field_10085,
				state -> state.method_26164(class_3481.field_22275));
		IMultiblock mb = PatchouliAPI.get().makeMultiblock(
				pat,
				'P', ModBlocks.gaiaPylon,
				'B', class_2246.field_10327,
				'I', sm,
				'0', sm
		);
		PatchouliAPI.get().registerMultiblock(prefix("gaia_ritual"), mb);

		ModBlocks.addDispenserBehaviours();

		ModStats.init();
	}

	private void serverAboutToStart(MinecraftServer server) {
		if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
			String clname = BotaniaAPI.instance().getClass().getName();
			throw new IllegalAccessError("The Botania API has been overriden. "
					+ "This will cause crashes and compatibility issues, and that's why it's marked as"
					+ " \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go"
					+ " back to elementary school and learn to read. (Actual classname: " + clname + ")");
		}
	}

	private void registerCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
		if (Botania.gardenOfGlassLoaded) {
			SkyblockCommand.register(dispatcher);
		}
		DataGenerators.registerCommands(dispatcher);
	}

	private void serverStopping(MinecraftServer server) {
		ManaNetworkHandler.instance.clear();
		TileCorporeaIndex.clearCache();
	}

}
