/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import com.mojang.datafixers.util.Pair;
import vazkii.botania.api.item.TinyPotatoRenderCallback;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_239;
import net.minecraft.class_2585;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_630;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileTinyPotato extends class_827<TileTinyPotato> {
	private static final class_2960 texture = new class_2960(LibResources.MODEL_TINY_POTATO);
	private static final class_2960 textureGrayscale = new class_2960(LibResources.MODEL_TINY_POTATO_GS);
	private static final class_2960 textureHalloween = new class_2960(LibResources.MODEL_TINY_POTATO_HALLOWEEN);
	private final class_630 potatoModel = new class_630(16, 16, 0, 0);

	public RenderTileTinyPotato(class_824 manager) {
		super(manager);
		potatoModel.method_2844(0F, 0F, 0F, 4, 6, 4);
		potatoModel.method_2851(-2F, 18F, -2F);
		potatoModel.method_2853(64, 32);
	}

	private static boolean matches(String name, String match) {
		return name.equals(match) || name.startsWith(match + " ");
	}

	private static String removeFromFront(String name, String match) {
		return name.substring(match.length()).trim();
	}

	private static Pair<ShaderHelper.BotaniaShader, String> stripShaderName(String name) {
		if (matches(name, "gaia")) {
			return Pair.of(ShaderHelper.BotaniaShader.DOPPLEGANGER, removeFromFront(name, "gaia"));
		} else if (matches(name, "hot")) {
			return Pair.of(ShaderHelper.BotaniaShader.HALO, removeFromFront(name, "hot"));
		} else if (matches(name, "magic")) {
			return Pair.of(ShaderHelper.BotaniaShader.ENCHANTER_RUNE, removeFromFront(name, "magic"));
		} else if (matches(name, "gold")) {
			return Pair.of(ShaderHelper.BotaniaShader.GOLD, removeFromFront(name, "gold"));
		} else if (matches(name, "snoop")) {
			return Pair.of(ShaderHelper.BotaniaShader.TERRA_PLATE, removeFromFront(name, "snoop"));
		} else {
			return Pair.of(null, name);
		}
	}

	private static class_1921 getRenderLayer(@Nullable ShaderHelper.BotaniaShader shader, String name) {
		class_1921 base;
		if ("kyle hyde".equals(name)) {
			base = class_1921.method_23572(textureGrayscale);
		} else if (ClientProxy.dootDoot) {
			base = class_1921.method_23572(textureHalloween);
		} else {
			base = class_1921.method_23572(texture);
		}
		return shader == null || !ShaderHelper.useShaders() ? base : new ShaderWrappedRenderLayer(shader, null, base);

	}

	@Override
	public void render(@Nonnull TileTinyPotato potato, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		String name = potato.name.getString().toLowerCase().trim();
		Pair<ShaderHelper.BotaniaShader, String> shaderStrippedName = stripShaderName(name);
		ShaderHelper.BotaniaShader shader = shaderStrippedName.getFirst();
		name = shaderStrippedName.getSecond();
		class_1921 layer = getRenderLayer(shader, name);

		ms.method_22904(0.5F, 1.5F, 0.5F);
		ms.method_22905(1F, -1F, -1F);

		class_2350 potatoFacing = potato.method_11010().method_11654(class_2741.field_12481);
		float rotY = 0;
		switch (potatoFacing) {
		default:
		case field_11035:
			break;
		case field_11043:
			rotY = 180F;
			break;
		case field_11034:
			rotY = 270F;
			break;
		case field_11039:
			rotY = 90F;
			break;
		}
		ms.method_22907(class_1160.field_20705.method_23214(rotY));

		float jump = potato.jumpTicks;
		if (jump > 0) {
			jump -= partialTicks;
		}

		float up = (float) -Math.abs(Math.sin(jump / 10 * Math.PI)) * 0.2F;
		float rotZ = (float) Math.sin(jump / 10 * Math.PI) * 2;

		ms.method_22904(0F, up, 0F);
		ms.method_22907(class_1160.field_20707.method_23214(rotZ));

		ms.method_22903();
		float r = 1;
		float g = 1;
		float b = 1;
		switch (name) {
		case "pahimar":
			ms.method_22905(1F, 0.3F, 1F);
			ms.method_22904(0F, 3.5F, 0F);
			break;
		case "dinnerbone":
		case "grumm":
			ms.method_22907(class_1160.field_20707.method_23214(180F));
			ms.method_22904(0F, -2.625F, 0F);
			break;
		case "aureylian":
			g = 0.5F;
			break;
		}

		class_4588 buffer = buffers.getBuffer(layer);
		boolean render = !(name.equals("mami") || name.equals("soaryn") || name.equals("eloraam") && jump != 0);
		if (render) {
			potatoModel.method_22699(ms, buffer, light, overlay, r, g, b, 1);
		}
		if (name.equals("kingdaddydmac")) {
			ms.method_22904(0.5F, 0F, 0F);
			potatoModel.method_22699(ms, buffer, light, overlay, r, g, b, 1);
		}
		ms.method_22909();

		renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);

		ms.method_22903();
		TinyPotatoRenderCallback.EVENT.invoker().onRender(potato, potato.name, partialTicks, ms, buffers, light, overlay);
		ms.method_22909();

		ms.method_22907(class_1160.field_20707.method_23214(-rotZ));
		ms.method_22907(class_1160.field_20705.method_23214(-rotY));
		ms.method_22905(1F, -1F, -1F);

		renderName(potato, name, ms, buffers, light);
		ms.method_22909();
	}

	private void renderName(TileTinyPotato potato, String name, class_4587 ms, class_4597 buffers, int light) {
		class_310 mc = class_310.method_1551();
		class_239 pos = mc.field_1765;
		if (!name.isEmpty() && pos != null && pos.method_17783() == class_239.class_240.field_1332
				&& potato.method_11016().equals(((class_3965) pos).method_17777())) {
			ms.method_22903();
			ms.method_22904(0F, -0.6F, 0F);
			ms.method_22907(mc.method_1561().method_24197());
			float f1 = 0.016666668F * 1.6F;
			ms.method_22905(-f1, -f1, f1);
			ms.method_22904(0.0F, 0F / f1, 0.0F);
			int halfWidth = mc.field_1772.method_1727(potato.name.getString()) / 2;

			float opacity = class_310.method_1551().field_1690.method_19343(0.25F);
			int opacityRGB = (int) (opacity * 255.0F) << 24;
			mc.field_1772.method_30882(potato.name, -halfWidth, 0, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
			mc.field_1772.method_30882(potato.name, -halfWidth, 0, 0xFFFFFFFF, false, ms.method_23760().method_23761(), buffers, false, 0, light);
			if (name.equals("pahimar") || name.equals("soaryn")) {
				ms.method_22904(0F, 14F, 0F);
				String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
				halfWidth = mc.field_1772.method_1727(str) / 2;

				mc.field_1772.method_27521(str, -halfWidth, 0, 0x20FFFFFF, false, ms.method_23760().method_23761(), buffers, true, opacityRGB, light);
				mc.field_1772.method_27521(str, -halfWidth, 0, 0xFFFFFFFF, false, ms.method_23760().method_23761(), buffers, true, 0, light);
			}

			ms.method_22909();
		}
	}

	private void renderItems(TileTinyPotato potato, class_2350 facing, String name, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22907(class_1160.field_20707.method_23214(180F));
		ms.method_22904(0F, -1F, 0F);
		float s = 1F / 3.5F;
		ms.method_22905(s, s, s);

		for (int i = 0; i < potato.inventorySize(); i++) {
			class_1799 stack = potato.getItemHandler().method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			ms.method_22903();
			class_2350 side = class_2350.values()[i];
			if (side.method_10166() != class_2351.field_11052) {
				float sideAngle = side.method_10144() - facing.method_10144();
				side = class_2350.method_10150(sideAngle);
			}

			boolean block = stack.method_7909() instanceof class_1747;
			boolean mySon = stack.method_7909() instanceof ItemBlockTinyPotato;

			switch (side) {
			case field_11036:
				if (mySon) {
					ms.method_22904(0F, 0.6F, 0.5F);
				} else if (block) {
					ms.method_22904(0F, 0.3F, 0.5F);
				}
				ms.method_22904(0F, -0.5F, -0.4F);
				break;
			case field_11033:
				ms.method_22904(0, -2.3F, -0.88F);
				if (mySon) {
					ms.method_22904(0, .65F, 0.6F);
				} else if (block) {
					ms.method_22904(0, 1, 0.6F);
				}
				break;
			case field_11043:
				ms.method_22904(0, -1.9F, 0.02F);
				if (mySon) {
					ms.method_22904(0, 1, 0.6F);
				} else if (block) {
					ms.method_22904(0, 1, 0.6F);
				}
				break;
			case field_11035:
				ms.method_22904(0, -1.6F, -0.89F);
				if (mySon) {
					ms.method_22904(0, 1.4F, 0.5F);
				} else if (block) {
					ms.method_22904(0, 1.0F, 0.5F);
				}
				break;
			case field_11034:
				if (mySon) {
					ms.method_22904(-0.4F, 0.65F, 0F);
				} else if (block) {
					ms.method_22904(-0.4F, 0.8F, 0F);
				} else {
					ms.method_22907(class_1160.field_20705.method_23214(-90F));
				}
				ms.method_22904(-0.3F, -1.9F, 0.04F);
				break;
			case field_11039:
				if (mySon) {
					ms.method_22904(1F, 0.65F, 1F);
				} else if (block) {
					ms.method_22904(1F, 0.8F, 1F);
				} else {
					ms.method_22907(class_1160.field_20705.method_23214(-90F));
				}
				ms.method_22904(-0.3F, -1.9F, -0.92F);
				break;
			}

			if (mySon) {
				ms.method_22905(1.1F, 1.1F, 1.1F);
			} else if (block) {
				ms.method_22905(0.5F, 0.5F, 0.5F);
			}
			if (block && side == class_2350.field_11043) {
				ms.method_22907(class_1160.field_20705.method_23214(180F));
			}
			renderItem(ms, buffers, light, overlay, stack);
			ms.method_22909();
		}
		ms.method_22909();

		ms.method_22903();
		if (!name.isEmpty()) {
			ContributorFancinessHandler.firstStart();

			float scale = 1F / 4F;
			ms.method_22904(0F, 1F, 0F);
			ms.method_22905(scale, scale, scale);
			if (name.equals("phi") || name.equals("vazkii")) {
				ms.method_22903();
				ms.method_22904(-0.15, 0.1, 0.4);
				ms.method_22907(class_1160.field_20705.method_23214(90F));
				ms.method_22907(new class_1160(1, 0, 1).method_23214(20));
				renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.phiFlowerModel);
				ms.method_22909();

				if (name.equals("vazkii")) {
					ms.method_22905(1.25F, 1.25F, 1.25F);
					ms.method_22907(class_1160.field_20703.method_23214(180F));
					ms.method_22907(class_1160.field_20705.method_23214(-90F));
					ms.method_22904(0.2, -1.25, 0);
					renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.nerfBatModel);
				}
			} else if (name.equals("haighyorkie")) {
				ms.method_22905(1.25F, 1.25F, 1.25F);
				ms.method_22907(class_1160.field_20707.method_23214(180F));
				ms.method_22907(class_1160.field_20705.method_23214(-90F));
				ms.method_22904(-0.5F, -1.2F, -0.075F);
				renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.goldfishModel);
			} else if (name.equals("martysgames") || name.equals("marty")) {
				ms.method_22905(0.7F, 0.7F, 0.7F);
				ms.method_22907(class_1160.field_20707.method_23214(180F));
				ms.method_22904(-0.3F, -2.7F, -1.2F);
				ms.method_22907(class_1160.field_20707.method_23214(15F));
				renderItem(ms, buffers, light, overlay, new class_1799(ModItems.infiniteFruit, 1).method_7977(new class_2585("das boot")));
			} else if (name.equals("jibril")) {
				ms.method_22905(1.5F, 1.5F, 1.5F);
				ms.method_22904(0F, 0.8F, 0F);
				ItemFlightTiara.renderHalo(null, null, ms, buffers, partialTicks);
			} else if (name.equals("kingdaddydmac")) {
				ms.method_22905(0.5F, 0.5F, 0.5F);
				ms.method_22907(class_1160.field_20707.method_23214(180));
				ms.method_22907(class_1160.field_20705.method_23214(90));
				ms.method_22903();
				ms.method_22904(0F, -2.5F, 0.65F);
				class_1799 ring = new class_1799(ModItems.manaRing);
				renderItem(ms, buffers, light, overlay, ring);
				ms.method_22904(0F, 0F, -4F);
				renderItem(ms, buffers, light, overlay, ring);
				ms.method_22909();

				ms.method_22904(1.5, -4, -2.5);
				renderBlock(ms, buffers, light, overlay, class_2246.field_10183);
			} else {
				class_1799 icon = ContributorFancinessHandler.getFlower(name);
				if (!icon.method_7960()) {
					ms.method_22907(class_1160.field_20703.method_23214(180));
					ms.method_22907(class_1160.field_20705.method_23214(180));
					ms.method_22904(0, -0.75, -0.5);
					class_310.method_1551().method_1480().method_23178(icon, class_809.class_811.field_4316, light, overlay, ms, buffers);
				}
			}
		}
		ms.method_22909();
	}

	private void renderModel(class_4587 ms, class_4597 buffers, int light, int overlay, class_1087 model) {
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffers.getBuffer(class_4722.method_24076()), null, model, 1, 1, 1, light, overlay);
	}

	private void renderItem(class_4587 ms, class_4597 buffers, int light, int overlay, class_1799 stack) {
		class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4316, light, overlay, ms, buffers);
	}

	private void renderBlock(class_4587 ms, class_4597 buffers, int light, int overlay, class_2248 block) {
		class_310.method_1551().method_1541().method_3353(block.method_9564(), ms, buffers, light, overlay);
	}
}
