/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.TileTerraPlate;

import javax.annotation.Nonnull;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileTerraPlate extends class_827<TileTerraPlate> {

	public RenderTileTerraPlate(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TileTerraPlate plate, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float alphaMod = Math.min(1.0F, plate.getCompletion() / 0.1F);

		ms.method_22903();
		ms.method_22907(class_1160.field_20703.method_23214(90F));
		ms.method_22904(0F, 0F, -3F / 16F - 0.001F);

		float alpha = (float) ((Math.sin((ClientTickHandler.ticksInGame + f) / 8D) + 1D) / 5D + 0.6D) * alphaMod;

		class_4588 buffer = buffers.getBuffer(RenderHelper.TERRA_PLATE);
		IconHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousIcons.INSTANCE.terraPlateOverlay.method_24148(), 1, 1, alpha);

		ms.method_22909();
	}

}
