/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.helper.ColorHelper;

import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import java.util.Random;

public class RenderTileSpreader extends class_827<TileSpreader> {

	public RenderTileSpreader(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TileSpreader spreader, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		ms.method_22904(0.5F, 0.5, 0.5F);

		class_1158 transform = class_1160.field_20705.method_23214(spreader.rotationX + 90F);
		transform.method_4925(class_1160.field_20703.method_23214(spreader.rotationY));
		ms.method_22907(transform);

		ms.method_22904(-0.5F, -0.5F, -0.5F);

		double time = ClientTickHandler.ticksInGame + partialTicks;

		float r = 1, g = 1, b = 1;
		if (spreader.getVariant() == BlockSpreader.Variant.GAIA) {
			int color = class_3532.method_15369((float) ((time * 5 + new Random(spreader.method_11016().hashCode()).nextInt(10000)) % 360) / 360F, 0.4F, 0.9F);
			r = (color >> 16 & 0xFF) / 255F;
			g = (color >> 8 & 0xFF) / 255F;
			b = (color & 0xFF) / 255F;
		}

		class_4588 buffer = buffers.getBuffer(class_4696.method_23683(spreader.method_11010(), false));
		class_1087 bakedModel = class_310.method_1551().method_1541().method_3349(spreader.method_11010());
		class_310.method_1551().method_1541().method_3350()
				.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
						bakedModel, r, g, b, light, overlay);

		ms.method_22903();
		ms.method_22904(0.5, 0.5, 0.5);
		ms.method_22907(class_1160.field_20705.method_23214((float) time % 360));
		ms.method_22904(-0.5, -0.5, -0.5);
		ms.method_22904(0F, (float) Math.sin(time / 20.0) * 0.05F, 0F);
		class_1087 cube = getInsideModel(spreader);
		class_310.method_1551().method_1541().method_3350()
				.method_3367(ms.method_23760(), buffer, spreader.method_11010(),
						cube, 1, 1, 1, light, overlay);
		ms.method_22909();

		ms.method_22904(0.5, 1.5, 0.5);
		class_1799 stack = spreader.getItemHandler().method_5438(0);

		if (!stack.method_7960()) {
			ms.method_22903();
			ms.method_22904(0.0F, -1F, -0.4675F);
			ms.method_22907(class_1160.field_20707.method_23214(180));
			ms.method_22907(class_1160.field_20703.method_23214(180));
			ms.method_22905(1.0F, 1.0F, 1.0F);
			class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4315, light, overlay, ms, buffers);
			ms.method_22909();
		}

		if (spreader.paddingColor != null) {
			class_2680 carpet = ColorHelper.CARPET_MAP.apply(spreader.paddingColor).method_9564();
			class_1087 model = class_310.method_1551().method_1541().method_3349(carpet);
			buffer = buffers.getBuffer(class_4696.method_23683(carpet, false));

			float f = 1 / 16F;

			// back
			ms.method_22903();
			ms.method_22907(class_1160.field_20703.method_23214(90));
			ms.method_22904(-0.5F, 0.5F - f, 0.5F);
			class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, carpet, model, 1, 1, 1, light, overlay);
			ms.method_22909();

			// left
			ms.method_22903();
			ms.method_22907(class_1160.field_20707.method_23214(-90));
			ms.method_22904(0.5F, 0.5F, -0.5F - f);
			class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, carpet, model, 1, 1, 1, light, overlay);
			ms.method_22909();

			// right
			ms.method_22903();
			ms.method_22907(class_1160.field_20707.method_23214(90));
			ms.method_22904(-1.5F, 0.5F, -0.5F - f);
			class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, carpet, model, 1, 1, 1, light, overlay);
			ms.method_22909();

			// top
			ms.method_22903();
			ms.method_22904(-0.5F, -0.5F, -0.5F - f);
			class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, carpet, model, 1, 1, 1, light, overlay);
			ms.method_22909();

			// bottom
			ms.method_22903();
			ms.method_22907(class_1160.field_20705.method_23214(180));
			ms.method_22904(-0.5F, -1.5F - f, -0.5F + f);
			class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, carpet, model, 1, 1, 1, light, overlay);
			ms.method_22909();
		}

		ms.method_22909();
	}

	private class_1087 getInsideModel(TileSpreader tile) {
		switch (tile.getVariant()) {
		case GAIA:
			return MiscellaneousIcons.INSTANCE.gaiaSpreaderInside;
		case REDSTONE:
			return MiscellaneousIcons.INSTANCE.redstoneSpreaderInside;
		case ELVEN:
			return MiscellaneousIcons.INSTANCE.elvenSpreaderInside;
		default:
		case MANA:
			return MiscellaneousIcons.INSTANCE.manaSpreaderInside;
		}
	}
}
