/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class RenderTileRedString<T extends TileRedString> extends class_827<T> {
	// 0 -> none, 10 -> full
	private static int transparency = 0;

	public static void tick() {
		class_1657 player = class_310.method_1551().field_1724;
		boolean hasWand = player != null && PlayerHelper.hasHeldItem(player, ModItems.twigWand);
		if (transparency > 0 && !hasWand) {
			transparency--;
		} else if (transparency < 10 && hasWand) {
			transparency++;
		}
	}

	public RenderTileRedString(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(TileRedString tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		if (transparency <= 0) {
			return;
		}

		float sizeAlpha = transparency / 10.0F;
		int color = 0xFF0000 | ((int) (sizeAlpha * 255) << 24);

		class_2350 dir = tile.getOrientation();
		class_2338 bind = tile.getBinding();

		if (bind != null) {
			ms.method_22903();
			ms.method_22904(0.5, 0.5, 0.5);
			Vector3 vecOrig = new Vector3(bind.method_10263() - tile.method_11016().method_10263(), bind.method_10264() - tile.method_11016().method_10264(), bind.method_10260() - tile.method_11016().method_10260());
			Vector3 vecNorm = vecOrig.normalize();
			Vector3 vecMag = vecNorm.multiply(0.025);
			Vector3 vecApply = vecMag;

			int stages = (int) (vecOrig.mag() / vecMag.mag());

			double len = (double) -ClientTickHandler.ticksInGame / 100F + new Random(dir.ordinal() ^ tile.method_11016().hashCode()).nextInt(10000);
			double add = vecMag.mag();
			double rand = Math.random() - 0.5;
			class_4588 buffer = buffers.getBuffer(RenderHelper.LINE_1);
			for (int i = 0; i < stages; i++) {
				addVertexAtWithTranslation(ms, buffer, color, dir, vecApply.x, vecApply.y, vecApply.z, rand, len);
				rand = Math.random() - 0.5;
				vecApply = vecApply.add(vecMag);
				len += add;
				addVertexAtWithTranslation(ms, buffer, color, dir, vecApply.x, vecApply.y, vecApply.z, rand, len);
			}

			ms.method_22909();
		}
	}

	private static void addVertexAtWithTranslation(class_4587 ms, class_4588 buffer, int color, class_2350 dir, double xpos, double ypos, double zpos, double rand, double l) {
		double freq = 20;
		float sizeAlpha = transparency / 10.0F;
		double ampl = (0.15 * (Math.sin(l * 2F) * 0.5 + 0.5) + 0.1) * sizeAlpha;
		double randMul = 0.05;
		double x = xpos + Math.sin(l * freq) * ampl * Math.abs(Math.abs(dir.method_10148()) - 1) + rand * randMul;
		double y = ypos + Math.cos(l * freq) * ampl * Math.abs(Math.abs(dir.method_10164()) - 1) + rand * randMul;
		double z = zpos + (dir.method_10164() == 0 ? Math.sin(l * freq) : Math.cos(l * freq)) * ampl * Math.abs(Math.abs(dir.method_10165()) - 1) + rand * randMul;

		int a = (color >> 24) & 0xFF;
		int r = (color >> 16) & 0xFF;
		int g = (color >> 8) & 0xFF;
		int b = color & 0xFF;
		buffer.method_22918(ms.method_23760().method_23761(), (float) x, (float) y, (float) z).method_1336(r, g, b, a).method_1344();
	}

}
