/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.LibResources;
import vazkii.botania.client.model.IPylonModel;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.tile.TilePylon;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.Random;

public class RenderTilePylon extends class_827<TilePylon> {

	public static final class_2960 MANA_TEXTURE = new class_2960(LibResources.MODEL_PYLON_MANA);
	public static final class_2960 NATURA_TEXTURE = new class_2960(LibResources.MODEL_PYLON_NATURA);
	public static final class_2960 GAIA_TEXTURE = new class_2960(LibResources.MODEL_PYLON_GAIA);

	private final ModelPylonMana manaModel = new ModelPylonMana();
	private final ModelPylonNatura naturaModel = new ModelPylonNatura();
	private final ModelPylonGaia gaiaModel = new ModelPylonGaia();

	// Overrides for when we call this TESR without an actual pylon
	private static BlockPylon.Variant forceVariant = BlockPylon.Variant.MANA;
	private static class_809.class_811 forceTransform = class_809.class_811.field_4315;

	public RenderTilePylon(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(@Nonnull TilePylon pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		renderPylon(pylon, pticks, ms, buffers, light, overlay);
	}

	private void renderPylon(@Nullable TilePylon pylon, float pticks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		boolean renderingItem = pylon == null;
		boolean direct = renderingItem && (forceTransform == class_809.class_811.field_4317 || forceTransform.method_29998()); // loosely based off ItemRenderer logic
		BlockPylon.Variant type = renderingItem ? forceVariant : ((BlockPylon) pylon.method_11010().method_26204()).variant;
		IPylonModel model;
		class_2960 texture;
		class_1921 shaderLayer;
		switch (type) {
		default:
		case MANA: {
			model = manaModel;
			texture = MANA_TEXTURE;
			shaderLayer = direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
			break;
		}
		case NATURA: {
			model = naturaModel;
			texture = NATURA_TEXTURE;
			shaderLayer = direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
			break;
		}
		case GAIA: {
			model = gaiaModel;
			texture = GAIA_TEXTURE;
			shaderLayer = direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
			break;
		}
		}

		ms.method_22903();

		float worldTime = ClientTickHandler.ticksInGame + pticks;

		worldTime += pylon == null ? 0 : new Random(pylon.method_11016().hashCode()).nextInt(360);

		ms.method_22904(0, pylon == null ? 1.35 : 1.5, 0);
		ms.method_22905(1.0F, -1.0F, -1.0F);

		ms.method_22903();
		ms.method_22904(0.5F, 0F, -0.5F);
		if (pylon != null) {
			ms.method_22907(class_1160.field_20705.method_23214(worldTime * 1.5F));
		}

		class_1921 layer = class_1921.method_23580(texture);

		class_4588 buffer = buffers.getBuffer(layer);
		model.renderRing(ms, buffer, light, overlay);
		if (pylon != null) {
			ms.method_22904(0D, Math.sin(worldTime / 20D) / 20 - 0.025, 0D);
		}
		ms.method_22909();

		ms.method_22903();
		if (pylon != null) {
			ms.method_22904(0D, Math.sin(worldTime / 20D) / 17.5, 0D);
		}

		ms.method_22904(0.5F, 0F, -0.5F);
		if (pylon != null) {
			ms.method_22907(class_1160.field_20705.method_23214(-worldTime));
		}

		buffer = buffers.getBuffer(shaderLayer);
		model.renderCrystal(ms, buffer, light, overlay);

		ms.method_22909();

		ms.method_22909();
	}

	public static class TEISR implements BuiltinItemRendererRegistry.DynamicItemRenderer {
		private static final class_3528<TilePylon> DUMMY = new class_3528<>(TilePylon::new);

		@Override
		public void render(class_1799 stack, class_809.class_811 type, class_4587 ms, class_4597 buffers, int light, int overlay) {
			if (class_2248.method_9503(stack.method_7909()) instanceof BlockPylon) {
				RenderTilePylon.forceVariant = ((BlockPylon) class_2248.method_9503(stack.method_7909())).variant;
				RenderTilePylon.forceTransform = type;
				class_827<TilePylon> r = class_824.field_4346.method_3550(DUMMY.method_15332());
				if (r instanceof RenderTilePylon) {
					((RenderTilePylon) r).renderPylon(null, 0, ms, buffers, light, overlay);
				}
			}
		}
	}
}
