/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.tile;

import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;
import vazkii.botania.common.block.tile.mana.TilePump;

public class RenderTilePump extends class_827<TilePump> {
	public static class_1087 headModel = null;

	public RenderTilePump(class_824 manager) {
		super(manager);
	}

	@Override
	public void render(TilePump pump, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();
		ms.method_22904(0.5, 0, 0.5);
		float angle = 0;
		switch (pump.method_11010().method_11654(class_2741.field_12481)) {
		default:
		case field_11043:
			break;
		case field_11035:
			angle = 180;
			break;
		case field_11034:
			angle = -90;
			break;
		case field_11039:
			angle = 90;
			break;
		}
		ms.method_22907(class_1160.field_20705.method_23214(angle));
		ms.method_22904(-0.5, 0, -0.5);
		double diff = Math.max(0F, Math.min(8F, pump.innerRingPos + pump.moving * partialTicks));
		ms.method_22904(0, 0, diff / 14);
		class_4588 buffer = buffers.getBuffer(class_1921.method_23577());
		class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, null, headModel, 1, 1, 1, light, overlay);
		ms.method_22909();
	}
}
